/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.actor;

import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.FleeableBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleEndPacket;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B)\u0012\u0006\u0010)\u001a\u00020(\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\b\b\u0002\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0014\u001a\u00020\u00132\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/battles/actor/PokemonBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/EntityBackedBattleActor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/battles/model/actor/FleeableBattleActor;", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "Lkotlin/Pair;", "Lnet/minecraft/class_3218;", "Lnet/minecraft/class_243;", "getWorldAndPosition", "()Lkotlin/Pair;", "", "name", "nameOwned", "(Ljava/lang/String;)Lnet/minecraft/class_5250;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "", "fleeDistance", "F", "getFleeDistance", "()F", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "Ljava/util/UUID;", "uuid", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "artificialDecider", "<init>", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;FLcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;)V", "common"})
public class PokemonBattleActor
extends AIBattleActor
implements EntityBackedBattleActor<PokemonEntity>,
FleeableBattleActor {
    @NotNull
    private final BattlePokemon pokemon;
    private final float fleeDistance;
    @NotNull
    private final ActorType type;

    public PokemonBattleActor(@NotNull UUID uuid2, @NotNull BattlePokemon pokemon, float fleeDistance, @NotNull BattleAI artificialDecider) {
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        Intrinsics.checkNotNullParameter(artificialDecider, "artificialDecider");
        super(uuid2, CollectionsKt.listOf(pokemon), artificialDecider);
        this.pokemon = pokemon;
        this.fleeDistance = fleeDistance;
        this.type = ActorType.WILD;
    }

    public /* synthetic */ PokemonBattleActor(UUID uUID, BattlePokemon battlePokemon, float f, BattleAI battleAI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            battleAI = new RandomBattleAI();
        }
        this(uUID, battlePokemon, f, battleAI);
    }

    @NotNull
    public final BattlePokemon getPokemon() {
        return this.pokemon;
    }

    @Override
    public float getFleeDistance() {
        return this.fleeDistance;
    }

    @Override
    @NotNull
    public class_5250 getName() {
        return this.pokemon.getEffectedPokemon().getSpecies().getTranslatedName();
    }

    @Override
    @NotNull
    public class_5250 nameOwned(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        class_5250 class_52502 = class_2561.method_43470((String)name);
        Intrinsics.checkNotNullExpressionValue(class_52502, "literal(name)");
        return class_52502;
    }

    @Override
    @Nullable
    public Pair<class_3218, class_243> getWorldAndPosition() {
        class_3222 ownerPlayer = this.pokemon.getEffectedPokemon().getOwnerPlayer();
        if (ownerPlayer != null) {
            return TuplesKt.to(ownerPlayer.method_51469(), ownerPlayer.method_19538());
        }
        PokemonEntity pokemonEntity = this.getEntity();
        if (pokemonEntity == null) {
            return null;
        }
        PokemonEntity entity2 = pokemonEntity;
        class_1937 class_19372 = entity2.method_37908();
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return null;
        }
        class_3218 world = class_32182;
        return TuplesKt.to(world, entity2.method_19538());
    }

    @Override
    public void sendUpdate(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        super.sendUpdate(packet);
        if (packet instanceof BattleEndPacket) {
            PokemonEntity pokemonEntity = this.getEntity();
            if (pokemonEntity == null) {
                return;
            }
            PokemonEntity entity2 = pokemonEntity;
            entity2.setBattleId(null);
        }
    }

    @Override
    @Nullable
    public PokemonEntity getEntity() {
        return this.pokemon.getEntity();
    }

    @Override
    @NotNull
    public ActorType getType() {
        return this.type;
    }
}

