/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.HealingMachineBlock;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 W2\u00020\u0001:\u0002WXB\u0017\u0012\u0006\u0010R\u001a\u00020Q\u0012\u0006\u0010T\u001a\u00020S\u00a2\u0006\u0004\bU\u0010VJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000bJ\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\u0015\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u000bJ\u000f\u0010\u001f\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010%\u001a\u00020\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b'\u0010\u000bJ\u0017\u0010(\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b(\u0010\u0018R$\u0010*\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R(\u0010.\u001a\u0004\u0018\u00010\u001a2\b\u0010)\u001a\u0004\u0018\u00010\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u0018\u00103\u001a\u0004\u0018\u0001028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\"\u00105\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010+\u001a\u0004\b6\u0010-\"\u0004\b7\u00108R\"\u0010:\u001a\u0002098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\"\u0010@\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bF\u0010CR\"\u0010G\u001a\u0002098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010;\u001a\u0004\bH\u0010=\"\u0004\bI\u0010?R \u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120M8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bP\u0010\u000b\u001a\u0004\bN\u0010O\u00a8\u0006Y"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "Lnet/minecraft/class_2586;", "Lnet/minecraft/class_3222;", "player", "", "activate", "(Lnet/minecraft/class_3222;)V", "", "canHeal", "(Lnet/minecraft/class_3222;)Z", "cancelRemoval", "()V", "clearData", "completeHealing", "markRemoved", "markUpdated", "", "", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBalls", "()Ljava/util/Map;", "Lnet/minecraft/class_2487;", "compoundTag", "readNbt", "(Lnet/minecraft/class_2487;)V", "restoreSnapshot", "Ljava/util/UUID;", "user", "setUser", "(Ljava/util/UUID;)V", "snapshotAndClearData", "toInitialChunkDataNbt", "()Lnet/minecraft/class_2487;", "Lnet/minecraft/class_2622;", "toUpdatePacket", "()Lnet/minecraft/class_2622;", "level", "updateBlockChargeLevel", "(Ljava/lang/Integer;)V", "updateRedstoneSignal", "writeNbt", "<set-?>", "currentSignal", "I", "getCurrentSignal", "()I", "currentUser", "Ljava/util/UUID;", "getCurrentUser", "()Ljava/util/UUID;", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "dataSnapshot", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "healTimeLeft", "getHealTimeLeft", "setHealTimeLeft", "(I)V", "", "healingCharge", "F", "getHealingCharge", "()F", "setHealingCharge", "(F)V", "infinite", "Z", "getInfinite", "()Z", "setInfinite", "(Z)V", "isInUse", "maxCharge", "getMaxCharge", "setMaxCharge", "", "pokeBallMap", "Ljava/util/Map;", "", "getPokeBalls", "()Ljava/util/List;", "getPokeBalls$annotations", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_2680;", "blockState", "<init>", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V", "Companion", "DataSnapshot", "common"})
@SourceDebugExtension(value={"SMAP\nHealingMachineBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealingMachineBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1864#2,3:295\n215#3,2:298\n1#4:300\n*S KotlinDebug\n*F\n+ 1 HealingMachineBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity\n*L\n89#1:295,3\n177#1:298,2\n*E\n"})
public final class HealingMachineBlockEntity
extends class_2586 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID currentUser;
    private int healTimeLeft;
    private float healingCharge;
    private boolean infinite;
    private int currentSignal;
    private float maxCharge;
    @Nullable
    private DataSnapshot dataSnapshot;
    @NotNull
    private final Map<Integer, PokeBall> pokeBallMap;
    @NotNull
    private static final HashSet<UUID> alreadyHealing = new HashSet();
    public static final int MAX_REDSTONE_SIGNAL = 10;
    @NotNull
    private static final class_5558<HealingMachineBlockEntity> TICKER = HealingMachineBlockEntity::TICKER$lambda$3;

    public HealingMachineBlockEntity(@NotNull class_2338 blockPos2, @NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter(blockPos2, "blockPos");
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        super(CobblemonBlockEntities.HEALING_MACHINE, blockPos2, blockState);
        this.maxCharge = 6.0f;
        this.pokeBallMap = new HashMap();
        this.maxCharge = RangesKt.coerceAtLeast(Cobblemon.INSTANCE.getConfig().getMaxHealerCharge(), 6.0f);
        this.updateRedstoneSignal();
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
    }

    @Nullable
    public final UUID getCurrentUser() {
        return this.currentUser;
    }

    @NotNull
    public final List<PokeBall> getPokeBalls() {
        return CollectionsKt.toMutableList(this.pokeBalls().values());
    }

    @Deprecated(message="This property will be removed in the future", replaceWith=@ReplaceWith(expression="pokeBalls()", imports={}))
    public static /* synthetic */ void getPokeBalls$annotations() {
    }

    public final int getHealTimeLeft() {
        return this.healTimeLeft;
    }

    public final void setHealTimeLeft(int n) {
        this.healTimeLeft = n;
    }

    public final float getHealingCharge() {
        return this.healingCharge;
    }

    public final void setHealingCharge(float f) {
        this.healingCharge = f;
    }

    public final boolean isInUse() {
        return this.currentUser != null;
    }

    public final boolean getInfinite() {
        return this.infinite;
    }

    public final void setInfinite(boolean bl) {
        this.infinite = bl;
    }

    public final int getCurrentSignal() {
        return this.currentSignal;
    }

    public final float getMaxCharge() {
        return this.maxCharge;
    }

    public final void setMaxCharge(float f) {
        this.maxCharge = f;
    }

    @NotNull
    public final Map<Integer, PokeBall> pokeBalls() {
        return this.pokeBallMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUser(@NotNull UUID user) {
        Intrinsics.checkNotNullParameter(user, "user");
        this.clearData();
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer(user);
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        PlayerPartyStore party = PlayerExtensionsKt.party(player);
        this.pokeBallMap.clear();
        Iterable $this$forEachIndexed$iv = party.toGappyList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            if (pokemon == null) continue;
            Integer n2 = index;
            this.pokeBallMap.put(n2, pokemon.getCaughtBall());
        }
        this.currentUser = user;
        this.healTimeLeft = 24;
        this.markUpdated();
    }

    public final boolean canHeal(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            return true;
        }
        float neededHealthPercent = PlayerExtensionsKt.party(player).getHealingRemainderPercent();
        return this.healingCharge >= neededHealthPercent;
    }

    public final void activate(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() && !(this.healingCharge == this.maxCharge)) {
            float neededHealthPercent = PlayerExtensionsKt.party(player).getHealingRemainderPercent();
            this.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(this.healingCharge - neededHealthPercent), RangesKt.rangeTo(0.0f, this.maxCharge))).floatValue();
            this.updateRedstoneSignal();
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        this.setUser(uUID);
        alreadyHealing.add(player.method_5667());
        this.updateBlockChargeLevel(6);
        if (this.field_11863 != null) {
            class_1937 class_19372 = this.field_11863;
            Intrinsics.checkNotNull(class_19372);
            if (!class_19372.field_9236) {
                class_1937 class_19373 = this.field_11863;
                Intrinsics.checkNotNull(class_19373);
                class_2338 class_23382 = this.field_11867;
                Intrinsics.checkNotNullExpressionValue(class_23382, "pos");
                WorldExtensionsKt.playSoundServer$default(class_19373, BlockPosExtensionsKt.toVec3d(class_23382), CobblemonSounds.HEALING_MACHINE_ACTIVE, null, 1.0f, 1.0f, 4, null);
            }
        }
    }

    public final void completeHealing() {
        UUID uUID = this.currentUser;
        if (uUID == null || (uUID = PlayerExtensionsKt.getPlayer(uUID)) == null) {
            this.clearData();
            return;
        }
        UUID player = uUID;
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        party.heal();
        class_5250 class_52502 = LocalizationUtilsKt.lang("healingmachine.healed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"healingmachine.healed\")");
        player.method_7353((class_2561)TextKt.green(class_52502), true);
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
        this.clearData();
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter(compoundTag, "compoundTag");
        super.method_11014(compoundTag);
        this.pokeBallMap.clear();
        if (compoundTag.method_25928("MachineUser")) {
            this.currentUser = compoundTag.method_25926("MachineUser");
        }
        if (compoundTag.method_10545("MachinePokeBalls")) {
            class_2487 pokeBallsTag = compoundTag.method_10562("MachinePokeBalls");
            int index = 0;
            for (String key : pokeBallsTag.method_10541()) {
                String pokeBallId = pokeBallsTag.method_10558(key);
                Intrinsics.checkNotNullExpressionValue(pokeBallId, "pokeBallId");
                if (((CharSequence)pokeBallId).length() == 0) continue;
                Intrinsics.checkNotNullExpressionValue(key, "key");
                Integer n = StringsKt.toIntOrNull(key);
                int actualIndex = n != null ? n : index;
                PokeBall pokeBall = PokeBalls.INSTANCE.getPokeBall(new class_2960(pokeBallId));
                if (pokeBall != null) {
                    Integer n2 = actualIndex;
                    this.pokeBallMap.put(n2, pokeBall);
                }
                ++index;
            }
        }
        if (compoundTag.method_10545("MachineTimeLeft")) {
            this.healTimeLeft = compoundTag.method_10550("MachineTimeLeft");
        }
        if (compoundTag.method_10545("MachineCharge")) {
            this.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(compoundTag.method_10583("MachineCharge")), RangesKt.rangeTo(0.0f, this.maxCharge))).floatValue();
        }
        if (compoundTag.method_10545("MachineInfinite")) {
            this.infinite = compoundTag.method_10577("MachineInfinite");
        }
    }

    protected void method_11007(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter(compoundTag, "compoundTag");
        super.method_11007(compoundTag);
        if (this.currentUser != null) {
            UUID uUID = this.currentUser;
            Intrinsics.checkNotNull(uUID);
            compoundTag.method_25927("MachineUser", uUID);
        } else {
            compoundTag.method_10551("MachineUser");
        }
        if (!this.pokeBalls().isEmpty()) {
            class_2487 pokeBallsTag = new class_2487();
            Map<Integer, PokeBall> $this$forEach$iv = this.pokeBalls();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Integer, PokeBall>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Integer, PokeBall> element$iv;
                Map.Entry<Integer, PokeBall> entry = element$iv = iterator2.next();
                boolean bl = false;
                int index = ((Number)entry.getKey()).intValue();
                PokeBall pokeBall = entry.getValue();
                pokeBallsTag.method_10582(String.valueOf(index), pokeBall.getName().toString());
            }
            compoundTag.method_10566("MachinePokeBalls", (class_2520)pokeBallsTag);
        } else {
            compoundTag.method_10551("MachinePokeBalls");
        }
        compoundTag.method_10569("MachineTimeLeft", this.healTimeLeft);
        compoundTag.method_10548("MachineCharge", this.healingCharge);
        compoundTag.method_10556("MachineInfinite", this.infinite);
    }

    @NotNull
    public class_2622 toUpdatePacket() {
        class_2622 class_26222 = class_2622.method_38585((class_2586)this);
        Intrinsics.checkNotNullExpressionValue(class_26222, "create(this)");
        return class_26222;
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 class_24872 = super.method_38242();
        Intrinsics.checkNotNullExpressionValue(class_24872, "super.createNbtWithIdentifyingData()");
        return class_24872;
    }

    public void method_11012() {
        this.snapshotAndClearData();
        super.method_11012();
    }

    public void method_10996() {
        this.restoreSnapshot();
        super.method_10996();
    }

    private final void updateRedstoneSignal() {
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            this.currentSignal = 10;
        }
        int remainder = (int)(this.healingCharge / this.maxCharge * (float)100) / 10;
        this.currentSignal = RangesKt.coerceAtMost(remainder, 10);
    }

    private final void updateBlockChargeLevel(Integer level) {
        if (this.field_11863 != null) {
            class_1937 class_19372 = this.field_11863;
            Intrinsics.checkNotNull(class_19372);
            if (!class_19372.field_9236) {
                int currentCharge;
                Integer n = level;
                int chargeLevel = RangesKt.coerceIn(n != null ? n : (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite ? 5 : (int)Math.floor(this.healingCharge / this.maxCharge * (float)5)), new IntRange(0, 6));
                class_1937 class_19373 = this.field_11863;
                Intrinsics.checkNotNull(class_19373);
                class_2680 state = class_19373.method_8320(this.field_11867);
                if (state != null && state.method_26204() instanceof HealingMachineBlock && chargeLevel != (currentCharge = ((Number)((Object)state.method_11654((class_2769)HealingMachineBlock.Companion.getCHARGE_LEVEL()))).intValue())) {
                    class_1937 class_19374 = this.field_11863;
                    Intrinsics.checkNotNull(class_19374);
                    class_19374.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)HealingMachineBlock.Companion.getCHARGE_LEVEL(), (Comparable)Integer.valueOf(chargeLevel)));
                }
            }
        }
    }

    static /* synthetic */ void updateBlockChargeLevel$default(HealingMachineBlockEntity healingMachineBlockEntity, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        healingMachineBlockEntity.updateBlockChargeLevel(n);
    }

    private final void markUpdated() {
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        Intrinsics.checkNotNull(class_19372);
        class_19372.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    private final void snapshotAndClearData() {
        this.dataSnapshot = new DataSnapshot(this.currentUser, this.pokeBalls(), this.healTimeLeft);
        this.clearData();
    }

    private final void clearData() {
        UUID uUID = this.currentUser;
        if (uUID != null) {
            UUID uUID2 = uUID;
            HashSet<UUID> hashSet = alreadyHealing;
            UUID p0 = uUID2;
            boolean bl = false;
            hashSet.remove(p0);
        }
        this.currentUser = null;
        this.pokeBallMap.clear();
        this.healTimeLeft = 0;
        this.markUpdated();
    }

    private final void restoreSnapshot() {
        block0: {
            DataSnapshot dataSnapshot = this.dataSnapshot;
            if (dataSnapshot == null) break block0;
            DataSnapshot it = dataSnapshot;
            boolean bl = false;
            this.pokeBallMap.clear();
            this.currentUser = it.getCurrentUser();
            this.pokeBallMap.putAll(it.getPokeBalls());
            this.healTimeLeft = it.getHealTimeLeft();
        }
    }

    private static final void TICKER$lambda$3(class_1937 world, class_2338 class_23382, class_2680 class_26802, HealingMachineBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (blockEntity.isInUse()) {
            if (blockEntity.healTimeLeft > 0) {
                int n = blockEntity.healTimeLeft;
                blockEntity.healTimeLeft = n + -1;
            } else {
                blockEntity.completeHealing();
            }
        } else if (blockEntity.healingCharge < blockEntity.maxCharge) {
            float chargePerTick = RangesKt.coerceAtLeast(Cobblemon.INSTANCE.getConfig().getChargeGainedPerTick(), 0.0f);
            blockEntity.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(blockEntity.healingCharge + chargePerTick), RangesKt.rangeTo(0.0f, blockEntity.maxCharge))).floatValue();
            Intrinsics.checkNotNullExpressionValue((Object)blockEntity, "blockEntity");
            HealingMachineBlockEntity.updateBlockChargeLevel$default(blockEntity, null, 1, null);
            blockEntity.updateRedstoneSignal();
            blockEntity.markUpdated();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$Companion;", "", "Lnet/minecraft/class_1657;", "player", "", "isUsingHealer", "(Lnet/minecraft/class_1657;)Z", "", "MAX_REDSTONE_SIGNAL", "I", "Lnet/minecraft/class_5558;", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "TICKER", "Lnet/minecraft/class_5558;", "getTICKER$common", "()Lnet/minecraft/class_5558;", "Ljava/util/HashSet;", "Ljava/util/UUID;", "Lkotlin/collections/HashSet;", "alreadyHealing", "Ljava/util/HashSet;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_5558<HealingMachineBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public final boolean isUsingHealer(@NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return alreadyHealing.contains(player.method_5667());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0002\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010 J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ<\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00022\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0019\u0010\f\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0019\u001a\u0004\b\u001a\u0010\u0004R\u0017\u0010\u000e\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001b\u001a\u0004\b\u001c\u0010\u000bR#\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b\u001e\u0010\t\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "", "Ljava/util/UUID;", "component1", "()Ljava/util/UUID;", "", "", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "component2", "()Ljava/util/Map;", "component3", "()I", "currentUser", "pokeBalls", "healTimeLeft", "copy", "(Ljava/util/UUID;Ljava/util/Map;I)Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getCurrentUser", "I", "getHealTimeLeft", "Ljava/util/Map;", "getPokeBalls", "<init>", "(Ljava/util/UUID;Ljava/util/Map;I)V", "common"})
    private static final class DataSnapshot {
        @Nullable
        private final UUID currentUser;
        @NotNull
        private final Map<Integer, PokeBall> pokeBalls;
        private final int healTimeLeft;

        public DataSnapshot(@Nullable UUID currentUser, @NotNull Map<Integer, ? extends PokeBall> pokeBalls, int healTimeLeft) {
            Intrinsics.checkNotNullParameter(pokeBalls, "pokeBalls");
            this.currentUser = currentUser;
            this.pokeBalls = pokeBalls;
            this.healTimeLeft = healTimeLeft;
        }

        @Nullable
        public final UUID getCurrentUser() {
            return this.currentUser;
        }

        @NotNull
        public final Map<Integer, PokeBall> getPokeBalls() {
            return this.pokeBalls;
        }

        public final int getHealTimeLeft() {
            return this.healTimeLeft;
        }

        @Nullable
        public final UUID component1() {
            return this.currentUser;
        }

        @NotNull
        public final Map<Integer, PokeBall> component2() {
            return this.pokeBalls;
        }

        public final int component3() {
            return this.healTimeLeft;
        }

        @NotNull
        public final DataSnapshot copy(@Nullable UUID currentUser, @NotNull Map<Integer, ? extends PokeBall> pokeBalls, int healTimeLeft) {
            Intrinsics.checkNotNullParameter(pokeBalls, "pokeBalls");
            return new DataSnapshot(currentUser, pokeBalls, healTimeLeft);
        }

        public static /* synthetic */ DataSnapshot copy$default(DataSnapshot dataSnapshot, UUID uUID, Map map, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = dataSnapshot.currentUser;
            }
            if ((n2 & 2) != 0) {
                map = dataSnapshot.pokeBalls;
            }
            if ((n2 & 4) != 0) {
                n = dataSnapshot.healTimeLeft;
            }
            return dataSnapshot.copy(uUID, map, n);
        }

        @NotNull
        public String toString() {
            return "DataSnapshot(currentUser=" + this.currentUser + ", pokeBalls=" + this.pokeBalls + ", healTimeLeft=" + this.healTimeLeft + ")";
        }

        public int hashCode() {
            int result = this.currentUser == null ? 0 : this.currentUser.hashCode();
            result = result * 31 + ((Object)this.pokeBalls).hashCode();
            result = result * 31 + Integer.hashCode(this.healTimeLeft);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataSnapshot)) {
                return false;
            }
            DataSnapshot dataSnapshot = (DataSnapshot)other;
            if (!Intrinsics.areEqual(this.currentUser, dataSnapshot.currentUser)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pokeBalls, dataSnapshot.pokeBalls)) {
                return false;
            }
            return this.healTimeLeft == dataSnapshot.healTimeLeft;
        }
    }
}

