/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.battle.animations;

import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.animations.TileAnimation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/client/battle/animations/SwapAndMoveTileOnscreenAnimation;", "Lcom/cobblemon/mod/common/client/battle/animations/TileAnimation;", "Lcom/cobblemon/mod/common/client/battle/ActiveClientBattlePokemon;", "activeBattlePokemon", "", "deltaTicks", "", "invoke", "(Lcom/cobblemon/mod/common/client/battle/ActiveClientBattlePokemon;F)Z", "shouldHoldUntilNextAnimation", "()Z", "Lcom/cobblemon/mod/common/client/battle/ClientBattlePokemon;", "battlePokemon", "Lcom/cobblemon/mod/common/client/battle/ClientBattlePokemon;", "getBattlePokemon", "()Lcom/cobblemon/mod/common/client/battle/ClientBattlePokemon;", "duration", "F", "getDuration", "()F", "passedSeconds", "getPassedSeconds", "setPassedSeconds", "(F)V", "<init>", "(Lcom/cobblemon/mod/common/client/battle/ClientBattlePokemon;F)V", "common"})
public final class SwapAndMoveTileOnscreenAnimation
implements TileAnimation {
    @NotNull
    private final ClientBattlePokemon battlePokemon;
    private final float duration;
    private float passedSeconds;

    public SwapAndMoveTileOnscreenAnimation(@NotNull ClientBattlePokemon battlePokemon, float duration) {
        Intrinsics.checkNotNullParameter(battlePokemon, "battlePokemon");
        this.battlePokemon = battlePokemon;
        this.duration = duration;
    }

    public /* synthetic */ SwapAndMoveTileOnscreenAnimation(ClientBattlePokemon clientBattlePokemon, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.75f;
        }
        this(clientBattlePokemon, f);
    }

    @NotNull
    public final ClientBattlePokemon getBattlePokemon() {
        return this.battlePokemon;
    }

    public final float getDuration() {
        return this.duration;
    }

    public final float getPassedSeconds() {
        return this.passedSeconds;
    }

    public final void setPassedSeconds(float f) {
        this.passedSeconds = f;
    }

    @Override
    public boolean shouldHoldUntilNextAnimation() {
        return false;
    }

    @Override
    public boolean invoke(@NotNull ActiveClientBattlePokemon activeBattlePokemon, float deltaTicks) {
        Intrinsics.checkNotNullParameter(activeBattlePokemon, "activeBattlePokemon");
        if (this.passedSeconds == 0.0f) {
            activeBattlePokemon.setBattlePokemon(this.battlePokemon);
        }
        this.passedSeconds += deltaTicks / (float)20;
        this.passedSeconds = RangesKt.coerceAtMost(this.passedSeconds, this.duration);
        float ratio = this.passedSeconds / this.duration;
        float totalMovement = activeBattlePokemon.getInvisibleX() - activeBattlePokemon.getXDisplacement();
        float currentMovement = totalMovement * (1.0f - ratio);
        activeBattlePokemon.setXDisplacement(activeBattlePokemon.getXDisplacement() + currentMovement);
        return this.passedSeconds == this.duration;
    }
}

