/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.MoveCategoryIcon;
import com.cobblemon.mod.common.client.gui.TypeIcon;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.client.gui.summary.widgets.common.SummaryScrollList;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MovesWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.net.messages.server.BenchMovePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.math.SimpleMathExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B'\u0012\u0006\u0010\u0013\u001a\u00020\u0004\u0012\u0006\u0010\u0014\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen;", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/common/SummaryScrollList;", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen$MoveSlot;", "entry", "", "addEntry", "(Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen$MoveSlot;)I", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MovesWidget;", "movesWidget", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MovesWidget;", "getMovesWidget", "()Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MovesWidget;", "Lcom/cobblemon/mod/common/api/moves/Move;", "replacedMove", "Lcom/cobblemon/mod/common/api/moves/Move;", "getReplacedMove", "()Lcom/cobblemon/mod/common/api/moves/Move;", "setReplacedMove", "(Lcom/cobblemon/mod/common/api/moves/Move;)V", "x", "y", "<init>", "(IILcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MovesWidget;Lcom/cobblemon/mod/common/api/moves/Move;)V", "Companion", "MoveSlot", "common"})
public final class MoveSwapScreen
extends SummaryScrollList<MoveSlot> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MovesWidget movesWidget;
    @NotNull
    private Move replacedMove;
    public static final int SLOT_HEIGHT = 18;
    public static final int SLOT_SPACING = 3;
    @NotNull
    private static final class_2960 moveResource = MiscUtilsKt.cobblemonResource("textures/gui/summary/summary_move_condensed.png");
    @NotNull
    private static final class_2960 moveOverlayResource = MiscUtilsKt.cobblemonResource("textures/gui/summary/summary_move_overlay_condensed.png");

    public MoveSwapScreen(int x, int y, @NotNull MovesWidget movesWidget, @NotNull Move replacedMove) {
        Intrinsics.checkNotNullParameter((Object)movesWidget, "movesWidget");
        Intrinsics.checkNotNullParameter(replacedMove, "replacedMove");
        class_5250 class_52502 = LocalizationUtilsKt.lang("ui.moves.switch", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"ui.moves.switch\")");
        super(x, y, class_52502, 21);
        this.movesWidget = movesWidget;
        this.replacedMove = replacedMove;
    }

    @NotNull
    public final MovesWidget getMovesWidget() {
        return this.movesWidget;
    }

    @NotNull
    public final Move getReplacedMove() {
        return this.replacedMove;
    }

    public final void setReplacedMove(@NotNull Move move) {
        Intrinsics.checkNotNullParameter(move, "<set-?>");
        this.replacedMove = move;
    }

    public int addEntry(@NotNull MoveSlot entry) {
        Intrinsics.checkNotNullParameter((Object)entry, "entry");
        return super.method_25321((class_350.class_351)entry);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen$Companion;", "", "", "SLOT_HEIGHT", "I", "SLOT_SPACING", "Lnet/minecraft/class_2960;", "moveOverlayResource", "Lnet/minecraft/class_2960;", "moveResource", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010&\u001a\u00020\b\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ_\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen$MoveSlot;", "Lnet/minecraft/client/gui/widget/AlwaysSelectedEntryListWidget$Entry;", "Lnet/minecraft/class_5250;", "getNarration", "()Lnet/minecraft/class_5250;", "", "d", "e", "", "i", "", "mouseClicked", "(DDI)Z", "Lnet/minecraft/class_332;", "context", "index", "rowTop", "rowLeft", "rowWidth", "rowHeight", "mouseX", "mouseY", "isHovered", "", "partialTicks", "", "render", "(Lnet/minecraft/class_332;IIIIIIIZF)V", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "move", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getMove", "()Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen;", "pane", "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen;", "getPane", "()Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen;", "ppRaisedStages", "I", "getPpRaisedStages", "()I", "<init>", "(Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/moves/MoveSwapScreen;Lcom/cobblemon/mod/common/api/moves/MoveTemplate;I)V", "common"})
    public static final class MoveSlot
    extends class_4280.class_4281<MoveSlot> {
        @NotNull
        private final MoveSwapScreen pane;
        @NotNull
        private final MoveTemplate move;
        private final int ppRaisedStages;

        public MoveSlot(@NotNull MoveSwapScreen pane, @NotNull MoveTemplate move, int ppRaisedStages) {
            Intrinsics.checkNotNullParameter((Object)pane, "pane");
            Intrinsics.checkNotNullParameter(move, "move");
            this.pane = pane;
            this.move = move;
            this.ppRaisedStages = ppRaisedStages;
        }

        @NotNull
        public final MoveSwapScreen getPane() {
            return this.pane;
        }

        @NotNull
        public final MoveTemplate getMove() {
            return this.move;
        }

        public final int getPpRaisedStages() {
            return this.ppRaisedStages;
        }

        @NotNull
        public class_5250 getNarration() {
            return this.move.getDisplayName();
        }

        public void method_25343(@NotNull class_332 context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            Intrinsics.checkNotNullParameter(context, "context");
            class_4587 matrices = context.method_51448();
            int tweakedRowTop = rowTop - 1 + 1;
            Triple<Double, Double, Double> rgb = SimpleMathExtensionsKt.toRGB(this.move.getElementalType().getHue());
            Intrinsics.checkNotNullExpressionValue(matrices, "matrices");
            GuiUtilsKt.blitk$default(matrices, moveResource, rowLeft, tweakedRowTop, 18, rowWidth, null, isHovered ? 18 : 0, null, 36, null, rgb.getFirst(), rgb.getSecond(), rgb.getThird(), null, false, 0.0f, 116032, null);
            GuiUtilsKt.blitk$default(matrices, moveOverlayResource, rowLeft, tweakedRowTop, 18, rowWidth, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
            new TypeIcon(rowLeft - 9, tweakedRowTop, this.move.getElementalType(), null, false, false, 0.0f, 0.0f, 0.0f, 504, null).render(context);
            new MoveCategoryIcon(rowLeft + 77, (double)tweakedRowTop + 1.5, this.move.getDamageCategory(), 0.0f, 8, null).render(context);
            RenderHelperKt.drawScaledText$default(context, null, this.move.getDisplayName(), rowLeft + 14, (double)tweakedRowTop + 3.5, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
            class_2960 class_29602 = MovesWidget.Companion.getMovesPowerIconResource();
            float f = (float)(rowLeft + 10) / 0.5f;
            float f2 = (float)(tweakedRowTop + 11) / 0.5f;
            GuiUtilsKt.blitk$default(matrices, class_29602, Float.valueOf(f), Float.valueOf(f2), 10, 10, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
            class_29602 = MovesWidget.Companion.getMovesAccuracyIconResource();
            f = (float)(rowLeft + 30) / 0.5f;
            f2 = (float)(tweakedRowTop + 11) / 0.5f;
            GuiUtilsKt.blitk$default(matrices, class_29602, Float.valueOf(f), Float.valueOf(f2), 10, 10, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
            class_29602 = MovesWidget.Companion.getMovesEffectIconResource();
            double d = ((double)rowLeft + 53.5) / (double)0.5f;
            float f3 = (float)(tweakedRowTop + 11) / 0.5f;
            GuiUtilsKt.blitk$default(matrices, class_29602, d, Float.valueOf(f3), 10, 10, null, null, null, null, null, null, null, null, null, false, 0.5f, 65472, null);
            class_5250 movePower = (int)this.move.getPower() > 0 ? TextKt.text(String.valueOf((int)this.move.getPower())) : TextKt.text("\u2014");
            RenderHelperKt.drawScaledText$default(context, null, movePower, (double)rowLeft + 16.5, tweakedRowTop + 12, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
            RenderHelperKt.drawScaledText$default(context, null, TextKt.text(this.pane.getMovesWidget().format(this.move.getAccuracy())), rowLeft + 37, tweakedRowTop + 12, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
            Double d2 = ArraysKt.firstOrNull(this.move.getEffectChances());
            RenderHelperKt.drawScaledText$default(context, null, TextKt.text(this.pane.getMovesWidget().format(d2 != null ? d2 : 0.0)), (double)rowLeft + 60.5, tweakedRowTop + 12, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
            int pp = this.move.getPp() + this.ppRaisedStages * this.move.getPp() / 5;
            Object[] objectArray = new Object[]{pp};
            class_5250 class_52502 = LocalizationUtilsKt.lang("ui.moves.pp", objectArray);
            Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"ui.moves.pp\", pp)");
            RenderHelperKt.drawScaledText$default(context, null, class_52502, rowLeft + 76, tweakedRowTop + 12, 0.5f, null, 0, 0, false, true, null, null, 7106, null);
        }

        public boolean method_25402(double d, double e, int i) {
            if (this.method_25405(d, e)) {
                Pokemon pokemon = this.pane.getMovesWidget().getSummary().getSelectedPokemon$common();
                boolean isParty = CollectionsKt.contains(CobblemonClient.INSTANCE.getStorage().getMyParty(), pokemon);
                UUID uUID = pokemon.getUuid();
                Intrinsics.checkNotNullExpressionValue(uUID, "pokemon.uuid");
                CobblemonNetwork.INSTANCE.sendPacketToServer(new BenchMovePacket(isParty, uUID, this.pane.getReplacedMove().getTemplate(), this.move));
                this.pane.getMovesWidget().getSummary().playSound(CobblemonSounds.GUI_CLICK);
                Summary.displaySideScreen$default(this.pane.getMovesWidget().getSummary(), 0, null, 2, null);
                return true;
            }
            return false;
        }
    }
}

