/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.berry.GrowthPoint;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import com.cobblemon.mod.common.client.render.block.BerryBlockEntityRenderState;
import com.cobblemon.mod.common.client.render.layer.CobblemonRenderLayers;
import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.BerryModelRepository;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.Axis;
import com.mojang.blaze3d.systems.RenderSystem;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_757;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ?\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0018\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/mod/common/client/render/block/BerryBlockRenderer;", "Lnet/minecraft/class_827;", "Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "blockEntity", "Lnet/minecraft/class_243;", "pos", "", "isInRenderDistance", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;Lnet/minecraft/class_243;)Z", "entity", "", "tickDelta", "Lnet/minecraft/class_4587;", "matrices", "Lnet/minecraft/class_4597;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;II)V", "Lnet/minecraft/class_291;", "buffer", "renderToBuffer", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;IILnet/minecraft/class_291;)V", "Lnet/minecraft/client/render/block/entity/BlockEntityRendererFactory$Context;", "context", "Lnet/minecraft/class_5614$class_5615;", "<init>", "(Lnet/minecraft/class_5614$class_5615;)V", "common"})
public final class BerryBlockRenderer
implements class_827<BerryBlockEntity> {
    @NotNull
    private final class_5614.class_5615 context;

    public BerryBlockRenderer(@NotNull class_5614.class_5615 context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    public boolean isInRenderDistance(@NotNull BerryBlockEntity blockEntity, @NotNull class_243 pos) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, "blockEntity");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return super.method_33892((class_2586)blockEntity, pos) && class_310.method_1551().field_1769.field_27740.method_23093(class_238.method_30048((class_243)pos, (double)2.0, (double)4.0, (double)2.0));
    }

    public void render(@NotNull BerryBlockEntity entity2, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay2) {
        Intrinsics.checkNotNullParameter((Object)entity2, "entity");
        Intrinsics.checkNotNullParameter(matrices, "matrices");
        Intrinsics.checkNotNullParameter(vertexConsumers, "vertexConsumers");
        class_2338 class_23382 = entity2.method_11016();
        Intrinsics.checkNotNullExpressionValue(class_23382, "entity.pos");
        if (!this.isInRenderDistance(entity2, BlockPosExtensionsKt.toVec3d(class_23382))) {
            return;
        }
        class_2680 blockState = entity2.method_11010();
        Integer age = (Integer)blockState.method_11654((class_2769)BerryBlock.Companion.getAGE());
        Intrinsics.checkNotNullExpressionValue(age, "age");
        if (age <= 3) {
            return;
        }
        if (entity2.getRenderState() == null) {
            entity2.setRenderState(new BerryBlockEntityRenderState());
        }
        BerryBlockEntity.RenderState renderState = entity2.getRenderState();
        Intrinsics.checkNotNull(renderState, "null cannot be cast to non-null type com.cobblemon.mod.common.client.render.block.BerryBlockEntityRenderState");
        BerryBlockEntityRenderState renderState2 = (BerryBlockEntityRenderState)renderState;
        if (renderState2.getNeedsRebuild() || renderState2.getVboLightLevel() != light) {
            this.renderToBuffer(entity2, light, overlay2, renderState2.getVbo());
            renderState2.setVboLightLevel(light);
            BerryBlockEntity.RenderState renderState3 = entity2.getRenderState();
            Intrinsics.checkNotNull(renderState3, "null cannot be cast to non-null type com.cobblemon.mod.common.client.render.block.BerryBlockEntityRenderState");
            ((BerryBlockEntityRenderState)renderState3).setNeedsRebuild(false);
        }
        matrices.method_22903();
        CobblemonRenderLayers.INSTANCE.getBERRY_LAYER().method_23516();
        renderState2.getVbo().method_1353();
        renderState2.getVbo().method_34427(matrices.method_23760().method_23761().mul((Matrix4fc)RenderSystem.getModelViewMatrix()), RenderSystem.getProjectionMatrix(), class_757.method_34497());
        class_291.method_1354();
        CobblemonRenderLayers.INSTANCE.getBERRY_LAYER().method_23518();
        matrices.method_22909();
    }

    public final void renderToBuffer(@NotNull BerryBlockEntity entity2, int light, int overlay2, @NotNull class_291 buffer) {
        Intrinsics.checkNotNullParameter((Object)entity2, "entity");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        class_2680 blockState = entity2.method_11010();
        Integer age = (Integer)blockState.method_11654((class_2769)BerryBlock.Companion.getAGE());
        Intrinsics.checkNotNullExpressionValue(age, "age");
        if (age <= 3) {
            return;
        }
        int n = 4;
        boolean isFlower = age == n;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(CobblemonRenderLayers.INSTANCE.getBERRY_LAYER().method_23033(), CobblemonRenderLayers.INSTANCE.getBERRY_LAYER().method_23031());
        for (Pair<Berry, GrowthPoint> pair : entity2.berryAndGrowthPoint$common()) {
            class_630 model;
            Berry berry = pair.component1();
            GrowthPoint growthPoint = pair.component2();
            if ((isFlower ? BerryModelRepository.INSTANCE.modelOf(berry.getFlowerModelIdentifier()) : BerryModelRepository.INSTANCE.modelOf(berry.getFruitModelIdentifier())) == null) continue;
            model = model;
            model.method_33425((float)Math.toRadians(180.0 - growthPoint.getRotation().field_1352), (float)Math.toRadians(180.0 + growthPoint.getRotation().field_1351), (float)Math.toRadians(growthPoint.getRotation().field_1350));
            ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)growthPoint.getPosition().field_1352);
            ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)growthPoint.getPosition().field_1351);
            ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), (float)growthPoint.getPosition().field_1350);
            model.method_22698(new class_4587(), (class_4588)bufferBuilder, light, overlay2);
        }
        class_287.class_7433 bufferBuilderFinal = bufferBuilder.method_1326();
        buffer.method_1353();
        buffer.method_1352(bufferBuilderFinal);
        class_291.method_1354();
    }
}

