/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.settings.ServerSettings;
import com.cobblemon.mod.common.command.PokeboxCommand;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ?\u0010\f\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012R(\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u001c\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/PokeboxCommand;", "", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "Lnet/minecraft/class_3222;", "player", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemons", "", "box", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;Ljava/util/Collection;Ljava/lang/Integer;)I", "Lcom/mojang/brigadier/CommandDispatcher;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lkotlin/Function1;", "Lnet/minecraft/class_5250;", "kotlin.jvm.PlatformType", "BOX_DOES_NOT_EXIST", "Lkotlin/jvm/functions/Function1;", "BOX_IS_FULL_EXCEPTION", "LAST_POKE_MESSAGE", "Lnet/minecraft/class_5250;", "STORAGE_IS_FULL_EXCEPTION", "<init>", "()V", "common"})
@SourceDebugExtension(value={"SMAP\nPokeboxCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1855#2,2:135\n*S KotlinDebug\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n*L\n103#1:135,2\n*E\n"})
public final class PokeboxCommand {
    @NotNull
    public static final PokeboxCommand INSTANCE = new PokeboxCommand();
    @NotNull
    private static final Function1<Integer, class_5250> BOX_DOES_NOT_EXIST = BOX_DOES_NOT_EXIST.1.INSTANCE;
    @NotNull
    private static final Function1<Integer, class_5250> BOX_IS_FULL_EXCEPTION = BOX_IS_FULL_EXCEPTION.1.INSTANCE;
    private static final class_5250 STORAGE_IS_FULL_EXCEPTION = LocalizationUtilsKt.commandLang("pokebox.storage_is_full", new Object[0]);
    private static final class_5250 LAST_POKE_MESSAGE = LocalizationUtilsKt.commandLang("pokebox.last_pokemon", new Object[0]);

    private PokeboxCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"pokebox");
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder, "literal(\"pokebox\")");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.INSTANCE.getPOKEBOX(), false, 2, null)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$0))).executes(PokeboxCommand::register$lambda$1))));
        LiteralArgumentBuilder literalArgumentBuilder2 = class_2170.method_9247((String)"pokeboxall");
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder2, "literal(\"pokeboxall\")");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.INSTANCE.getPOKEBOX(), false, 2, null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$2))).executes(PokeboxCommand::register$lambda$3)));
    }

    private final int execute(CommandContext<class_2168> context, class_3222 player, Collection<? extends Pokemon> pokemons, Integer box) {
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        PlayerPartyStore playerParty = PlayerExtensionsKt.party(player);
        if (box != null) {
            if (playerPc.getBoxes().size() < box) {
                class_5250 class_52502 = BOX_DOES_NOT_EXIST.invoke(box);
                Intrinsics.checkNotNullExpressionValue(class_52502, "BOX_DOES_NOT_EXIST(box)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red(class_52502)).create();
                Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "SimpleCommandExceptionTy\u2026XIST(box).red()).create()");
                throw (Throwable)commandSyntaxException;
            }
            PCBox pcBox = playerPc.getBoxes().get(box - 1);
            if (pcBox.getUnoccupiedSlots() < pokemons.size()) {
                class_5250 class_52503 = BOX_IS_FULL_EXCEPTION.invoke(box);
                Intrinsics.checkNotNullExpressionValue(class_52503, "BOX_IS_FULL_EXCEPTION(box)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red(class_52503)).create();
                Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "SimpleCommandExceptionTy\u2026TION(box).red()).create()");
                throw (Throwable)commandSyntaxException;
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)pokemons);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCPosition pCPosition;
            Pokemon pokemon = (Pokemon)element$iv;
            boolean bl = false;
            if (ServerSettings.INSTANCE.getPreventCompletePartyDeposit() && playerParty.occupied() == 1) {
                ((class_2168)context.getSource()).method_9226(PokeboxCommand::execute$lambda$5$lambda$4, false);
                return pokemons.size() - 1;
            }
            if (box == null) {
                pCPosition = playerPc.getFirstAvailablePosition();
                if (pCPosition == null) {
                    class_5250 class_52504 = STORAGE_IS_FULL_EXCEPTION;
                    Intrinsics.checkNotNullExpressionValue(class_52504, "STORAGE_IS_FULL_EXCEPTION");
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red(class_52504)).create();
                    Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "SimpleCommandExceptionTy\u2026EXCEPTION.red()).create()");
                    throw (Throwable)commandSyntaxException;
                }
            } else {
                PCBox pcBox = playerPc.getBoxes().get(box - 1);
                pCPosition = pcBox.getFirstAvailablePosition();
                if (pCPosition == null) {
                    class_5250 class_52505 = BOX_IS_FULL_EXCEPTION.invoke(box);
                    Intrinsics.checkNotNullExpressionValue(class_52505, "BOX_IS_FULL_EXCEPTION(box)");
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red(class_52505)).create();
                    Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "SimpleCommandExceptionTy\u2026TION(box).red()).create()");
                    throw (Throwable)commandSyntaxException;
                }
            }
            PCPosition pcPosition = pCPosition;
            playerParty.remove(pokemon);
            playerPc.set(pcPosition, pokemon);
            PokemonStore pokemonStore = PlayerExtensionsKt.party(player);
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue(uUID, "pokemon.uuid");
            playerParty.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
        }
        return pokemons.size();
    }

    static /* synthetic */ int execute$default(PokeboxCommand pokeboxCommand, CommandContext commandContext, class_3222 class_32222, Collection collection, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return pokeboxCommand.execute((CommandContext<class_2168>)commandContext, class_32222, collection, n);
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNullExpressionValue(player, "player");
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        return INSTANCE.execute((CommandContext<class_2168>)context, player, (Collection<? extends Pokemon>)CollectionsKt.listOf(pokemon), box);
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNullExpressionValue(player, "player");
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.listOf(pokemon), null, 8, null);
    }

    private static final int register$lambda$2(CommandContext context) {
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        Intrinsics.checkNotNullExpressionValue(player, "player");
        return INSTANCE.execute((CommandContext<class_2168>)context, player, CollectionsKt.toList(PlayerExtensionsKt.party(player)), box);
    }

    private static final int register$lambda$3(CommandContext context) {
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNullExpressionValue(player, "player");
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.toList(PlayerExtensionsKt.party(player)), null, 8, null);
    }

    private static final class_2561 execute$lambda$5$lambda$4() {
        class_5250 class_52502 = LAST_POKE_MESSAGE;
        Intrinsics.checkNotNullExpressionValue(class_52502, "LAST_POKE_MESSAGE");
        return (class_2561)TextKt.red(class_52502);
    }
}

