/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\b\u001a\u00020\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/SpawnPokemon;", "", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "Lnet/minecraft/class_243;", "pos", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_243;)I", "Lcom/mojang/brigadier/CommandDispatcher;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "", "ALIAS", "Ljava/lang/String;", "AT_ALIAS", "AT_NAME", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "FAILED_SPAWN_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "INVALID_POS_EXCEPTION", "NAME", "NO_SPECIES_EXCEPTION", "POSITION", "PROPERTIES", "<init>", "()V", "common"})
public final class SpawnPokemon {
    @NotNull
    public static final SpawnPokemon INSTANCE = new SpawnPokemon();
    @NotNull
    private static final String NAME = "spawnpokemon";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String POSITION = "pos";
    @NotNull
    private static final String ALIAS = "pokespawn";
    @NotNull
    private static final String AT_NAME = "spawnpokemonat";
    @NotNull
    private static final String AT_ALIAS = "pokespawnat";
    @NotNull
    private static final SimpleCommandExceptionType NO_SPECIES_EXCEPTION;
    @NotNull
    private static final SimpleCommandExceptionType INVALID_POS_EXCEPTION;
    @NotNull
    private static final SimpleCommandExceptionType FAILED_SPAWN_EXCEPTION;

    private SpawnPokemon() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)NAME);
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder, "literal(NAME)");
        LiteralCommandNode contextPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.INSTANCE.getSPAWN_POKEMON(), false, 2, null)).then(class_2170.method_9244((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(arg_0 -> SpawnPokemon.register$lambda$0(this, arg_0))));
        Intrinsics.checkNotNullExpressionValue(contextPositionCommand, "contextPositionCommand");
        dispatcher.register(CommandUtilsKt.alias(contextPositionCommand, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder2 = class_2170.method_9247((String)AT_NAME);
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder2, "literal(AT_NAME)");
        LiteralCommandNode argumentPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.INSTANCE.getSPAWN_POKEMON(), false, 2, null)).then(class_2170.method_9244((String)POSITION, (ArgumentType)((ArgumentType)class_2277.method_9737())).then(class_2170.method_9244((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(SpawnPokemon::register$lambda$1))));
        Intrinsics.checkNotNullExpressionValue(argumentPositionCommand, "argumentPositionCommand");
        dispatcher.register(CommandUtilsKt.alias(argumentPositionCommand, AT_ALIAS));
    }

    private final int execute(CommandContext<class_2168> context, class_243 pos) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 blockPos2 = Vec3ExtensionsKt.toBlockPos(pos);
        if (!class_1937.method_25953((class_2338)blockPos2)) {
            CommandSyntaxException commandSyntaxException = INVALID_POS_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "INVALID_POS_EXCEPTION.create()");
            throw (Throwable)commandSyntaxException;
        }
        PokemonProperties properties2 = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, PROPERTIES);
        if (properties2.getSpecies() == null) {
            CommandSyntaxException commandSyntaxException = NO_SPECIES_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "NO_SPECIES_EXCEPTION.create()");
            throw (Throwable)commandSyntaxException;
        }
        Intrinsics.checkNotNullExpressionValue(world, "world");
        PokemonEntity pokemonEntity = properties2.createEntity((class_1937)world);
        pokemonEntity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, pokemonEntity.method_36454(), pokemonEntity.method_36455());
        pokemonEntity.method_5841().method_12778(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.method_6051().method_43057() * 360.0f));
        if (world.method_8649((class_1297)pokemonEntity)) {
            return 1;
        }
        CommandSyntaxException commandSyntaxException = FAILED_SPAWN_EXCEPTION.create();
        Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "FAILED_SPAWN_EXCEPTION.create()");
        throw (Throwable)commandSyntaxException;
    }

    private static final int register$lambda$0(SpawnPokemon this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_243 class_2432 = ((class_2168)context.getSource()).method_9222();
        Intrinsics.checkNotNullExpressionValue(class_2432, "context.source.position");
        return this$0.execute((CommandContext<class_2168>)context, class_2432);
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNullExpressionValue(context, "context");
        class_243 class_2432 = class_2277.method_9736((CommandContext)context, (String)POSITION);
        Intrinsics.checkNotNullExpressionValue(class_2432, "getVec3(context, POSITION)");
        return INSTANCE.execute((CommandContext<class_2168>)context, class_2432);
    }

    static {
        class_5250 class_52502 = LocalizationUtilsKt.commandLang("spawnpokemon.nospecies", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "commandLang(\"${NAME}.nospecies\")");
        NO_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52502));
        class_5250 class_52503 = class_2561.method_43470((String)"Invalid position");
        Intrinsics.checkNotNullExpressionValue(class_52503, "literal(\"Invalid position\")");
        INVALID_POS_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52503));
        class_5250 class_52504 = class_2561.method_43470((String)"Unable to spawn at the given position");
        Intrinsics.checkNotNullExpressionValue(class_52504, "literal(\"Unable to spawn at the given position\")");
        FAILED_SPAWN_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52504));
    }
}

