/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.compat;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.client.render.layer.PokemonOnShoulderRenderer;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.lighthing.LightingData;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambDynamicLightsCompat {
    public static void hookCompat() {
        DynamicLightHandlers.registerDynamicLightHandler(CobblemonEntities.POKEMON, (DynamicLightHandler)DynamicLightHandler.makeHandler(pokemon -> LambDynamicLightsCompat.resolvedPokemonLightLevel(pokemon, false), pokemon -> true));
        DynamicLightHandlers.registerDynamicLightHandler(CobblemonEntities.POKEMON, (DynamicLightHandler)DynamicLightHandler.makeHandler(pokemon -> LambDynamicLightsCompat.resolvedPokemonLightLevel(pokemon, true), pokemon -> false));
        DynamicLightHandlers.registerDynamicLightHandler((class_1299)class_1299.field_6097, (DynamicLightHandler)DynamicLightHandler.makeHandler(player -> LambDynamicLightsCompat.resolvedShoulderLightLevel(player, false), player -> true));
        DynamicLightHandlers.registerDynamicLightHandler((class_1299)class_1299.field_6097, (DynamicLightHandler)DynamicLightHandler.makeHandler(player -> LambDynamicLightsCompat.resolvedShoulderLightLevel(player, true), player -> false));
    }

    private static int resolvedPokemonLightLevel(PokemonEntity pokemon, boolean underwater) {
        return LambDynamicLightsCompat.extractFormLightLevel(pokemon.getForm(), underwater).orElse(0);
    }

    private static int resolvedShoulderLightLevel(class_1657 player, boolean underwater) {
        class_3545<PokemonOnShoulderRenderer.ShoulderData, PokemonOnShoulderRenderer.ShoulderData> shoulderDataPair = PokemonOnShoulderRenderer.shoulderDataOf(player);
        Optional<Integer> leftLightLevel = LambDynamicLightsCompat.extractShoulderLightLevel((PokemonOnShoulderRenderer.ShoulderData)shoulderDataPair.method_15442(), underwater);
        Optional<Integer> rightLightLevel = LambDynamicLightsCompat.extractShoulderLightLevel((PokemonOnShoulderRenderer.ShoulderData)shoulderDataPair.method_15441(), underwater);
        return Math.max(leftLightLevel.orElse(0), rightLightLevel.orElse(0));
    }

    private static Optional<Integer> extractFormLightLevel(@NotNull FormData form2, boolean underwater) {
        if (form2.getLightingData() == null || !LambDynamicLightsCompat.liquidGlowModeSupport(form2.getLightingData().getLiquidGlowMode(), underwater)) {
            return Optional.empty();
        }
        return Optional.of(form2.getLightingData().getLightLevel());
    }

    private static Optional<Integer> extractShoulderLightLevel(@Nullable PokemonOnShoulderRenderer.ShoulderData shoulderData, boolean underwater) {
        if (shoulderData == null) {
            return Optional.empty();
        }
        return LambDynamicLightsCompat.extractFormLightLevel(shoulderData.getForm(), underwater);
    }

    private static boolean liquidGlowModeSupport(@NotNull LightingData.LiquidGlowMode liquidGlowMode, boolean underwater) {
        return underwater ? liquidGlowMode.getGlowsUnderwater() : liquidGlowMode.getGlowsInLand();
    }
}

