/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.entity.pokemon.MocKEffect;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonServerDelegate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.cobblemon.mod.common.pokemon.ai.MoveBehaviour;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b,\u0010\u0018J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0014\u001a\u00020\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0011J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0006J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u000f\u0010\u001b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0018J\r\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0018R\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u000f\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0011R\u0016\u0010+\u001a\u0004\u0018\u00010(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate;", "Lcom/cobblemon/mod/common/api/entity/PokemonSideDelegate;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "changePokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/class_1282;", "source", "drop", "(Lnet/minecraft/class_1282;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getBattle", "()Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "initialize", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/class_2940;", "data", "onTrackedDataSet", "(Lnet/minecraft/class_2940;)V", "tick", "updateMaxHealth", "()V", "updatePathfindingPenalties", "updatePoseType", "updatePostDeath", "updateTrackedValues", "", "acknowledgedHPStat", "I", "getAcknowledgedHPStat", "()I", "setAcknowledgedHPStat", "(I)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "setEntity", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getMock", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "mock", "<init>", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonServerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonServerDelegate.kt\ncom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class PokemonServerDelegate
implements PokemonSideDelegate {
    public PokemonEntity entity;
    private int acknowledgedHPStat = -1;

    @NotNull
    public final PokemonEntity getEntity() {
        PokemonEntity pokemonEntity = this.entity;
        if (pokemonEntity != null) {
            return pokemonEntity;
        }
        Intrinsics.throwUninitializedPropertyAccessException("entity");
        return null;
    }

    public final void setEntity(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter(pokemonEntity, "<set-?>");
        this.entity = pokemonEntity;
    }

    public final int getAcknowledgedHPStat() {
        return this.acknowledgedHPStat;
    }

    public final void setAcknowledgedHPStat(int n) {
        this.acknowledgedHPStat = n;
    }

    private final PokemonProperties getMock() {
        MocKEffect mocKEffect = this.getEntity().getEffects().getMockEffect();
        return mocKEffect != null ? mocKEffect.getMock() : null;
    }

    @Override
    public void changePokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        this.updatePathfindingPenalties(pokemon);
        this.getEntity().method_5959();
        this.updateMaxHealth();
    }

    public final void updatePathfindingPenalties(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        MoveBehaviour moving2 = pokemon.getForm().getBehaviour().getMoving();
        this.getEntity().method_5941(class_7.field_14, moving2.getSwim().getCanSwimInLava() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_18, moving2.getSwim().getCanSwimInWater() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_4, moving2.getSwim().getCanSwimInWater() ? 6.0f : -1.0f);
        if (moving2.getSwim().getCanBreatheUnderwater()) {
            this.getEntity().method_5941(class_7.field_18, moving2.getWalk().getAvoidsLand() ? 0.0f : 4.0f);
        }
        if (moving2.getSwim().getCanBreatheUnderlava()) {
            this.getEntity().method_5941(class_7.field_14, moving2.getSwim().getCanSwimInLava() ? 4.0f : -1.0f);
        }
        if (moving2.getWalk().getAvoidsLand()) {
            this.getEntity().method_5941(class_7.field_12, 12.0f);
        }
        if (moving2.getWalk().getCanWalk() && moving2.getFly().getCanFly()) {
            this.getEntity().method_5941(class_7.field_12, 0.0f);
        }
        this.getEntity().getNavigation().setCanPathThroughFire(this.getEntity().method_5753());
    }

    public final void updateMaxHealth() {
        double currentHealthRatio = (double)this.getEntity().method_6032() / (double)this.getEntity().method_6063();
        Integer n = this.getEntity().getForm().getBaseStats().get(Stats.HP);
        if (n == null) {
            return;
        }
        this.acknowledgedHPStat = n;
        int minStat = 50;
        int maxStat = 150;
        int baseStat = RangesKt.coerceIn(this.acknowledgedHPStat, new IntRange(minStat, maxStat));
        double r = (double)(baseStat - minStat) / (double)(maxStat - minStat);
        double minPossibleHP = 10.0;
        double maxPossibleHP = 100.0;
        double maxHealth = minPossibleHP + r * (maxPossibleHP - minPossibleHP);
        class_1324 class_13242 = this.getEntity().method_5996(class_5134.field_23716);
        if (class_13242 != null) {
            class_13242.method_6192(maxHealth);
        }
        this.getEntity().method_6033((float)currentHealthRatio * (float)maxHealth);
    }

    @Override
    public void initialize(@NotNull PokemonEntity entity2) {
        Intrinsics.checkNotNullParameter(entity2, "entity");
        this.setEntity(entity2);
        PokemonEntity $this$initialize_u24lambda_u240 = entity2;
        boolean bl = false;
        $this$initialize_u24lambda_u240.field_28627 = 0.1f;
        entity2.getDespawner().beginTracking((PokemonEntity)((class_1297)$this$initialize_u24lambda_u240));
        this.updateTrackedValues();
    }

    @Nullable
    public final PokemonBattle getBattle() {
        PokemonBattle pokemonBattle;
        UUID uUID = this.getEntity().getBattleId();
        if (uUID != null) {
            UUID uUID2 = uUID;
            BattleRegistry battleRegistry = BattleRegistry.INSTANCE;
            UUID p0 = uUID2;
            boolean bl = false;
            pokemonBattle = battleRegistry.getBattle(p0);
        } else {
            pokemonBattle = null;
        }
        return pokemonBattle;
    }

    public final void updateTrackedValues() {
        Set<String> set2;
        PokemonProperties trackedNickname;
        Object object = this.getMock();
        if (object == null || (object = ((PokemonProperties)object).getSpecies()) == null) {
            String string = this.getEntity().getPokemon().getSpecies().getResourceIdentifier().toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue(string, "entity.pokemon.species.r\u2026urceIdentifier.toString()");
        }
        Object trackedSpecies = object;
        PokemonProperties pokemonProperties = this.getMock();
        if ((pokemonProperties == null || (pokemonProperties = pokemonProperties.getNickname()) == null) && (pokemonProperties = this.getEntity().getPokemon().getNickname()) == null) {
            pokemonProperties = trackedNickname = class_2561.method_43473();
        }
        if ((set2 = this.getMock()) == null || (set2 = ((PokemonProperties)((Object)set2)).getAspects()) == null) {
            set2 = this.getEntity().getPokemon().getAspects();
        }
        Set<String> trackedAspects = set2;
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getSPECIES(), trackedSpecies);
        if (!Intrinsics.areEqual(this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getNICKNAME()), trackedNickname)) {
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getNICKNAME(), (Object)trackedNickname);
        }
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getASPECTS(), trackedAspects);
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getLABEL_LEVEL(), (Object)this.getEntity().getPokemon().getLevel());
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getMOVING(), (Object)(this.getEntity().method_18798().method_18805(1.0, this.getEntity().method_24828() ? 0.0 : 1.0, 1.0).method_1033() > (double)0.005f ? 1 : 0));
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getFRIENDSHIP(), (Object)this.getEntity().getPokemon().getFriendship());
        this.updatePoseType();
    }

    @Override
    public void onTrackedDataSet(@NotNull class_2940<?> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        PokemonSideDelegate.DefaultImpls.onTrackedDataSet(this, data2);
        if (this.entity != null && Intrinsics.areEqual(data2, PokemonEntity.Companion.getBEHAVIOUR_FLAGS())) {
            this.updatePoseType();
        }
    }

    @Override
    public void tick(@NotNull PokemonEntity entity2) {
        PokemonPastureBlockEntity.Tethering tethering;
        Intrinsics.checkNotNullParameter(entity2, "entity");
        PokemonState state = entity2.getPokemon().getState();
        if (!(state instanceof ActivePokemonState && Intrinsics.areEqual(((ActivePokemonState)state).getEntity(), entity2) || entity2.method_29504() || !(entity2.method_6032() > 0.0f))) {
            entity2.getPokemon().setState(new SentOutState(entity2));
        }
        if (entity2.method_6139() != null && entity2.getPokemon().getStoreCoordinates().get() == null) {
            entity2.method_31472();
        }
        if ((tethering = entity2.getTethering()) != null && !Intrinsics.areEqual(entity2.getPokemon().getTetheringId(), tethering.getTetheringId())) {
            entity2.method_31472();
        }
        class_2945 class_29452 = entity2.method_5841();
        Intrinsics.checkNotNullExpressionValue(class_29452, "entity.dataTracker");
        class_2940<Optional<UUID>> class_29402 = PokemonEntity.Companion.getBATTLE_ID();
        Intrinsics.checkNotNullExpressionValue(class_29402, "PokemonEntity.BATTLE_ID");
        EntityExtensionsKt.update(class_29452, class_29402, tick.1.INSTANCE);
        PokemonBattle battle2 = this.getBattle();
        if (entity2.getTicksLived() % 20 == 0 && battle2 != null) {
            ActiveBattlePokemon activeBattlePokemon;
            block10: {
                Iterable<ActiveBattlePokemon> iterable = battle2.getActivePokemon();
                Iterator<ActiveBattlePokemon> iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    ActiveBattlePokemon activeBattlePokemon2;
                    ActiveBattlePokemon it = activeBattlePokemon2 = iterator2.next();
                    boolean bl = false;
                    BattlePokemon battlePokemon = it.getBattlePokemon();
                    if (!Intrinsics.areEqual(battlePokemon != null ? battlePokemon.getUuid() : null, entity2.getPokemon().getUuid())) continue;
                    activeBattlePokemon = activeBattlePokemon2;
                    break block10;
                }
                activeBattlePokemon = null;
            }
            ActiveBattlePokemon activeBattlePokemon3 = activeBattlePokemon;
            if (activeBattlePokemon3 != null) {
                class_1937 class_19372 = entity2.method_37908();
                Intrinsics.checkNotNull(class_19372, "null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                activeBattlePokemon3.setPosition(TuplesKt.to((class_3218)class_19372, entity2.method_19538()));
            }
        }
        Integer n = entity2.getForm().getBaseStats().get(Stats.HP);
        int n2 = this.acknowledgedHPStat;
        if (n == null || n != n2) {
            this.updateMaxHealth();
        }
        if (!Intrinsics.areEqual(entity2.method_6139(), entity2.getPokemon().getOwnerUUID())) {
            entity2.method_6174(entity2.getPokemon().getOwnerUUID());
        }
        if (entity2.method_6139() == null && tethering != null) {
            entity2.method_6174(tethering.getPlayerId());
        }
        if (entity2.method_6139() != null && entity2.method_35057() == null && entity2.getTethering() == null) {
            entity2.method_5650(class_1297.class_5529.field_26999);
        }
        this.updateTrackedValues();
    }

    public final void updatePoseType() {
        PoseType poseType;
        PersistentStatusContainer persistentStatusContainer = this.getEntity().getPokemon().getStatus();
        boolean isSleeping = Intrinsics.areEqual(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null, Statuses.INSTANCE.getSLEEP()) && this.getEntity().getBehaviour().getResting().getCanSleep();
        Boolean isMoving = (Boolean)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getMOVING());
        boolean isPassenger = this.getEntity().method_5765();
        boolean isUnderwater = this.getEntity().getIsSubmerged();
        boolean isFlying = this.getEntity().getBehaviourFlag(PokemonBehaviourFlag.FLYING);
        if (isPassenger) {
            poseType = PoseType.STAND;
        } else if (isSleeping) {
            poseType = PoseType.SLEEP;
        } else {
            Intrinsics.checkNotNullExpressionValue(isMoving, "isMoving");
            poseType = isMoving != false && isUnderwater ? PoseType.SWIM : (isUnderwater ? PoseType.FLOAT : (isMoving != false && isFlying ? PoseType.FLY : (isFlying ? PoseType.HOVER : (isMoving != false ? PoseType.WALK : PoseType.STAND))));
        }
        PoseType poseType2 = poseType;
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getPOSE_TYPE(), (Object)poseType2);
    }

    @Override
    public void drop(@Nullable class_1282 source) {
        class_3222 player;
        class_1282 class_12822 = source;
        class_1297 class_12972 = class_12822 != null ? class_12822.method_5526() : null;
        class_3222 class_32222 = player = class_12972 instanceof class_3222 ? (class_3222)class_12972 : null;
        if (this.getEntity().getPokemon().isWild()) {
            this.getEntity().setKiller(player);
        }
    }

    @Override
    public void updatePostDeath() {
        class_1309 owner;
        if (this.getEntity().field_6213 == 0) {
            this.getEntity().getEffects().wipe();
            this.getEntity().field_6213 = 1;
            return;
        }
        CompletableFuture<PokemonEntity> completableFuture = this.getEntity().getEffects().getProgress();
        boolean bl = completableFuture != null ? !completableFuture.isDone() : false;
        if (bl) {
            return;
        }
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getDYING_EFFECTS_STARTED(), (Object)true);
        PokemonEntity pokemonEntity = this.getEntity();
        ++pokemonEntity.field_6213;
        int cfr_ignored_0 = pokemonEntity.field_6213;
        if (this.getEntity().field_6213 == 30 && (owner = this.getEntity().method_35057()) != null) {
            class_1937 class_19372 = this.getEntity().method_37908();
            Intrinsics.checkNotNullExpressionValue(class_19372, "entity.world");
            class_243 class_2432 = owner.method_19538();
            Intrinsics.checkNotNullExpressionValue(class_2432, "owner.pos");
            WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, CobblemonSounds.POKE_BALL_RECALL, null, 0.6f, 0.0f, 20, null);
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getPHASING_TARGET_ID(), (Object)owner.method_5628());
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getBEAM_MODE(), (Object)3);
        }
        if (this.getEntity().field_6213 == 60) {
            if (this.getEntity().method_35057() == null) {
                this.getEntity().method_37908().method_8421((class_1297)this.getEntity(), (byte)60);
                if (this.getEntity().method_37908().method_8450().method_8355(CobblemonGameRules.DO_POKEMON_LOOT)) {
                    DropTable dropTable = this.getEntity().getDrops();
                    if (dropTable == null) {
                        dropTable = this.getEntity().getPokemon().getForm().getDrops();
                    }
                    class_1309 class_13092 = (class_1309)this.getEntity();
                    class_1937 class_19373 = this.getEntity().method_37908();
                    Intrinsics.checkNotNull(class_19373, "null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                    class_3218 class_32182 = (class_3218)class_19373;
                    class_243 class_2433 = this.getEntity().method_19538();
                    Intrinsics.checkNotNullExpressionValue(class_2433, "entity.pos");
                    DropTable.drop$default(dropTable, class_13092, class_32182, class_2433, this.getEntity().getKiller(), null, 16, null);
                }
            }
            this.getEntity().method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public void handleStatus(byte status) {
        PokemonSideDelegate.DefaultImpls.handleStatus(this, status);
    }
}

