/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.berry;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonMechanics;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.item.BerryItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b#\u0010$J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/item/berry/FriendshipRaisingBerryItem;", "Lcom/cobblemon/mod/common/item/BerryItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_1799;", "stack", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_1271;", "applyToPokemon", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/class_1271;", "", "canUseOnPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "", "bagItem", "Ljava/lang/Void;", "getBagItem", "()Ljava/lang/Void;", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "stat", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "getStat", "()Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "block", "<init>", "(Lcom/cobblemon/mod/common/block/BerryBlock;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)V", "common"})
public final class FriendshipRaisingBerryItem
extends BerryItem
implements PokemonSelectingItem {
    @NotNull
    private final Stat stat;
    @Nullable
    private final Void bagItem;

    public FriendshipRaisingBerryItem(@NotNull BerryBlock block, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(stat, "stat");
        super(block);
        this.stat = stat;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @Nullable
    public Void getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        return pokemon.getEvs().getOrDefault(this.stat) > 0 || pokemon.getFriendship() < Cobblemon.INSTANCE.getConfig().getMaxPokemonFriendship();
    }

    @Override
    @NotNull
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        class_1271 class_12712;
        boolean decreasedEVs;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        int friendshipRaiseAmount = MoLangExtensionsKt.resolveInt(MoLangExtensionsKt.getGenericRuntime(), CobblemonMechanics.INSTANCE.getBerries().getFriendshipRaiseAmount(), pokemon);
        boolean increasedFriendship = Pokemon.incrementFriendship$default(pokemon, friendshipRaiseAmount, false, 2, null);
        int currentStat = pokemon.getEvs().getOrDefault(this.stat);
        int newEV = Math.max(currentStat - MoLangExtensionsKt.resolveInt(MoLangExtensionsKt.getGenericRuntime(), CobblemonMechanics.INSTANCE.getBerries().getEvLowerAmount()), 0);
        pokemon.setEV(this.stat, newEV);
        boolean bl = decreasedEVs = currentStat != pokemon.getEvs().getOrDefault(this.stat);
        if (increasedFriendship || decreasedEVs) {
            player.method_17356(CobblemonSounds.BERRY_EAT, class_3419.field_15248, 1.0f, 1.0f);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            class_1271 class_12713 = class_1271.method_22427((Object)stack);
            class_12712 = class_12713;
            Intrinsics.checkNotNullExpressionValue(class_12713, "{\n            player.pla\u2026.success(stack)\n        }");
        } else {
            class_1271 class_12714 = class_1271.method_22430((Object)stack);
            class_12712 = class_12714;
            Intrinsics.checkNotNullExpressionValue(class_12714, "{\n            TypedActio\u2026ult.pass(stack)\n        }");
        }
        return class_12712;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(hand, "hand");
        if (world instanceof class_3218 && user instanceof class_3222) {
            class_3222 class_32222 = (class_3222)user;
            class_1799 class_17992 = user.method_5998(hand);
            Intrinsics.checkNotNullExpressionValue(class_17992, "user.getStackInHand(hand)");
            return this.use(class_32222, class_17992);
        }
        class_1271 class_12712 = super.method_7836(world, user, hand);
        Intrinsics.checkNotNullExpressionValue(class_12712, "super<BerryItem>.use(world, user, hand)");
        return class_12712;
    }

    @Override
    @NotNull
    public class_1271<class_1799> use(@NotNull class_3222 player, @NotNull class_1799 stack) {
        return PokemonSelectingItem.DefaultImpls.use(this, player, stack);
    }

    @Override
    public void applyToBattlePokemon(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattlePokemon battlePokemon) {
        PokemonSelectingItem.DefaultImpls.applyToBattlePokemon(this, player, stack, battlePokemon);
    }

    @Override
    public boolean canUseOnBattlePokemon(@NotNull BattlePokemon battlePokemon) {
        return PokemonSelectingItem.DefaultImpls.canUseOnBattlePokemon(this, battlePokemon);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactWithSpecificBattle(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattlePokemon battlePokemon) {
        return PokemonSelectingItem.DefaultImpls.interactWithSpecificBattle(this, player, stack, battlePokemon);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactGeneral(@NotNull class_3222 player, @NotNull class_1799 stack) {
        return PokemonSelectingItem.DefaultImpls.interactGeneral(this, player, stack);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactGeneralBattle(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattleActor actor) {
        return PokemonSelectingItem.DefaultImpls.interactGeneralBattle(this, player, stack, actor);
    }
}

