/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractCriterion;
import com.cobblemon.mod.common.advancement.criterion.SimpleCriterionTrigger;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.ReviveItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/item/interactive/ReviveItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "Lnet/minecraft/class_1271;", "Lnet/minecraft/class_1799;", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "", "max", "Z", "getMax", "()Z", "<init>", "(Z)V", "common"})
public final class ReviveItem
extends CobblemonItem {
    private final boolean max;
    @NotNull
    private final BagItem bagItem;

    public ReviveItem(boolean max2) {
        super(new class_1792.class_1793());
        this.max = max2;
        this.bagItem = new BagItem(this){
            @NotNull
            private final String itemName;
            final /* synthetic */ ReviveItem this$0;
            {
                this.this$0 = $receiver;
                this.itemName = "item.cobblemon." + ($receiver.getMax() ? "max_revive" : "revive");
            }

            @NotNull
            public String getItemName() {
                return this.itemName;
            }

            public boolean canUse(@NotNull PokemonBattle battle2, @NotNull BattlePokemon target) {
                Intrinsics.checkNotNullParameter(battle2, "battle");
                Intrinsics.checkNotNullParameter(target, "target");
                return target.getHealth() <= 0;
            }

            @NotNull
            public String getShowdownInput(@NotNull BattleActor actor, @NotNull BattlePokemon battlePokemon, @Nullable String data2) {
                Intrinsics.checkNotNullParameter(actor, "actor");
                Intrinsics.checkNotNullParameter(battlePokemon, "battlePokemon");
                return "revive " + (this.this$0.getMax() ? "1" : "0.5");
            }

            public boolean canStillUse(@NotNull class_3222 player, @NotNull PokemonBattle battle2, @NotNull BattleActor actor, @NotNull BattlePokemon target, @NotNull class_1799 stack) {
                return BagItem.DefaultImpls.canStillUse(this, player, battle2, actor, target, stack);
            }
        };
    }

    public final boolean getMax() {
        return this.max;
    }

    @NotNull
    public final BagItem getBagItem() {
        return this.bagItem;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(hand, "hand");
        if (!(world instanceof class_3218)) {
            class_1271 class_12712 = class_1271.method_22427((Object)user.method_5998(hand));
            Intrinsics.checkNotNullExpressionValue(class_12712, "success(user.getStackInHand(hand))");
            return class_12712;
        }
        class_3222 player = (class_3222)user;
        class_1799 stack = user.method_5998(hand);
        PokemonBattle battle2 = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player);
        if (battle2 != null) {
            BattleActor battleActor = battle2.getActor(player);
            Intrinsics.checkNotNull(battleActor);
            BattleActor actor = battleActor;
            List<BattlePokemon> battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                class_5250 class_52502 = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(class_52502, "battleLang(\"bagitem.cannot\")");
                player.method_7353((class_2561)TextKt.red(class_52502), true);
                class_1271 class_12713 = class_1271.method_22428((Object)stack);
                Intrinsics.checkNotNullExpressionValue(class_12713, "consume(stack)");
                return class_12713;
            }
            int turn = battle2.getTurn();
            PartySelectCallbacks.createBattleSelect$default(PartySelectCallbacks.INSTANCE, player, null, battlePokemon, new Function1<BattlePokemon, Boolean>(this, battle2){
                final /* synthetic */ ReviveItem this$0;
                final /* synthetic */ PokemonBattle $battle;
                {
                    this.this$0 = $receiver;
                    this.$battle = $battle;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BattlePokemon it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.this$0.getBagItem().canUse(this.$battle, it);
                }
            }, null, new Function1<BattlePokemon, Unit>(actor, battle2, turn, stack, player, this){
                final /* synthetic */ BattleActor $actor;
                final /* synthetic */ PokemonBattle $battle;
                final /* synthetic */ int $turn;
                final /* synthetic */ class_1799 $stack;
                final /* synthetic */ class_3222 $player;
                final /* synthetic */ ReviveItem this$0;
                {
                    this.$actor = $actor;
                    this.$battle = $battle;
                    this.$turn = $turn;
                    this.$stack = $stack;
                    this.$player = $player;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BattlePokemon bp) {
                    Intrinsics.checkNotNullParameter(bp, "bp");
                    if (this.$actor.canFitForcedAction() && bp.getHealth() <= 0 && this.$battle.getTurn() == this.$turn) {
                        class_1799 class_17992 = this.$stack;
                        Intrinsics.checkNotNullExpressionValue(class_17992, "stack");
                        if (ItemStackExtensionsKt.isHeld(class_17992, this.$player)) {
                            this.$player.method_17356(CobblemonSounds.ITEM_USE, class_3419.field_15248, 1.0f, 1.0f);
                            this.$actor.forceChoose(new BagItemActionResponse(this.this$0.getBagItem(), bp, bp.getUuid().toString()));
                            if (!this.$player.method_7337()) {
                                this.$stack.method_7934(1);
                            }
                            SimpleCriterionTrigger<PokemonInteractContext, PokemonInteractCriterion> simpleCriterionTrigger = CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT();
                            Object object = bp.getEntity();
                            Species species = object != null && (object = ((PokemonEntity)object).getPokemon()) != null ? ((Pokemon)object).getSpecies() : null;
                            Intrinsics.checkNotNull(species);
                            class_2960 class_29602 = species.getResourceIdentifier();
                            class_2960 class_29603 = class_7923.field_41178.method_10221((Object)this.$stack.method_7909());
                            Intrinsics.checkNotNullExpressionValue(class_29603, "ITEM.getId(stack.item)");
                            simpleCriterionTrigger.trigger(this.$player, new PokemonInteractContext(class_29602, class_29603));
                        }
                    }
                }
            }, 18, null);
        } else {
            List pokemon = CollectionsKt.toList(PlayerExtensionsKt.party(player));
            PartySelectCallbacks.createFromPokemon$default(PartySelectCallbacks.INSTANCE, player, null, pokemon, use.3.INSTANCE, null, new Function1<Pokemon, Unit>(player, stack, this){
                final /* synthetic */ class_3222 $player;
                final /* synthetic */ class_1799 $stack;
                final /* synthetic */ ReviveItem this$0;
                {
                    this.$player = $player;
                    this.$stack = $stack;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Pokemon pk) {
                    Intrinsics.checkNotNullParameter(pk, "pk");
                    if (pk.isFainted() && !PlayerExtensionsKt.isInBattle(this.$player)) {
                        class_1799 class_17992 = this.$stack;
                        Intrinsics.checkNotNullExpressionValue(class_17992, "stack");
                        if (ItemStackExtensionsKt.isHeld(class_17992, this.$player)) {
                            pk.setCurrentHealth(this.this$0.getMax() ? pk.getHp() : (int)Math.ceil((float)pk.getHp() / 2.0f));
                            if (!this.$player.method_7337()) {
                                this.$stack.method_7934(1);
                            }
                            SimpleCriterionTrigger<PokemonInteractContext, PokemonInteractCriterion> simpleCriterionTrigger = CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT();
                            class_2960 class_29602 = pk.getSpecies().getResourceIdentifier();
                            class_2960 class_29603 = class_7923.field_41178.method_10221((Object)this.$stack.method_7909());
                            Intrinsics.checkNotNullExpressionValue(class_29603, "ITEM.getId(stack.item)");
                            simpleCriterionTrigger.trigger(this.$player, new PokemonInteractContext(class_29602, class_29603));
                        }
                    }
                }
            }, 18, null);
        }
        class_1271 class_12714 = class_1271.method_22427((Object)stack);
        Intrinsics.checkNotNullExpressionValue(class_12714, "success(stack)");
        return class_12714;
    }
}

