/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.item.LeftoversCreatedEvent;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309 {
    @Shadow
    public abstract class_2487 method_7356();

    @Shadow
    public abstract class_2487 method_7308();

    @Shadow
    public abstract void method_7296(class_2487 var1);

    @Shadow
    public abstract void method_7345(class_2487 var1);

    @Shadow
    public abstract void method_7273(class_2487 var1);

    @Shadow
    public abstract boolean method_7325();

    @Shadow
    public abstract boolean method_7270(class_1799 var1);

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    protected PlayerMixin(class_1299<? extends class_1309> p_20966_, class_1937 p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"dropShoulderEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityType;getEntityFromNbt(Lnet/minecraft/nbt/NbtCompound;Lnet/minecraft/world/World;)Ljava/util/Optional;")}, cancellable=true)
    private void cobblemon$removePokemon(class_2487 nbt, CallbackInfo ci) {
        if (CompoundTagExtensionsKt.isPokemonEntity(nbt)) {
            UUID uuidLeft;
            UUID uuidRight;
            UUID uuid2 = this.getPokemonID(nbt);
            if (this.isShoulderPokemon(this.method_7308()) && uuid2.equals(uuidRight = this.getPokemonID(this.method_7308()))) {
                this.recallPokemon(uuidRight);
                this.method_7345(new class_2487());
            }
            if (this.isShoulderPokemon(this.method_7356()) && uuid2.equals(uuidLeft = this.getPokemonID(this.method_7356()))) {
                this.recallPokemon(uuidLeft);
                this.method_7273(new class_2487());
            }
            ci.cancel();
        }
    }

    @Inject(method={"dropShoulderEntities"}, at={@At(value="JUMP", opcode=156, ordinal=0, shift=At.Shift.AFTER)}, cancellable=true)
    private void cobblemon$preventPokemonDropping(CallbackInfo ci) {
        if (this.method_7325() || this.method_29504()) {
            return;
        }
        if (!this.isShoulderPokemon(this.method_7356())) {
            this.method_7296(this.method_7356());
            this.method_7273(new class_2487());
        }
        if (!this.isShoulderPokemon(this.method_7308())) {
            this.method_7296(this.method_7308());
            this.method_7345(new class_2487());
        }
        ci.cancel();
    }

    private UUID getPokemonID(class_2487 nbt) {
        return nbt.method_10562("Pokemon").method_25926("UUID");
    }

    private void recallPokemon(UUID uuid2) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(this.field_6021);
            for (Pokemon pokemon : party) {
                if (!pokemon.getUuid().equals(uuid2)) continue;
                pokemon.recall();
            }
        }
        catch (NoPokemonStoreException noPokemonStoreException) {
            // empty catch block
        }
    }

    private boolean isShoulderPokemon(class_2487 nbt) {
        return CompoundTagExtensionsKt.isPokemonEntity(nbt);
    }

    @Inject(method={"eatFood"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getHungerManager()Lnet/minecraft/entity/player/HungerManager;", shift=At.Shift.AFTER)})
    public void onEatFood(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        if (!this.method_37908().field_9236 && stack.method_31573(CobblemonItemTags.LEAVES_LEFTOVERS) && this.method_37908().field_9229.method_43058() < Cobblemon.config.getAppleLeftoversChance()) {
            class_1799 leftovers = new class_1799((class_1935)CobblemonItems.LEFTOVERS);
            class_3222 player = Objects.requireNonNull(this.method_5682()).method_3760().method_14602(this.field_6021);
            assert (player != null);
            CobblemonEvents.LEFTOVERS_CREATED.postThen(new LeftoversCreatedEvent(player, leftovers), leftoversCreatedEvent -> null, leftoversCreatedEvent -> {
                if (!player.method_7270(leftoversCreatedEvent.getLeftovers())) {
                    class_243 itemPos = player.method_5720().method_1021(0.5).method_1019(this.method_19538());
                    this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), itemPos.method_10216(), itemPos.method_10214(), itemPos.method_10215(), leftoversCreatedEvent.getLeftovers()));
                }
                return null;
            });
        }
    }
}

