/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.world.CobblemonStructureIDs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5188;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7138;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3778.class_4182.class})
public abstract class StructurePoolGeneratorMixin {
    @Final
    @Mutable
    @Shadow
    Deque<class_3778.class_4181> field_18706;
    Map<String, Integer> generatedStructureGroupCounts;
    private static final Map<String, Integer> structureMaxes;
    private static final Map<class_2960, Set<String>> structureGroups;

    public Set<String> getGroups(class_2960 structureIdentifier) {
        return structureGroups.getOrDefault(structureIdentifier, Set.of());
    }

    public boolean hasReachedMaximum(class_2960 structureIdentifier) {
        Set<String> groups2 = this.getGroups(structureIdentifier);
        for (String group : groups2) {
            int count = this.generatedStructureGroupCounts.getOrDefault(group, 0);
            if (count < structureMaxes.getOrDefault(group, Integer.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    public void incrementStructureCount(class_2960 structureIdentifier) {
        Set<String> groups2 = this.getGroups(structureIdentifier);
        for (String group : groups2) {
            this.generatedStructureGroupCounts.put(group, this.generatedStructureGroupCounts.getOrDefault(group, 0) + 1);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onStructurePoolGeneratorCreation(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random, CallbackInfo ci) {
        this.generatedStructureGroupCounts = new HashMap<String, Integer>();
    }

    @ModifyVariable(method={"generatePiece"}, at=@At(value="STORE"), ordinal=1)
    private Iterator<class_3784> reduceStructurePoolElementIterator(Iterator<class_3784> iterator2) {
        ArrayList<class_3784> reducedList = new ArrayList<class_3784>();
        while (iterator2.hasNext()) {
            class_3784 structure = iterator2.next();
            class_2960 structurePieceLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(structure);
            if (structurePieceLocationKey == null) {
                reducedList.add(structure);
                continue;
            }
            if (this.hasReachedMaximum(structurePieceLocationKey)) continue;
            reducedList.add(structure);
        }
        return reducedList.iterator();
    }

    @ModifyVariable(method={"generatePiece"}, at=@At(value="STORE"), ordinal=1)
    private class_3790 injected(class_3790 poolStructurePiece) {
        class_2960 structureLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(poolStructurePiece.method_16644());
        if (structureLocationKey != null) {
            this.incrementStructureCount(structureLocationKey);
        }
        return poolStructurePiece;
    }

    @Inject(method={"generatePiece"}, at={@At(value="HEAD")})
    private void beforeGeneratePiece(class_3790 piece, MutableObject<class_265> pieceShape, int minY, boolean modifyBoundingBox, class_5539 world, class_7138 noiseConfig, CallbackInfo ci) {
    }

    private static class_2960 getCobblemonOnlyLocation(class_3784 structurePoolElement) {
        class_2960 location = StructurePoolGeneratorMixin.getLocationIfAvailable(structurePoolElement);
        if (location == null) {
            return null;
        }
        if (!location.method_12836().equals("cobblemon")) {
            return null;
        }
        return location;
    }

    private static class_2960 getLocationIfAvailable(class_3784 structurePoolElement) {
        if (structurePoolElement instanceof class_5188) {
            class_5188 legacySinglePoolElement = (class_5188)structurePoolElement;
            if (legacySinglePoolElement.field_24015.left().isEmpty()) {
                return null;
            }
            return (class_2960)legacySinglePoolElement.field_24015.left().get();
        }
        if (structurePoolElement instanceof class_3781) {
            class_3781 singlePoolElement = (class_3781)structurePoolElement;
            if (singlePoolElement.field_24015.left().isEmpty()) {
                return null;
            }
            return (class_2960)singlePoolElement.field_24015.left().get();
        }
        return null;
    }

    static {
        structureGroups = new HashMap<class_2960, Set<String>>();
        String pokecenter = "pokecenter";
        String berry = "berry_farm";
        structureGroups.put(CobblemonStructureIDs.PLAINS_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.DESERT_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.SNOWY_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.TAIGA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_LARGE, Set.of(berry));
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        aMap.put(pokecenter, 1);
        aMap.put(berry, 2);
        structureMaxes = Collections.unmodifiableMap(aMap);
    }
}

