/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling.trade;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.net.messages.server.trade.CancelTradePacket;
import com.cobblemon.mod.common.net.messages.server.trade.UpdateTradeOfferPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/trade/UpdateTradeOfferHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/trade/UpdateTradeOfferPacket;", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/trade/UpdateTradeOfferPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "<init>", "()V", "common"})
public final class UpdateTradeOfferHandler
implements ServerNetworkPacketHandler<UpdateTradeOfferPacket> {
    @NotNull
    public static final UpdateTradeOfferHandler INSTANCE = new UpdateTradeOfferHandler();

    private UpdateTradeOfferHandler() {
    }

    @Override
    public void handle(@NotNull UpdateTradeOfferPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        ActiveTrade activeTrade = TradeManager.INSTANCE.getActiveTrade(uUID);
        if (activeTrade == null) {
            CobblemonNetwork.INSTANCE.sendPacket(player, new CancelTradePacket());
            return;
        }
        ActiveTrade trade2 = activeTrade;
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID2, "player.uuid");
        TradeParticipant tradeParticipant = trade2.getTradeParticipant(uUID2);
        Pair<UUID, PartyPosition> newOffer = packet.getNewOffer();
        if (newOffer == null) {
            trade2.updateOffer(tradeParticipant, null);
        } else {
            UUID pokemonId = newOffer.component1();
            PartyPosition partyPosition = newOffer.component2();
            PlayerPartyStore party = PlayerExtensionsKt.party(player);
            Pokemon pokemon = party.get(partyPosition);
            if (pokemon == null || !Intrinsics.areEqual(pokemon.getUuid(), pokemonId)) {
                return;
            }
            if (!pokemon.getTradeable()) {
                return;
            }
            trade2.updateOffer(tradeParticipant, pokemon);
        }
    }

    @Override
    public void handleOnNettyThread(@NotNull UpdateTradeOfferPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        ServerNetworkPacketHandler.DefaultImpls.handleOnNettyThread(this, (NetworkPacket)packet, server, player);
    }
}

