/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.activestate;

import com.cobblemon.mod.common.api.pokemon.effect.ShoulderEffect;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.google.gson.JsonObject;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u00101\u001a\u000200\u0012\u0006\u0010+\u001a\u00020\t\u0012\u0006\u00107\u001a\u000200\u00a2\u0006\u0004\b>\u0010?B\u0007\u00a2\u0006\u0004\b>\u0010\u001dJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b \u0010!J\u0019\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010'\u001a\u0004\u0018\u00010&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\"\u0010+\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b+\u0010-\"\u0004\b.\u0010/R\"\u00101\u001a\u0002008\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\"\u00107\u001a\u0002008\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b7\u00102\u001a\u0004\b8\u00104\"\u0004\b9\u00106R*\u0010;\u001a\n :*\u0004\u0018\u000100008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u00102\u001a\u0004\b<\u00104\"\u0004\b=\u00106\u00a8\u0006@"}, d2={"Lcom/cobblemon/mod/common/pokemon/activestate/ShoulderedState;", "Lcom/cobblemon/mod/common/pokemon/activestate/ActivePokemonState;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_2960;", "getIcon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/class_2960;", "Lnet/minecraft/class_2487;", "nbt", "", "isShoulderedPokemon", "(Lnet/minecraft/class_2487;)Z", "Lnet/minecraft/class_3222;", "player", "isStillShouldered", "(Lnet/minecraft/class_3222;)Z", "Lnet/minecraft/class_2540;", "buffer", "Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "readFromBuffer", "(Lnet/minecraft/class_2540;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "Lcom/google/gson/JsonObject;", "json", "readFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "readFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/pokemon/activestate/PokemonState;", "", "recall", "()V", "removeShoulderEffects", "(Lnet/minecraft/class_3222;)V", "writeToBuffer", "(Lnet/minecraft/class_2540;)V", "writeToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "writeToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "isLeftShoulder", "Z", "()Z", "setLeftShoulder", "(Z)V", "Ljava/util/UUID;", "playerUUID", "Ljava/util/UUID;", "getPlayerUUID", "()Ljava/util/UUID;", "setPlayerUUID", "(Ljava/util/UUID;)V", "pokemonUUID", "getPokemonUUID", "setPokemonUUID", "kotlin.jvm.PlatformType", "stateId", "getStateId", "setStateId", "<init>", "(Ljava/util/UUID;ZLjava/util/UUID;)V", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonState.kt\ncom/cobblemon/mod/common/pokemon/activestate/ShoulderedState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1#2:203\n1855#3,2:204\n*S KotlinDebug\n*F\n+ 1 PokemonState.kt\ncom/cobblemon/mod/common/pokemon/activestate/ShoulderedState\n*L\n193#1:204,2\n*E\n"})
public final class ShoulderedState
extends ActivePokemonState {
    private boolean isLeftShoulder;
    public UUID playerUUID;
    public UUID pokemonUUID;
    private UUID stateId;
    @Nullable
    private final PokemonEntity entity;

    public ShoulderedState() {
        super(null);
        this.stateId = UUID.randomUUID();
    }

    public final boolean isLeftShoulder() {
        return this.isLeftShoulder;
    }

    public final void setLeftShoulder(boolean bl) {
        this.isLeftShoulder = bl;
    }

    @NotNull
    public final UUID getPlayerUUID() {
        UUID uUID = this.playerUUID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException("playerUUID");
        return null;
    }

    public final void setPlayerUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.playerUUID = uUID;
    }

    @NotNull
    public final UUID getPokemonUUID() {
        UUID uUID = this.pokemonUUID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pokemonUUID");
        return null;
    }

    public final void setPokemonUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.pokemonUUID = uUID;
    }

    public final UUID getStateId() {
        return this.stateId;
    }

    public final void setStateId(UUID uUID) {
        this.stateId = uUID;
    }

    public ShoulderedState(@NotNull UUID playerUUID, boolean isLeftShoulder, @NotNull UUID pokemonUUID) {
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        Intrinsics.checkNotNullParameter(pokemonUUID, "pokemonUUID");
        this();
        this.isLeftShoulder = isLeftShoulder;
        this.setPlayerUUID(playerUUID);
        this.setPokemonUUID(pokemonUUID);
    }

    @Override
    @Nullable
    public PokemonEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public class_2960 getIcon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        String suffix = this.isLeftShoulder ? "left" : "right";
        return MiscUtilsKt.cobblemonResource("textures/gui/party/party_icon_shoulder_" + suffix + ".png");
    }

    @Override
    @NotNull
    public class_2487 writeToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.method_10556("StateShoulder", this.isLeftShoulder);
        nbt.method_25927("PlayerUUID", this.getPlayerUUID());
        nbt.method_25927("StateId", this.stateId);
        nbt.method_25927("PokemonUUID", this.getPokemonUUID());
        return nbt;
    }

    @Override
    @NotNull
    public PokemonState readFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.isLeftShoulder = nbt.method_10577("StateShoulder");
        UUID uUID = nbt.method_25926("PlayerUUID");
        Intrinsics.checkNotNullExpressionValue(uUID, "nbt.getUuid(DataKeys.POKEMON_STATE_PLAYER_UUID)");
        this.setPlayerUUID(uUID);
        this.stateId = nbt.method_25926("StateId");
        UUID uUID2 = nbt.method_25926("PokemonUUID");
        Intrinsics.checkNotNullExpressionValue(uUID2, "nbt.getUuid(DataKeys.POKEMON_STATE_POKEMON_UUID)");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    @Nullable
    public JsonObject writeToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        super.writeToJSON(json);
        json.addProperty("StateShoulder", Boolean.valueOf(this.isLeftShoulder));
        json.addProperty("PlayerUUID", this.getPlayerUUID().toString());
        json.addProperty("StateId", this.stateId.toString());
        json.addProperty("PokemonUUID", this.getPokemonUUID().toString());
        return json;
    }

    @Override
    @NotNull
    public PokemonState readFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        super.readFromJSON(json);
        this.isLeftShoulder = json.get("StateShoulder").getAsBoolean();
        UUID uUID = UUID.fromString(json.get("PlayerUUID").getAsString());
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(json.get(Data\u2026TE_PLAYER_UUID).asString)");
        this.setPlayerUUID(uUID);
        this.stateId = UUID.fromString(json.get("StateId").getAsString());
        UUID uUID2 = UUID.fromString(json.get("PokemonUUID").getAsString());
        Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(json.get(Data\u2026E_POKEMON_UUID).asString)");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    public void writeToBuffer(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super.writeToBuffer(buffer);
        buffer.writeBoolean(this.isLeftShoulder);
        buffer.method_10797(this.getPlayerUUID());
        buffer.method_10797(this.stateId);
        buffer.method_10797(this.getPokemonUUID());
    }

    @Override
    @NotNull
    public PokemonState readFromBuffer(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super.readFromBuffer(buffer);
        this.isLeftShoulder = buffer.readBoolean();
        UUID uUID = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue(uUID, "buffer.readUuid()");
        this.setPlayerUUID(uUID);
        this.stateId = buffer.method_10790();
        UUID uUID2 = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue(uUID2, "buffer.readUuid()");
        this.setPokemonUUID(uUID2);
        return this;
    }

    @Override
    public void recall() {
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer(this.getPlayerUUID());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        class_2487 nbt = this.isLeftShoulder ? player.method_7356() : player.method_7308();
        Intrinsics.checkNotNullExpressionValue(nbt, "nbt");
        if (this.isShoulderedPokemon(nbt)) {
            class_1937 class_19372 = player.method_37908();
            Intrinsics.checkNotNullExpressionValue(class_19372, "player.world");
            class_243 class_2432 = player.method_19538();
            Intrinsics.checkNotNullExpressionValue(class_2432, "player.pos");
            class_3414 class_34142 = class_3417.field_26956;
            Intrinsics.checkNotNullExpressionValue(class_34142, "BLOCK_CANDLE_FALL");
            WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, class_34142, null, 0.0f, 0.0f, 28, null);
            if (this.isLeftShoulder) {
                player.method_7273(new class_2487());
            } else {
                player.method_7345(new class_2487());
            }
            this.removeShoulderEffects(player);
        }
    }

    private final void removeShoulderEffects(class_3222 player) {
        block3: {
            Pokemon partyPokemon;
            Object object;
            Object v0;
            block2: {
                Iterable iterable = PlayerExtensionsKt.party(player);
                for (Object t : iterable) {
                    Pokemon pokemon = (Pokemon)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(pokemon.getUuid(), this.getPokemonUUID())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((object = (partyPokemon = (Pokemon)v0)) == null || (object = ((Pokemon)object).getForm()) == null || (object = ((FormData)object).getShoulderEffects()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShoulderEffect effect = (ShoulderEffect)element$iv;
                boolean bl = false;
                effect.removeEffect(partyPokemon, player, this.isLeftShoulder);
            }
        }
    }

    private final boolean isShoulderedPokemon(class_2487 nbt) {
        return CompoundTagExtensionsKt.isPokemonEntity(nbt) && Intrinsics.areEqual(nbt.method_10562("Pokemon").method_10562("State").method_25926("StateId"), this.stateId);
    }

    public final boolean isStillShouldered(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        class_2487 class_24872 = this.isLeftShoulder ? player.method_7356() : player.method_7308();
        Intrinsics.checkNotNullExpressionValue(class_24872, "if (isLeftShoulder) play\u2026layer.shoulderEntityRight");
        return this.isShoulderedPokemon(class_24872);
    }
}

