/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.misc;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0016\u001a\u0004\b \u0010\u0018R\u001a\u0010!\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b!\u0010\u0016\u001a\u0004\b\"\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/pokemon/misc/GimmighoulStashHandler;", "", "Lcom/cobblemon/mod/common/api/events/pokemon/HeldItemEvent$Post;", "event", "", "giveHeldItem", "(Lcom/cobblemon/mod/common/api/events/pokemon/HeldItemEvent$Post;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_1792;", "item", "", "handleItem", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/class_1792;)Z", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1268;", "hand", "interactMob", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "", "BLOCK_VALUE", "I", "getBLOCK_VALUE", "()I", "COIN_VALUE", "getCOIN_VALUE", "INGOT_VALUE", "getINGOT_VALUE", "POUCH_VALUE", "getPOUCH_VALUE", "SACK_VALUE", "getSACK_VALUE", "SCRAP_VALUE", "getSCRAP_VALUE", "<init>", "()V", "common"})
public final class GimmighoulStashHandler {
    @NotNull
    public static final GimmighoulStashHandler INSTANCE = new GimmighoulStashHandler();
    private static final int COIN_VALUE = 1;
    private static final int POUCH_VALUE = COIN_VALUE * 9;
    private static final int SACK_VALUE = POUCH_VALUE * 9;
    private static final int SCRAP_VALUE = 1;
    private static final int INGOT_VALUE = SCRAP_VALUE * 4;
    private static final int BLOCK_VALUE = INGOT_VALUE * 9;

    private GimmighoulStashHandler() {
    }

    public final int getCOIN_VALUE() {
        return COIN_VALUE;
    }

    public final int getPOUCH_VALUE() {
        return POUCH_VALUE;
    }

    public final int getSACK_VALUE() {
        return SACK_VALUE;
    }

    public final int getSCRAP_VALUE() {
        return SCRAP_VALUE;
    }

    public final int getINGOT_VALUE() {
        return INGOT_VALUE;
    }

    public final int getBLOCK_VALUE() {
        return BLOCK_VALUE;
    }

    public final boolean interactMob(@NotNull class_1657 player, @NotNull class_1268 hand, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        class_1799 itemStack = player.method_5998(hand);
        boolean success = false;
        if (player instanceof class_3222 && Intrinsics.areEqual(pokemon.getOwnerPlayer(), player)) {
            class_1792 class_17922 = itemStack.method_7909();
            Intrinsics.checkNotNullExpressionValue(class_17922, "itemStack.item");
            success = this.handleItem(pokemon, class_17922);
            if (success) {
                itemStack.method_7934(1);
            }
        }
        return success;
    }

    public final void giveHeldItem(@NotNull HeldItemEvent.Post event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Pokemon pokemon = event.getPokemon();
        class_1792 item = event.getReceived().method_7909();
        Intrinsics.checkNotNullExpressionValue(item, "item");
        if (this.handleItem(pokemon, item)) {
            pokemon.removeHeldItem();
        }
    }

    public final boolean handleItem(@NotNull Pokemon pokemon, @NotNull class_1792 item) {
        int increase;
        class_1792 class_17922;
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        Intrinsics.checkNotNullParameter(item, "item");
        IntSpeciesFeature goldHoard = (IntSpeciesFeature)pokemon.getFeature("gimmighoul_coins");
        IntSpeciesFeature netheriteHoard = (IntSpeciesFeature)pokemon.getFeature("gimmighoul_netherite");
        if (goldHoard != null && goldHoard.getValue() < 999) {
            class_17922 = item;
            int n = Intrinsics.areEqual(class_17922, (Object)CobblemonItems.RELIC_COIN) ? COIN_VALUE : (Intrinsics.areEqual(class_17922, CobblemonItems.RELIC_COIN_POUCH) ? POUCH_VALUE : (increase = Intrinsics.areEqual(class_17922, CobblemonItems.RELIC_COIN_SACK) ? SACK_VALUE : 0));
            if (increase != 0) {
                goldHoard.setValue(goldHoard.getValue() + increase);
                if (goldHoard.getValue() > 999) {
                    goldHoard.setValue(999);
                }
                if (pokemon.getEntity() != null) {
                    PokemonEntity pokemonEntity = pokemon.getEntity();
                    Intrinsics.checkNotNull(pokemonEntity);
                    pokemonEntity.method_5783(CobblemonSounds.GIMMIGHOUL_GIVE_ITEM_SMALL, 1.0f, 1.0f);
                }
                pokemon.markFeatureDirty(goldHoard);
                return true;
            }
        }
        if (netheriteHoard != null && netheriteHoard.getValue() < 256) {
            class_17922 = item;
            int n = Intrinsics.areEqual(class_17922, class_1802.field_22021) ? SCRAP_VALUE : (Intrinsics.areEqual(class_17922, class_1802.field_22020) ? INGOT_VALUE : (increase = Intrinsics.areEqual(class_17922, class_1802.field_22018) ? BLOCK_VALUE : 0));
            if (increase != 0) {
                netheriteHoard.setValue(netheriteHoard.getValue() + increase);
                if (netheriteHoard.getValue() > 256) {
                    netheriteHoard.setValue(256);
                }
                if (pokemon.getEntity() != null) {
                    PokemonEntity pokemonEntity = pokemon.getEntity();
                    Intrinsics.checkNotNull(pokemonEntity);
                    pokemonEntity.method_5783(CobblemonSounds.GIMMIGHOUL_GIVE_ITEM_SMALL, 1.0f, 1.0f);
                }
                pokemon.markFeatureDirty(netheriteHoard);
                return true;
            }
        }
        return false;
    }
}

