/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.trade;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.TradeCompletedEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeStartedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.variants.TradeEvolution;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.PlayerTradeParticipant;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001d8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager;", "", "Lnet/minecraft/class_3222;", "player", "Ljava/util/UUID;", "tradeOfferId", "", "acceptTradeRequest", "(Lnet/minecraft/class_3222;Ljava/util/UUID;)V", "playerId", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "getActiveTrade", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/trade/ActiveTrade;", "Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "getExistingRequest", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "otherPlayerEntity", "offerTrade", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)V", "onLogoff", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "player1", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon1", "player2", "pokemon2", "performTrade", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "activeTrades", "Ljava/util/List;", "getActiveTrades", "()Ljava/util/List;", "requests", "getRequests", "<init>", "()V", "TradeRequest", "common"})
@SourceDebugExtension(value={"SMAP\nTradeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,110:1\n1#2:111\n800#3,11:112\n288#3,2:123\n800#3,11:125\n288#3,2:136\n14#4,5:138\n19#4:146\n13579#5:143\n13580#5:145\n14#6:144\n*S KotlinDebug\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n*L\n101#1:112,11\n101#1:123,2\n105#1:125,11\n105#1:136,2\n108#1:138,5\n108#1:146\n108#1:143\n108#1:145\n108#1:144\n*E\n"})
public final class TradeManager {
    @NotNull
    public static final TradeManager INSTANCE = new TradeManager();
    @NotNull
    private static final List<TradeRequest> requests = new ArrayList();
    @NotNull
    private static final List<ActiveTrade> activeTrades = new ArrayList();

    private TradeManager() {
    }

    @NotNull
    public final List<TradeRequest> getRequests() {
        return requests;
    }

    @NotNull
    public final List<ActiveTrade> getActiveTrades() {
        return activeTrades;
    }

    @Nullable
    public final TradeRequest getExistingRequest(@NotNull UUID playerId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Iterable iterable = requests;
            for (Object t : iterable) {
                TradeRequest it = (TradeRequest)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getSenderId(), playerId) || Intrinsics.areEqual(it.getReceiverId(), playerId))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ActiveTrade getActiveTrade(@NotNull UUID playerId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Iterable iterable = activeTrades;
            for (Object t : iterable) {
                ActiveTrade it = (ActiveTrade)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getPlayer1().getUuid(), playerId) || Intrinsics.areEqual(it.getPlayer2().getUuid(), playerId))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void offerTrade(@NotNull class_3222 player, @NotNull class_3222 otherPlayerEntity) {
        Object v0;
        Object[] objectArray;
        block5: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(otherPlayerEntity, "otherPlayerEntity");
            objectArray = (Object[])requests;
            for (Object t : objectArray) {
                TradeRequest it = (TradeRequest)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSenderId(), player.method_5667())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        TradeRequest existingFromPlayer = v0;
        if (existingFromPlayer != null) {
            class_3222 class_32222 = PlayerExtensionsKt.getPlayer(existingFromPlayer.getReceiverId());
            if (class_32222 != null) {
                CobblemonNetwork.INSTANCE.sendPacket(class_32222, new TradeOfferExpiredPacket(existingFromPlayer.getTradeOfferId()));
            }
        }
        UUID uUID = otherPlayerEntity.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "otherPlayerEntity.uuid");
        if (this.getActiveTrade(uUID) != null) {
            Object[] objectArray2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue(otherPlayerEntity.method_5477(), "otherPlayerEntity.name");
            player.method_7353((class_2561)LocalizationUtilsKt.lang("trade.occupied", objectArray2), true);
        } else {
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID2, "randomUUID()");
            UUID uUID3 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID3, "player.uuid");
            UUID uUID4 = otherPlayerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID4, "otherPlayerEntity.uuid");
            TradeRequest request = new TradeRequest(uUID2, uUID3, uUID4);
            requests.add(request);
            SchedulingFunctionsKt.afterOnServer$default(0, 60.0f, new Function0<Unit>(request, player, otherPlayerEntity){
                final /* synthetic */ TradeRequest $request;
                final /* synthetic */ class_3222 $player;
                final /* synthetic */ class_3222 $otherPlayerEntity;
                {
                    this.$request = $request;
                    this.$player = $player;
                    this.$otherPlayerEntity = $otherPlayerEntity;
                    super(0);
                }

                public final void invoke() {
                    if (TradeManager.INSTANCE.getRequests().remove(this.$request)) {
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue(this.$otherPlayerEntity.method_5477(), "otherPlayerEntity.name");
                        this.$player.method_7353((class_2561)LocalizationUtilsKt.lang("trade.request_expired", objectArray), true);
                    }
                }
            }, 1, null);
            UUID uUID5 = request.getTradeOfferId();
            UUID uUID6 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID6, "player.uuid");
            class_5250 class_52502 = player.method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue(class_52502, "player.name.copy()");
            CobblemonNetwork.INSTANCE.sendPacket(otherPlayerEntity, new TradeOfferNotificationPacket(uUID5, uUID6, class_52502));
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(otherPlayerEntity.method_5477(), "otherPlayerEntity.name");
            player.method_7353((class_2561)LocalizationUtilsKt.lang("trade.request_sent", objectArray), true);
        }
    }

    public final void acceptTradeRequest(@NotNull class_3222 player, @NotNull UUID tradeOfferId) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(tradeOfferId, "tradeOfferId");
            Iterable iterable = requests;
            for (Object t : iterable) {
                TradeRequest it = (TradeRequest)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTradeOfferId(), tradeOfferId)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        TradeRequest request = v0;
        if (request == null) {
            player.method_7353((class_2561)LocalizationUtilsKt.lang("trade.request_already_expired", new Object[0]), true);
        } else {
            requests.remove(request);
            class_3222 class_32222 = PlayerExtensionsKt.getPlayer(request.getSenderId());
            if (class_32222 == null) {
                return;
            }
            class_3222 otherPlayer = class_32222;
            ActiveTrade trade2 = new ActiveTrade(new PlayerTradeParticipant(player), new PlayerTradeParticipant(otherPlayer));
            activeTrades.add(trade2);
            UUID uUID = otherPlayer.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID, "otherPlayer.uuid");
            class_5250 class_52502 = otherPlayer.method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue(class_52502, "otherPlayer.name.copy()");
            CobblemonNetwork.INSTANCE.sendPacket(player, new TradeStartedPacket(uUID, class_52502, trade2.getPlayer2().getParty().mapNullPreserving(acceptTradeRequest.1.INSTANCE)));
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID2, "player.uuid");
            class_5250 class_52503 = player.method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue(class_52503, "player.name.copy()");
            CobblemonNetwork.INSTANCE.sendPacket(otherPlayer, new TradeStartedPacket(uUID2, class_52503, trade2.getPlayer1().getParty().mapNullPreserving(acceptTradeRequest.2.INSTANCE)));
        }
    }

    public final void onLogoff(@NotNull class_3222 player) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(player, "player");
            Iterable iterable = requests;
            for (Object t : iterable) {
                TradeRequest it = (TradeRequest)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getSenderId(), player.method_5667()) || Intrinsics.areEqual(it.getReceiverId(), player.method_5667()))) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        TradeRequest request = v0;
        if (request != null) {
            class_3222 otherPlayer;
            class_3222 class_32222 = otherPlayer = Intrinsics.areEqual(request.getReceiverId(), player.method_5667()) ? PlayerExtensionsKt.getPlayer(request.getSenderId()) : PlayerExtensionsKt.getPlayer(request.getReceiverId());
            if (class_32222 != null) {
                CobblemonNetwork.INSTANCE.sendPacket(class_32222, new TradeOfferExpiredPacket(request.getTradeOfferId()));
            }
            requests.remove(request);
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        ActiveTrade trade2 = this.getActiveTrade(uUID);
        if (trade2 != null) {
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue(uUID2, "player.uuid");
            TradeParticipant tradeParticipant = trade2.getTradeParticipant(uUID2);
            TradeParticipant oppositeParticipant = trade2.getOppositePlayer(tradeParticipant);
            oppositeParticipant.cancelTrade(trade2);
            activeTrades.remove(trade2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void performTrade(@NotNull TradeParticipant player1, @NotNull Pokemon pokemon1, @NotNull TradeParticipant player2, @NotNull Pokemon pokemon2) {
        void $this$iv;
        Object element$iv;
        EventObservable<TradeCompletedEvent> $this$firstOrNull$iv;
        Object element$iv$iv;
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(player1, "player1");
        Intrinsics.checkNotNullParameter(pokemon1, "pokemon1");
        Intrinsics.checkNotNullParameter(player2, "player2");
        Intrinsics.checkNotNullParameter(pokemon2, "pokemon2");
        PartyStore party1 = player1.getParty();
        PartyStore party2 = player2.getParty();
        party1.remove(pokemon1);
        party2.remove(pokemon2);
        Pokemon.setFriendship$default(pokemon1, 0, false, 2, null);
        Pokemon.setFriendship$default(pokemon2, 0, false, 2, null);
        party2.add(pokemon1);
        party1.add(pokemon2);
        Iterable $this$filterIsInstance$iv = pokemon1.getLockedEvolutions();
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof TradeEvolution)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$firstOrNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
            element$iv = $this$filterIsInstanceTo$iv$iv.next();
            TradeEvolution it = (TradeEvolution)element$iv;
            boolean bl = false;
            if (!it.attemptEvolution(pokemon1, (Object)pokemon2)) continue;
            break;
        }
        $this$filterIsInstance$iv = pokemon2.getLockedEvolutions();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof TradeEvolution)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$firstOrNull = false;
        object = $this$firstOrNull$iv.iterator();
        while (object.hasNext()) {
            element$iv = object.next();
            TradeEvolution it = (TradeEvolution)element$iv;
            boolean bl2 = false;
            if (!it.attemptEvolution(pokemon2, (Object)pokemon1)) continue;
            break;
        }
        $this$firstOrNull$iv = CobblemonEvents.TRADE_COMPLETED;
        TradeCompletedEvent[] $i$f$firstOrNull2 = new TradeCompletedEvent[]{new TradeCompletedEvent(player1, pokemon2, player2, pokemon1)};
        TradeCompletedEvent[] events$iv = $i$f$firstOrNull2;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        TradeCompletedEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            TradeCompletedEvent element$iv$iv2;
            TradeCompletedEvent tradeCompletedEvent = element$iv$iv2 = $this$forEach$iv$iv[i];
            boolean bl3 = false;
            TradeCompletedEvent it = tradeCompletedEvent;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "", "Ljava/util/UUID;", "receiverId", "Ljava/util/UUID;", "getReceiverId", "()Ljava/util/UUID;", "senderId", "getSenderId", "tradeOfferId", "getTradeOfferId", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;)V", "common"})
    public static final class TradeRequest {
        @NotNull
        private final UUID tradeOfferId;
        @NotNull
        private final UUID senderId;
        @NotNull
        private final UUID receiverId;

        public TradeRequest(@NotNull UUID tradeOfferId, @NotNull UUID senderId, @NotNull UUID receiverId) {
            Intrinsics.checkNotNullParameter(tradeOfferId, "tradeOfferId");
            Intrinsics.checkNotNullParameter(senderId, "senderId");
            Intrinsics.checkNotNullParameter(receiverId, "receiverId");
            this.tradeOfferId = tradeOfferId;
            this.senderId = senderId;
            this.receiverId = receiverId;
        }

        @NotNull
        public final UUID getTradeOfferId() {
            return this.tradeOfferId;
        }

        @NotNull
        public final UUID getSenderId() {
            return this.senderId;
        }

        @NotNull
        public final UUID getReceiverId() {
            return this.receiverId;
        }
    }
}

