/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl.asm.commons;

import com.oracle.truffle.api.impl.asm.ClassVisitor;
import com.oracle.truffle.api.impl.asm.ConstantDynamic;
import com.oracle.truffle.api.impl.asm.Handle;
import com.oracle.truffle.api.impl.asm.Label;
import com.oracle.truffle.api.impl.asm.MethodVisitor;
import com.oracle.truffle.api.impl.asm.Type;
import com.oracle.truffle.api.impl.asm.commons.InstructionAdapter;
import com.oracle.truffle.api.impl.asm.commons.LocalVariablesSorter;
import com.oracle.truffle.api.impl.asm.commons.Method;
import com.oracle.truffle.api.impl.asm.commons.TableSwitchGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GeneratorAdapter
extends LocalVariablesSorter {
    private static final String CLASS_DESCRIPTOR = "Ljava/lang/Class;";
    private static final Type BYTE_TYPE = Type.getObjectType("java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType("java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType("java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType("java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
    private static final Type NUMBER_TYPE = Type.getObjectType("java/lang/Number");
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private static final Method BOOLEAN_VALUE = Method.getMethod("boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod("char charValue()");
    private static final Method INT_VALUE = Method.getMethod("int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod("float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod("long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod("double doubleValue()");
    public static final int ADD = 96;
    public static final int SUB = 100;
    public static final int MUL = 104;
    public static final int DIV = 108;
    public static final int REM = 112;
    public static final int NEG = 116;
    public static final int SHL = 120;
    public static final int SHR = 122;
    public static final int USHR = 124;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int XOR = 130;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;
    private final int access;
    private final String name;
    private final Type returnType;
    private final Type[] argumentTypes;
    private final List<Type> localTypes = new ArrayList<Type>();

    public GeneratorAdapter(MethodVisitor methodVisitor, int access, String name, String descriptor2) {
        this(589824, methodVisitor, access, name, descriptor2);
        if (this.getClass() != GeneratorAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected GeneratorAdapter(int api, MethodVisitor methodVisitor, int access, String name, String descriptor2) {
        super(api, access, descriptor2, methodVisitor);
        this.access = access;
        this.name = name;
        this.returnType = Type.getReturnType(descriptor2);
        this.argumentTypes = Type.getArgumentTypes(descriptor2);
    }

    public GeneratorAdapter(int access, Method method, MethodVisitor methodVisitor) {
        this(methodVisitor, access, method.getName(), method.getDescriptor());
    }

    public GeneratorAdapter(int access, Method method, String signature2, Type[] exceptions, ClassVisitor classVisitor) {
        this(access, method, classVisitor.visitMethod(access, method.getName(), method.getDescriptor(), signature2, exceptions == null ? null : GeneratorAdapter.getInternalNames(exceptions)));
    }

    private static String[] getInternalNames(Type[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.argumentTypes.clone();
    }

    public void push(boolean value2) {
        this.push(value2 ? 1 : 0);
    }

    public void push(int value2) {
        if (value2 >= -1 && value2 <= 5) {
            this.mv.visitInsn(3 + value2);
        } else if (value2 >= -128 && value2 <= 127) {
            this.mv.visitIntInsn(16, value2);
        } else if (value2 >= Short.MIN_VALUE && value2 <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(long value2) {
        if (value2 == 0L || value2 == 1L) {
            this.mv.visitInsn(9 + (int)value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(float value2) {
        int bits = Float.floatToIntBits(value2);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.mv.visitInsn(11 + (int)value2);
        } else {
            this.mv.visitLdcInsn(Float.valueOf(value2));
        }
    }

    public void push(double value2) {
        long bits = Double.doubleToLongBits(value2);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.mv.visitInsn(14 + (int)value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(String value2) {
        if (value2 == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(Type value2) {
        if (value2 == null) {
            this.mv.visitInsn(1);
        } else {
            switch (value2.getSort()) {
                case 1: {
                    this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 2: {
                    this.mv.visitFieldInsn(178, "java/lang/Character", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 3: {
                    this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 4: {
                    this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 5: {
                    this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 6: {
                    this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 7: {
                    this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 8: {
                    this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                default: {
                    this.mv.visitLdcInsn(value2);
                }
            }
        }
    }

    public void push(Handle handle2) {
        if (handle2 == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(handle2);
        }
    }

    public void push(ConstantDynamic constantDynamic) {
        if (constantDynamic == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(constantDynamic);
        }
    }

    private int getArgIndex(int arg) {
        int index = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < arg; ++i) {
            index += this.argumentTypes[i].getSize();
        }
        return index;
    }

    private void loadInsn(Type type2, int index) {
        this.mv.visitVarInsn(type2.getOpcode(21), index);
    }

    private void storeInsn(Type type2, int index) {
        this.mv.visitVarInsn(type2.getOpcode(54), index);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.mv.visitVarInsn(25, 0);
    }

    public void loadArg(int arg) {
        this.loadInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public void loadArgs(int arg, int count) {
        int index = this.getArgIndex(arg);
        for (int i = 0; i < count; ++i) {
            Type argumentType = this.argumentTypes[arg + i];
            this.loadInsn(argumentType, index);
            index += argumentType.getSize();
        }
    }

    public void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    public void loadArgArray() {
        this.push(this.argumentTypes.length);
        this.newArray(OBJECT_TYPE);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            this.loadArg(i);
            this.box(this.argumentTypes[i]);
            this.arrayStore(OBJECT_TYPE);
        }
    }

    public void storeArg(int arg) {
        this.storeInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public Type getLocalType(int local) {
        return this.localTypes.get(local - this.firstLocal);
    }

    protected void setLocalType(int local, Type type2) {
        int index = local - this.firstLocal;
        while (this.localTypes.size() < index + 1) {
            this.localTypes.add(null);
        }
        this.localTypes.set(index, type2);
    }

    public void loadLocal(int local) {
        this.loadInsn(this.getLocalType(local), local);
    }

    public void loadLocal(int local, Type type2) {
        this.setLocalType(local, type2);
        this.loadInsn(type2, local);
    }

    public void storeLocal(int local) {
        this.storeInsn(this.getLocalType(local), local);
    }

    public void storeLocal(int local, Type type2) {
        this.setLocalType(local, type2);
        this.storeInsn(type2, local);
    }

    public void arrayLoad(Type type2) {
        this.mv.visitInsn(type2.getOpcode(46));
    }

    public void arrayStore(Type type2) {
        this.mv.visitInsn(type2.getOpcode(79));
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void dup2X1() {
        this.mv.visitInsn(93);
    }

    public void dup2X2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap(Type prev, Type type2) {
        if (type2.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int op, Type type2) {
        this.mv.visitInsn(type2.getOpcode(op));
    }

    public void not() {
        this.mv.visitInsn(4);
        this.mv.visitInsn(130);
    }

    public void iinc(int local, int amount) {
        this.mv.visitIincInsn(local, amount);
    }

    public void cast(Type from, Type to) {
        if (from != to) {
            if (from.getSort() < 1 || from.getSort() > 8 || to.getSort() < 1 || to.getSort() > 8) {
                throw new IllegalArgumentException("Cannot cast from " + from + " to " + to);
            }
            InstructionAdapter.cast(this.mv, from, to);
        }
    }

    private static Type getBoxedType(Type type2) {
        switch (type2.getSort()) {
            case 3: {
                return BYTE_TYPE;
            }
            case 1: {
                return BOOLEAN_TYPE;
            }
            case 4: {
                return SHORT_TYPE;
            }
            case 2: {
                return CHARACTER_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: {
                return LONG_TYPE;
            }
            case 8: {
                return DOUBLE_TYPE;
            }
        }
        return type2;
    }

    public void box(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return;
        }
        if (type2 == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxedType = GeneratorAdapter.getBoxedType(type2);
            this.newInstance(boxedType);
            if (type2.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxedType, new Method("<init>", Type.VOID_TYPE, new Type[]{type2}));
        }
    }

    public void valueOf(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return;
        }
        if (type2 == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxedType = GeneratorAdapter.getBoxedType(type2);
            this.invokeStatic(boxedType, new Method("valueOf", boxedType, new Type[]{type2}));
        }
    }

    public void unbox(Type type2) {
        Method unboxMethod;
        Type boxedType = NUMBER_TYPE;
        switch (type2.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                boxedType = CHARACTER_TYPE;
                unboxMethod = CHAR_VALUE;
                break;
            }
            case 1: {
                boxedType = BOOLEAN_TYPE;
                unboxMethod = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                unboxMethod = DOUBLE_VALUE;
                break;
            }
            case 6: {
                unboxMethod = FLOAT_VALUE;
                break;
            }
            case 7: {
                unboxMethod = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                unboxMethod = INT_VALUE;
                break;
            }
            default: {
                unboxMethod = null;
            }
        }
        if (unboxMethod == null) {
            this.checkCast(type2);
        } else {
            this.checkCast(boxedType);
            this.invokeVirtual(boxedType, unboxMethod);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public void mark(Label label) {
        this.mv.visitLabel(label);
    }

    public Label mark() {
        Label label = new Label();
        this.mv.visitLabel(label);
        return label;
    }

    public void ifCmp(Type type2, int mode, Label label) {
        switch (type2.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 151 : 152);
                break;
            }
            case 6: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 149 : 150);
                break;
            }
            case 9: 
            case 10: {
                if (mode == 153) {
                    this.mv.visitJumpInsn(165, label);
                    return;
                }
                if (mode == 154) {
                    this.mv.visitJumpInsn(166, label);
                    return;
                }
                throw new IllegalArgumentException("Bad comparison for type " + type2);
            }
            default: {
                int intOp = -1;
                switch (mode) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        intOp = 162;
                        break;
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        intOp = 164;
                        break;
                    }
                    case 157: {
                        intOp = 163;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad comparison mode " + mode);
                    }
                }
                this.mv.visitJumpInsn(intOp, label);
                return;
            }
        }
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifICmp(int mode, Label label) {
        this.ifCmp(Type.INT_TYPE, mode, label);
    }

    public void ifZCmp(int mode, Label label) {
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifNull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifNonNull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void goTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void ret(int local) {
        this.mv.visitVarInsn(169, local);
    }

    public void tableSwitch(int[] keys2, TableSwitchGenerator generator) {
        float density = keys2.length == 0 ? 0.0f : (float)keys2.length / (float)(keys2[keys2.length - 1] - keys2[0] + 1);
        this.tableSwitch(keys2, generator, density >= 0.5f);
    }

    public void tableSwitch(int[] keys2, TableSwitchGenerator generator, boolean useTable) {
        for (int i = 1; i < keys2.length; ++i) {
            if (keys2[i] >= keys2[i - 1]) continue;
            throw new IllegalArgumentException("keys must be sorted in ascending order");
        }
        Label defaultLabel = this.newLabel();
        Label endLabel = this.newLabel();
        if (keys2.length > 0) {
            int numKeys = keys2.length;
            if (useTable) {
                int i;
                int min2 = keys2[0];
                int max2 = keys2[numKeys - 1];
                int range = max2 - min2 + 1;
                Object[] labels = new Label[range];
                Arrays.fill(labels, defaultLabel);
                for (i = 0; i < numKeys; ++i) {
                    labels[keys2[i] - min2] = this.newLabel();
                }
                this.mv.visitTableSwitchInsn(min2, max2, defaultLabel, (Label[])labels);
                for (i = 0; i < range; ++i) {
                    Object label = labels[i];
                    if (label == defaultLabel) continue;
                    this.mark((Label)label);
                    generator.generateCase(i + min2, endLabel);
                }
            } else {
                int i;
                Label[] labels = new Label[numKeys];
                for (i = 0; i < numKeys; ++i) {
                    labels[i] = this.newLabel();
                }
                this.mv.visitLookupSwitchInsn(defaultLabel, keys2, labels);
                for (i = 0; i < numKeys; ++i) {
                    this.mark(labels[i]);
                    generator.generateCase(keys2[i], endLabel);
                }
            }
        }
        this.mark(defaultLabel);
        generator.generateDefault();
        this.mark(endLabel);
    }

    public void returnValue() {
        this.mv.visitInsn(this.returnType.getOpcode(172));
    }

    private void fieldInsn(int opcode, Type ownerType, String name, Type fieldType) {
        this.mv.visitFieldInsn(opcode, ownerType.getInternalName(), name, fieldType.getDescriptor());
    }

    public void getStatic(Type owner, String name, Type type2) {
        this.fieldInsn(178, owner, name, type2);
    }

    public void putStatic(Type owner, String name, Type type2) {
        this.fieldInsn(179, owner, name, type2);
    }

    public void getField(Type owner, String name, Type type2) {
        this.fieldInsn(180, owner, name, type2);
    }

    public void putField(Type owner, String name, Type type2) {
        this.fieldInsn(181, owner, name, type2);
    }

    private void invokeInsn(int opcode, Type type2, Method method, boolean isInterface) {
        String owner = type2.getSort() == 9 ? type2.getDescriptor() : type2.getInternalName();
        this.mv.visitMethodInsn(opcode, owner, method.getName(), method.getDescriptor(), isInterface);
    }

    public void invokeVirtual(Type owner, Method method) {
        this.invokeInsn(182, owner, method, false);
    }

    public void invokeConstructor(Type type2, Method method) {
        this.invokeInsn(183, type2, method, false);
    }

    public void invokeStatic(Type owner, Method method) {
        this.invokeInsn(184, owner, method, false);
    }

    public void invokeInterface(Type owner, Method method) {
        this.invokeInsn(185, owner, method, true);
    }

    public void invokeDynamic(String name, String descriptor2, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.mv.visitInvokeDynamicInsn(name, descriptor2, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    private void typeInsn(int opcode, Type type2) {
        this.mv.visitTypeInsn(opcode, type2.getInternalName());
    }

    public void newInstance(Type type2) {
        this.typeInsn(187, type2);
    }

    public void newArray(Type type2) {
        InstructionAdapter.newarray(this.mv, type2);
    }

    public void arrayLength() {
        this.mv.visitInsn(190);
    }

    public void throwException() {
        this.mv.visitInsn(191);
    }

    public void throwException(Type type2, String message) {
        this.newInstance(type2);
        this.dup();
        this.push(message);
        this.invokeConstructor(type2, Method.getMethod("void <init> (String)"));
        this.throwException();
    }

    public void checkCast(Type type2) {
        if (!type2.equals(OBJECT_TYPE)) {
            this.typeInsn(192, type2);
        }
    }

    public void instanceOf(Type type2) {
        this.typeInsn(193, type2);
    }

    public void monitorEnter() {
        this.mv.visitInsn(194);
    }

    public void monitorExit() {
        this.mv.visitInsn(195);
    }

    public void endMethod() {
        if ((this.access & 0x400) == 0) {
            this.mv.visitMaxs(0, 0);
        }
        this.mv.visitEnd();
    }

    public void catchException(Label start2, Label end2, Type exception) {
        Label catchLabel = new Label();
        if (exception == null) {
            this.mv.visitTryCatchBlock(start2, end2, catchLabel, null);
        } else {
            this.mv.visitTryCatchBlock(start2, end2, catchLabel, exception.getInternalName());
        }
        this.mark(catchLabel);
    }
}

