/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSInteropCallNode
extends JavaScriptBaseNode {
    protected JSInteropCallNode() {
    }

    protected static Object[] prepare(Object[] args2, ImportValueNode importValueNode) {
        Object[] newArgs2 = args2;
        boolean copy2 = false;
        for (int i = 0; i < args2.length; ++i) {
            Object arg = args2[i];
            Object newArg = importValueNode.executeWithTarget(arg);
            if (copy2) {
                newArgs2[i] = newArg;
                continue;
            }
            if (newArg == arg) continue;
            newArgs2 = new Object[args2.length];
            System.arraycopy(args2, 0, newArgs2, 0, i);
            newArgs2[i] = newArg;
            copy2 = true;
        }
        return newArgs2;
    }

    protected static PropertyGetNode getUncachedProperty() {
        return null;
    }

    protected static Object getProperty(JSObject receiver, PropertyGetNode propertyGetNode, Object key, Object defaultValue) {
        Object method;
        assert (JSRuntime.isPropertyKey(key));
        if (propertyGetNode == null) {
            method = JSObject.getOrDefault((JSDynamicObject)receiver, key, (Object)receiver, defaultValue);
        } else {
            assert (JSRuntime.propertyKeyEquals(TruffleString.EqualNode.getUncached(), propertyGetNode.getKey(), key));
            method = propertyGetNode.getValueOrDefault(receiver, defaultValue);
        }
        return method;
    }
}

