/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u001c\u001a\u00020\u001b*\u00060\u0017j\u0002`\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u001b*\u00060\u0017j\u0002`\u00182\u0006\u0010\u001e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "descriptor", "", "renderCallable", "(Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;)Ljava/lang/String;", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "renderFunction", "(Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;)Ljava/lang/String;", "invoke", "renderLambda", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "parameter", "renderParameter", "(Lkotlin/reflect/jvm/internal/KParameterImpl;)Ljava/lang/String;", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "renderProperty", "(Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;)Ljava/lang/String;", "Lkotlin/reflect/jvm/internal/impl/types/KotlinType;", "type", "renderType", "(Lkotlin/reflect/jvm/internal/impl/types/KotlinType;)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "receiver", "", "appendReceiverType", "(Ljava/lang/StringBuilder;Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;)V", "callable", "appendReceivers", "(Ljava/lang/StringBuilder;Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;)V", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "renderer", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "<init>", "()V", "kotlin-reflection"})
public final class ReflectionObjectRenderer {
    @NotNull
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();
    @NotNull
    private static final DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;

    private ReflectionObjectRenderer() {
    }

    private final void appendReceiverType(StringBuilder $this$appendReceiverType, ReceiverParameterDescriptor receiver) {
        if (receiver != null) {
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            $this$appendReceiverType.append(this.renderType(kotlinType));
            $this$appendReceiverType.append(".");
        }
    }

    private final void appendReceivers(StringBuilder $this$appendReceivers, CallableDescriptor callable) {
        boolean addParentheses;
        ReceiverParameterDescriptor dispatchReceiver = UtilKt.getInstanceReceiverParameter(callable);
        ReceiverParameterDescriptor extensionReceiver = callable.getExtensionReceiverParameter();
        this.appendReceiverType($this$appendReceivers, dispatchReceiver);
        boolean bl = addParentheses = dispatchReceiver != null && extensionReceiver != null;
        if (addParentheses) {
            $this$appendReceivers.append("(");
        }
        this.appendReceiverType($this$appendReceivers, extensionReceiver);
        if (addParentheses) {
            $this$appendReceivers.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor descriptor2) {
        String string;
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof PropertyDescriptor) {
            string = this.renderProperty((PropertyDescriptor)descriptor2);
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            string = this.renderFunction((FunctionDescriptor)descriptor2);
        } else {
            throw new IllegalStateException(("Illegal callable: " + descriptor2).toString());
        }
        return string;
    }

    @NotNull
    public final String renderProperty(@NotNull PropertyDescriptor descriptor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        StringBuilder $this$renderProperty_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderProperty_u24lambda_u240.append(descriptor2.isVar() ? "var " : "val ");
        INSTANCE.appendReceivers($this$renderProperty_u24lambda_u240, descriptor2);
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        $this$renderProperty_u24lambda_u240.append(renderer.renderName(name, true));
        $this$renderProperty_u24lambda_u240.append(": ");
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
        $this$renderProperty_u24lambda_u240.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderFunction(@NotNull FunctionDescriptor descriptor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        StringBuilder $this$renderFunction_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderFunction_u24lambda_u241.append("fun ");
        INSTANCE.appendReceivers($this$renderFunction_u24lambda_u241, descriptor2);
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        $this$renderFunction_u24lambda_u241.append(renderer.renderName(name, true));
        List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "descriptor.valueParameters");
        CollectionsKt.joinTo$default(list, $this$renderFunction_u24lambda_u241, ", ", "(", ")", 0, null, renderFunction.1.1.INSTANCE, 48, null);
        $this$renderFunction_u24lambda_u241.append(": ");
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        $this$renderFunction_u24lambda_u241.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderLambda(@NotNull FunctionDescriptor invoke2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(invoke2, "invoke");
        StringBuilder $this$renderLambda_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendReceivers($this$renderLambda_u24lambda_u242, invoke2);
        List<ValueParameterDescriptor> list = invoke2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "invoke.valueParameters");
        CollectionsKt.joinTo$default(list, $this$renderLambda_u24lambda_u242, ", ", "(", ")", 0, null, renderLambda.1.1.INSTANCE, 48, null);
        $this$renderLambda_u24lambda_u242.append(" -> ");
        KotlinType kotlinType = invoke2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        $this$renderLambda_u24lambda_u242.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderParameter(@NotNull KParameterImpl parameter) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        StringBuilder $this$renderParameter_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                $this$renderParameter_u24lambda_u243.append("extension receiver parameter");
                break;
            }
            case 2: {
                $this$renderParameter_u24lambda_u243.append("instance parameter");
                break;
            }
            case 3: {
                $this$renderParameter_u24lambda_u243.append("parameter #" + parameter.getIndex() + ' ' + parameter.getName());
            }
        }
        $this$renderParameter_u24lambda_u243.append(" of ");
        $this$renderParameter_u24lambda_u243.append(INSTANCE.renderCallable(parameter.getCallable().getDescriptor()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return renderer.renderType(type2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KParameter.Kind.values().length];
            try {
                nArray[KParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.INSTANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KParameter.Kind.VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

