/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.UStringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonElementSerializersKt;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/JsonLiteralSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonLiteral;", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Lkotlinx/serialization/json/JsonLiteral;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Lkotlinx/serialization/json/JsonLiteral;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "()V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJsonElementSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonElementSerializers.kt\nkotlinx/serialization/json/JsonLiteralSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    @NotNull
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("kotlinx.serialization.json.JsonLiteral", PrimitiveKind.STRING.INSTANCE);

    private JsonLiteralSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonLiteral value2) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value2, "value");
        JsonElementSerializersKt.access$verify(encoder2);
        if (value2.isString()) {
            encoder2.encodeString(value2.getContent());
            return;
        }
        if (value2.getCoerceToInlineType$kotlinx_serialization_json() != null) {
            encoder2.encodeInline(value2.getCoerceToInlineType$kotlinx_serialization_json()).encodeString(value2.getContent());
            return;
        }
        Comparable<Long> comparable = JsonElementKt.getLongOrNull(value2);
        if (comparable != null) {
            long it = ((Number)((Object)comparable)).longValue();
            boolean bl = false;
            encoder2.encodeLong(it);
            return;
        }
        comparable = UStringsKt.toULongOrNull(value2.getContent());
        if (comparable != null) {
            long it = ((ULong)comparable).unbox-impl();
            boolean bl = false;
            encoder2.encodeInline(BuiltinSerializersKt.serializer(ULong.Companion).getDescriptor()).encodeLong(it);
            return;
        }
        comparable = JsonElementKt.getDoubleOrNull(value2);
        if (comparable != null) {
            double it = ((Number)((Object)comparable)).doubleValue();
            boolean bl = false;
            encoder2.encodeDouble(it);
            return;
        }
        comparable = JsonElementKt.getBooleanOrNull(value2);
        if (comparable != null) {
            boolean it = (Boolean)comparable;
            boolean bl = false;
            encoder2.encodeBoolean(it);
            return;
        }
        encoder2.encodeString(value2.getContent());
    }

    @Override
    @NotNull
    public JsonLiteral deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        JsonElement result = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (!(result instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(result.getClass()), result.toString());
        }
        return (JsonLiteral)result;
    }
}

