/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\b\u0010\u0012\u0006\u0010b\u001a\u00020\u000b\u0012\u0006\u0010Q\u001a\u00020P\u0012\u0006\u0010V\u001a\u00020U\u0012\u000e\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010X\u00a2\u0006\u0004\bc\u0010dB1\u0012\u0006\u0010J\u001a\u00020\b\u0012\u0006\u0010Q\u001a\u00020P\u0012\u0006\u0010V\u001a\u00020U\u0012\u0010\u0010Y\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010X\u00a2\u0006\u0004\bc\u0010eJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007JT\u0010\u0012\u001a\u00028\u0000\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\b26\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00028\u00000\nH\u0082\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010&\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020!H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00102\u001a\u00020\u00152\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u000204H\u0016\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b7\u00108JA\u0010<\u001a\u00020\u0015\"\b\b\u0000\u0010\t*\u0002092\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020!2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000:2\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b<\u0010=J+\u0010>\u001a\u00020\u0015\"\u0004\b\u0000\u0010\t2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000:2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010A\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020@H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020CH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010F\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010H\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bH\u0010GJ\u001f\u0010I\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\bI\u0010$R\u0014\u0010J\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0014\u0010M\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010OR\u001a\u0010Q\u001a\u00020P8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u001e\u0010Y\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u0018\u0010[\u001a\u0004\u0018\u00010C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u001a\u0010^\u001a\u00020]8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b^\u0010_\u001a\u0004\b`\u0010a\u00a8\u0006f"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeEncoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeEncoder;", "Lkotlinx/serialization/json/internal/Composer;", "T", "Lkotlin/Function2;", "Lkotlinx/serialization/json/internal/JsonWriter;", "Lkotlin/ParameterName;", "name", "writer", "", "forceQuoting", "composerCreator", "composerAs", "(Lkotlin/jvm/functions/Function2;)Lkotlinx/serialization/json/internal/Composer;", "value", "", "encodeBoolean", "(Z)V", "", "encodeByte", "(B)V", "", "encodeChar", "(C)V", "", "encodeDouble", "(D)V", "", "index", "encodeElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "enumDescriptor", "encodeEnum", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "", "encodeFloat", "(F)V", "Lkotlinx/serialization/encoding/Encoder;", "encodeInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/Encoder;", "encodeInt", "(I)V", "Lkotlinx/serialization/json/JsonElement;", "element", "encodeJsonElement", "(Lkotlinx/serialization/json/JsonElement;)V", "", "encodeLong", "(J)V", "encodeNull", "()V", "", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "encodeNullableSerializableElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "", "encodeShort", "(S)V", "", "encodeString", "(Ljava/lang/String;)V", "encodeTypeInfo", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "endStructure", "shouldEncodeElementDefault", "composer", "Lkotlinx/serialization/json/internal/Composer;", "Lkotlinx/serialization/json/JsonConfiguration;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "Z", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/json/internal/WriteMode;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "", "modeReuseCache", "[Lkotlinx/serialization/json/JsonEncoder;", "polymorphicDiscriminator", "Ljava/lang/String;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "output", "<init>", "(Lkotlinx/serialization/json/internal/JsonWriter;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "(Lkotlinx/serialization/json/internal/Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStreamingJsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n+ 2 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n*L\n1#1,226:1\n172#1,2:239\n172#1,2:241\n20#2,12:227\n*S KotlinDebug\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n*L\n163#1:239,2\n164#1:241,2\n66#1:227,12\n*E\n"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    @NotNull
    private final Composer composer;
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @Nullable
    private final JsonEncoder[] modeReuseCache;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    @Nullable
    private String polymorphicDiscriminator;

    public StreamingJsonEncoder(@NotNull Composer composer, @NotNull Json json, @NotNull WriteMode mode, @Nullable JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter(composer, "composer");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int i = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this)) {
            this.modeReuseCache[i] = this;
        }
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(@NotNull JsonWriter output, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(modeReuseCache, "modeReuseCache");
        this(ComposersKt.Composer(output, json), json, mode, modeReuseCache);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public void encodeJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this.encodeSerializableValue(JsonElementSerializer.INSTANCE, element);
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value2) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        JsonEncoder $this$encodePolymorphically$iv = this;
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize($this$encodePolymorphically$iv, value2);
        } else {
            AbstractPolymorphicSerializer casted$iv = (AbstractPolymorphicSerializer)serializer;
            String baseClassDiscriminator$iv = PolymorphicKt.classDiscriminator(serializer.getDescriptor(), $this$encodePolymorphically$iv.getJson());
            Encoder encoder2 = $this$encodePolymorphically$iv;
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Any");
            SerializationStrategy<T> actualSerializer$iv = PolymorphicSerializerKt.findPolymorphicSerializer(casted$iv, encoder2, value2);
            PolymorphicKt.access$validateIfSealed(casted$iv, actualSerializer$iv, baseClassDiscriminator$iv);
            PolymorphicKt.checkKind(actualSerializer$iv.getDescriptor().getKind());
            String it = baseClassDiscriminator$iv;
            boolean bl = false;
            this.polymorphicDiscriminator = it;
            actualSerializer$iv.serialize($this$encodePolymorphically$iv, value2);
        }
    }

    private final void encodeTypeInfo(SerialDescriptor descriptor2) {
        this.composer.nextItem();
        String string = this.polymorphicDiscriminator;
        Intrinsics.checkNotNull(string);
        this.encodeString(string);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(descriptor2.getSerialName());
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor2);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if (this.polymorphicDiscriminator != null) {
            this.encodeTypeInfo(descriptor2);
            this.polymorphicDiscriminator = null;
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItem();
            this.composer.print(this.mode.end);
        }
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(JsonNamesMapKt.getJsonElementName(descriptor2, this.getJson(), index));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    @Override
    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull SerializationStrategy<? super T> serializer, @Nullable T value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        if (value2 != null || this.configuration.getExplicitNulls()) {
            super.encodeNullableSerializableElement(descriptor2, index, serializer, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor2) {
        Encoder encoder2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (StreamingJsonEncoderKt.isUnsignedNumber(descriptor2)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnsignedNumbers) {
                composer = this_$iv.composer;
            } else {
                void p1;
                boolean bl = this_$iv.forceQuoting;
                JsonWriter p0 = this_$iv.composer.writer;
                boolean bl2 = false;
                composer = new ComposerForUnsignedNumbers(p0, (boolean)p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer2 = composer;
            encoder2 = new StreamingJsonEncoder(composer2, json, writeMode, jsonEncoderArray);
        } else if (StreamingJsonEncoderKt.isUnquotedLiteral(descriptor2)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnquotedLiterals) {
                composer = this_$iv.composer;
            } else {
                boolean p1 = this_$iv.forceQuoting;
                JsonWriter p0 = this_$iv.composer.writer;
                boolean bl = false;
                composer = new ComposerForUnquotedLiterals(p0, p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer3 = composer;
            encoder2 = new StreamingJsonEncoder(composer3, json, writeMode, jsonEncoderArray);
        } else {
            encoder2 = super.encodeInline(descriptor2);
        }
        return encoder2;
    }

    private final /* synthetic */ <T extends Composer> T composerAs(Function2<? super JsonWriter, ? super Boolean, ? extends T> composerCreator) {
        boolean $i$f$composerAs = false;
        Intrinsics.reifiedOperationMarker(3, "T");
        return (T)(this.composer instanceof Composer ? this.composer : (Composer)composerCreator.invoke(this.composer.writer, this.forceQuoting));
    }

    @Override
    public void encodeNull() {
        this.composer.print("null");
    }

    @Override
    public void encodeBoolean(boolean value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeByte(byte value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeShort(short value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeInt(int value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeLong(long value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeFloat(float value2) {
        float f;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f = value2) && !Float.isNaN(f))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(value2), this.composer.writer.toString());
        }
    }

    @Override
    public void encodeDouble(double value2) {
        double d;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d = value2) && !Double.isNaN(d))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(value2, this.composer.writer.toString());
        }
    }

    @Override
    public void encodeChar(char value2) {
        this.encodeString(String.valueOf(value2));
    }

    @Override
    public void encodeString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.composer.printQuoted(value2);
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encodeString(enumDescriptor.getElementName(index));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

