/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.spawnercontrol.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class HandlerConfig {
    public static final File configFolder = FabricLoader.getInstance().getConfigDir().toFile();
    public static Common COMMON = new Common();

    public static void init() {
        HandlerConfig.commonFile();
    }

    private static void commonFile() {
        File configFile = new File(configFolder, "spawner_control-common.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                COMMON = (Common)gson.fromJson((Reader)fileReader, Common.class);
                fileReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        COMMON = new Common();
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            fileWriter.write(gson.toJson((Object)COMMON));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Common {
        public static boolean dv_setSpawnLimit = true;
        public static int dv_spawnLimit = 15;
        public static boolean dv_dropXp = false;
        public static int dv_spawnCount = 4;
        public static int dv_spawnRange = 4;
        public static int dv_spawnDelay = 20;
        public static int dv_minSpawnDelay = 200;
        public static int dv_maxSpawnDelay = 800;
        public static int dv_playerRange = 16;
        public static int dv_maxNearbyEntities = 6;
        public boolean setSpawnLimit = dv_setSpawnLimit;
        public int spawnLimit = dv_spawnLimit;
        public boolean dropXp = dv_dropXp;
        public int spawnCount = dv_spawnCount;
        public int spawnRange = dv_spawnRange;
        public int spawnDelay = dv_spawnDelay;
        public int minSpawnDelay = dv_minSpawnDelay;
        public int maxSpawnDelay = dv_maxSpawnDelay;
        public int playerRange = dv_playerRange;
        public int maxNearbyEntities = dv_maxNearbyEntities;
    }
}

