/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.api.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import corgitaco.enhancedcelestials.api.lunarevent.DropSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarMobSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.api.lunarevent.MobEffectInstanceBuilder;
import corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class LunarEvent {
    public static final Codec<LunarEvent> DIRECT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41223), SpawnRequirements.CODEC).fieldOf("dimension_chances").forGetter(LunarEvent::getEventChancesByDimension), (App)LunarEventClientSettings.CODEC.fieldOf("client_settings").forGetter(LunarEvent::getClientSettings), (App)LunarTextComponents.CODEC.fieldOf("text_components").forGetter(LunarEvent::getTextComponents), (App)LunarMobSettings.CODEC.fieldOf("mob_settings").forGetter(LunarEvent::getLunarMobSettings), (App)DropSettings.CODEC.fieldOf("drops").forGetter(LunarEvent::getDropSettings)).apply((Applicative)builder, LunarEvent::new));
    private final Map<class_5321<class_1937>, SpawnRequirements> eventChancesByDimension;
    private final LunarEventClientSettings clientSettings;
    private final LunarTextComponents textComponents;
    private final LunarMobSettings lunarMobSettings;
    private final DropSettings dropSettings;

    public LunarEvent(Map<class_5321<class_1937>, SpawnRequirements> eventChancesByDimension, LunarEventClientSettings clientSettings, LunarTextComponents textComponents, LunarMobSettings lunarMobSettings, DropSettings dropSettings) {
        this.eventChancesByDimension = eventChancesByDimension;
        this.clientSettings = clientSettings;
        this.textComponents = textComponents;
        this.lunarMobSettings = lunarMobSettings;
        this.dropSettings = dropSettings;
    }

    public void onBlockItemDrop(class_3218 world, class_1799 itemStack) {
        this.dropSettings.dropEnhancer().forEach((itemTagKey, multiplier) -> {
            if (itemStack.method_31573(itemTagKey)) {
                itemStack.method_7939((int)Math.round((double)itemStack.method_7947() * multiplier));
            }
        });
    }

    @Nullable
    public LunarTextComponents.Notification startNotification() {
        return this.textComponents.riseNotification().orElse(null);
    }

    @Nullable
    public LunarTextComponents.Notification endNotification() {
        return this.textComponents.setNotification().orElse(null);
    }

    public LunarEventClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public double getSpawnMultiplierForMonsterCategory(class_1311 classification) {
        return this.lunarMobSettings.spawnCategoryMultiplier().getOrDefault(classification, 1.0);
    }

    public void livingEntityTick(class_1309 entity) {
        this.lunarMobSettings.effectsForEntityTag().forEach(entityFilterMapPair -> {
            Condition entityFilter = (Condition)entityFilterMapPair.getFirst();
            if (entityFilter.passes(new ConditionContext(entity.method_37908(), entity, entity.method_29504(), 0))) {
                MobEffectInstanceBuilder builder = (MobEffectInstanceBuilder)entityFilterMapPair.getSecond();
                entity.method_6092(builder.makeInstance());
            }
        });
    }

    public LunarMobSpawnInfo getLunarSpawner() {
        return this.lunarMobSettings.lunarMobSpawnInfo();
    }

    public boolean blockSleeping(class_1309 entity) {
        return this.lunarMobSettings.blockSleeping().passes(new ConditionContext(entity.method_37908(), entity, entity.method_29504(), 0));
    }

    public LunarTextComponents getTextComponents() {
        return this.textComponents;
    }

    public LunarMobSettings getLunarMobSettings() {
        return this.lunarMobSettings;
    }

    public DropSettings getDropSettings() {
        return this.dropSettings;
    }

    public Map<class_5321<class_1937>, SpawnRequirements> getEventChancesByDimension() {
        return this.eventChancesByDimension;
    }

    public record SpawnRequirements(double chance, int minNumberOfNights, IntArraySet validMoonPhases) {
        public static final Codec<SpawnRequirements> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("chance").forGetter(SpawnRequirements::chance), (App)Codec.INT.fieldOf("min_number_of_nights_between").forGetter(SpawnRequirements::minNumberOfNights), (App)Codec.list((Codec)Codec.intRange((int)0, (int)8)).fieldOf("valid_moon_phases").forGetter(clientSettings -> new ArrayList(clientSettings.validMoonPhases))).apply((Applicative)builder, SpawnRequirements::new));

        public SpawnRequirements(double chance, int minNumberOfNights, Collection<Integer> validMoonPhases) {
            this(chance, minNumberOfNights, new IntArraySet(validMoonPhases));
        }
    }
}

