/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.core;

import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.meteor.MeteorContext;
import corgitaco.enhancedcelestials.save.LunarForecastSavedData;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class EnhancedCelestialsContext {
    private final LunarForecast lunarForecast;
    @Nullable
    private final MeteorContext meteorContext;

    private EnhancedCelestialsContext(LunarForecast forecast) {
        this.lunarForecast = forecast;
        this.meteorContext = null;
    }

    @Nullable
    public static EnhancedCelestialsContext forLevel(class_1937 level, Optional<LunarForecast.Data> saveData) {
        class_2378 lunarDimensionSettingsRegistry = level.method_30349().method_30530(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY);
        class_2378 lunarEventRegistry = level.method_30349().method_30530(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY);
        class_2960 location = level.method_27983().method_29177();
        Optional possibleLunarDimensionSettings = lunarDimensionSettingsRegistry.method_40264(class_5321.method_29179(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY, (class_2960)location));
        if (possibleLunarDimensionSettings.isPresent()) {
            class_6880 lunarDimensionSettings = (class_6880)possibleLunarDimensionSettings.get();
            LunarForecast.Data forecastData = saveData.orElseGet(() -> LunarForecastSavedData.get((class_1936)level).getForecastSaveData());
            long dayTime = level.method_8532();
            LunarForecast forecast = forecastData == null ? new LunarForecast((class_6880<LunarDimensionSettings>)lunarDimensionSettings, (class_2378<LunarEvent>)lunarEventRegistry, dayTime) : new LunarForecast((class_6880<LunarDimensionSettings>)lunarDimensionSettings, (class_2378<LunarEvent>)lunarEventRegistry, dayTime, forecastData);
            return new EnhancedCelestialsContext(forecast);
        }
        return null;
    }

    public void tick(class_1937 world) {
        this.lunarForecast.tick(world);
        if (world.method_8510() % 2400L == 0L) {
            this.save(world);
        }
    }

    public void chunkTick(class_1937 level, class_2791 chunkAccess) {
        if (this.meteorContext != null) {
            this.meteorContext.chunkTick(level, chunkAccess);
        }
    }

    public void save(class_1937 world) {
        LunarForecastSavedData.get((class_1936)world).setForecastSaveData(this.lunarForecast.data());
    }

    public LunarForecast getLunarForecast() {
        return this.lunarForecast;
    }
}

