/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.fabric.network;

import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.network.LunarContextConstructionPacket;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_638;

public class FabricNetworkHandler {
    private static final String PACKET_LOCATION = "enhancedcelestials";
    private static final Map<Class<?>, BiConsumer<?, class_2540>> ENCODERS = new ConcurrentHashMap();
    private static final Map<Class<?>, class_2960> PACKET_IDS = new ConcurrentHashMap();

    public static void init() {
        EnhancedCelestials.LOGGER.info(String.format("Initializing %s network...", PACKET_LOCATION));
        FabricNetworkHandler.registerMessage("forecast_changed", LunarForecastChangedPacket.class, LunarForecastChangedPacket::write, LunarForecastChangedPacket::readFromPacket, LunarForecastChangedPacket::handle);
        FabricNetworkHandler.registerMessage("context_construction", LunarContextConstructionPacket.class, LunarContextConstructionPacket::write, LunarContextConstructionPacket::readFromPacket, LunarContextConstructionPacket::handle);
        EnhancedCelestials.LOGGER.info(String.format("Initialized %s network!", PACKET_LOCATION));
    }

    private static <T> void registerMessage(String id, Class<T> clazz, BiConsumer<T, class_2540> encode, Function<class_2540, T> decode, BiConsumer<T, class_1937> handler) {
        ENCODERS.put(clazz, encode);
        PACKET_IDS.put(clazz, new class_2960(PACKET_LOCATION, id));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.registerClientReceiver(id, decode, handler);
        }
    }

    public static <MSG> void sendToPlayer(class_3222 player, MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
    }

    public static <MSG> void sendToAllPlayers(List<class_3222> players, MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf));
    }

    public static class ClientProxy {
        public static <T> void registerClientReceiver(String id, Function<class_2540, T> decode, BiConsumer<T, class_1937> handler) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(FabricNetworkHandler.PACKET_LOCATION, id), (client, listener, buf, responseSender) -> {
                buf.retain();
                client.execute(() -> {
                    Object packet = decode.apply(buf);
                    class_638 level = client.field_1687;
                    if (level != null) {
                        try {
                            handler.accept((Object)packet, (class_1937)level);
                        }
                        catch (Throwable throwable) {
                            EnhancedCelestials.LOGGER.error("Packet failed: ", throwable);
                            throw throwable;
                        }
                    }
                    buf.release();
                });
            });
        }
    }
}

