/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import corgitaco.enhancedcelestials.platform.services.IPlatformHelper;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7924;

public class LunarForecast {
    private final class_6880<LunarDimensionSettings> dimensionSettingsHolder;
    private final List<LunarEventInstance> forecast;
    private final List<LunarEventInstance> pastEvents;
    private final class_2378<LunarEvent> lunarEventRegistry;
    private final List<class_6880<LunarEvent>> scrambledKeys;
    private class_6880<LunarEvent> currentEvent;
    private class_6880<LunarEvent> mostRecentEvent;
    private final class_6880<LunarEvent> defaultEvent;
    private float blend = 1.0f;
    private long lastCheckedGameTime;

    public LunarForecast(class_6880<LunarDimensionSettings> dimensionSettingsHolder, class_2378<LunarEvent> lunarEventRegistry, long currentDayTime, Data savedData) {
        this(dimensionSettingsHolder, lunarEventRegistry, currentDayTime, savedData.forecast(), savedData.pastEvents(), savedData.lastCheckedGameTime());
    }

    public LunarForecast(class_6880<LunarDimensionSettings> dimensionSettingsHolder, class_2378<LunarEvent> lunarEventRegistry, long currentDayTime) {
        this(dimensionSettingsHolder, lunarEventRegistry, currentDayTime, new ArrayList<LunarEventInstance>(), new ArrayList<LunarEventInstance>(), -1L);
    }

    public LunarForecast(class_6880<LunarDimensionSettings> dimensionSettingsHolder, class_2378<LunarEvent> lunarEventRegistry, long currentDayTime, List<LunarEventInstance> forecast, List<LunarEventInstance> pastEvents, long lastCheckedGameTime) {
        this.lunarEventRegistry = lunarEventRegistry;
        LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)dimensionSettingsHolder.comp_349();
        HashSet<class_6880.class_6883> possibleEvents = new HashSet<class_6880.class_6883>();
        for (Map.Entry resourceKeyLunarEventEntry : lunarEventRegistry.method_29722()) {
            class_6880.class_6883 lunarEventHolder = lunarEventRegistry.method_40290((class_5321)resourceKeyLunarEventEntry.getKey());
            class_5321 levelResourceKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_5321)dimensionSettingsHolder.method_40230().orElseThrow()).method_29177());
            if (!((LunarEvent)lunarEventHolder.comp_349()).getEventChancesByDimension().containsKey(levelResourceKey)) continue;
            possibleEvents.add(lunarEventHolder);
        }
        this.dimensionSettingsHolder = dimensionSettingsHolder;
        this.forecast = new ArrayList<LunarEventInstance>(forecast);
        this.pastEvents = new ArrayList<LunarEventInstance>(pastEvents);
        Set possibleEventResourceKeys = possibleEvents.stream().map(class_6880::method_40230).map(Optional::orElseThrow).collect(Collectors.toSet());
        for (int i = 0; i < forecast.size(); ++i) {
            LunarEventInstance lunarEventInstance = forecast.get(i);
            class_5321<LunarEvent> lunarEventKey = lunarEventInstance.getLunarEventKey();
            if (possibleEventResourceKeys.contains(lunarEventKey)) continue;
            EnhancedCelestials.LOGGER.error(String.format("\"%s\" is not a valid lunar event key, removing....", lunarEventKey.method_29177()));
            this.forecast.remove(i);
        }
        this.lastCheckedGameTime = lastCheckedGameTime;
        this.scrambledKeys = new ArrayList<class_6880<LunarEvent>>(possibleEvents);
        this.defaultEvent = lunarEventRegistry.method_40290(lunarDimensionSettings.defaultEvent());
        this.currentEvent = !forecast.isEmpty() && forecast.get(0).active(currentDayTime / lunarDimensionSettings.dayLength()) ? forecast.get(0).getEvent(lunarEventRegistry) : this.defaultEvent;
        this.mostRecentEvent = pastEvents.isEmpty() ? this.defaultEvent : pastEvents.get(0).getEvent(lunarEventRegistry);
    }

    public Data data() {
        return new Data(this.forecast, this.pastEvents, this.lastCheckedGameTime);
    }

    public void recompute(class_3218 level) {
        this.forecast.clear();
        this.lastCheckedGameTime = Long.MIN_VALUE;
        if (LunarForecast.updateForecast(level, (LunarDimensionSettings)this.dimensionSettingsHolder.comp_349(), this)) {
            List players = level.method_18456();
            IPlatformHelper.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.method_23886()));
        }
    }

    public Pair<class_2561, Boolean> setOrReplaceEventWithResponse(class_7066.class_7068<LunarEvent> result, long currentDay, class_5819 randomSource) {
        if (result.test(this.currentEvent)) {
            return Pair.of((Object)class_2561.method_43471((String)"Event is already active"), (Object)false);
        }
        Either unwrappedResult = result.method_41173();
        Optional left = unwrappedResult.left();
        if (left.isPresent()) {
            class_5321 resourceKey = (class_5321)left.orElseThrow();
            this.removeIfActive(currentDay);
            this.forecast.add(0, new LunarEventInstance((class_5321<LunarEvent>)resourceKey, currentDay, true));
            return Pair.of((Object)class_2561.method_43469((String)"Set lunar event to \"%s\"", (Object[])new Object[]{resourceKey.method_29177()}), (Object)true);
        }
        Optional right = unwrappedResult.right();
        class_6862 lunarEventTagKey = (class_6862)right.orElseThrow();
        Optional tag = this.lunarEventRegistry.method_40266(lunarEventTagKey);
        if (tag.isPresent()) {
            class_6880 randomElement = (class_6880)((class_6885.class_6888)tag.get()).method_40243(randomSource).orElseThrow();
            this.removeIfActive(currentDay);
            this.forecast.add(0, new LunarEventInstance((class_5321<LunarEvent>)((class_5321)randomElement.method_40230().orElseThrow()), currentDay, true));
            return Pair.of((Object)class_2561.method_43469((String)"Set lunar event to \"%s\" from tag \"%s\"", (Object[])new Object[]{lunarEventTagKey.comp_327(), lunarEventTagKey.comp_327()}), (Object)true);
        }
        return Pair.of((Object)class_2561.method_43469((String)"Could not set lunar event for result:\n\"%s\"", (Object[])new Object[]{result.toString()}), (Object)false);
    }

    public class_2561 getForecastComponent(long currentDayTime) {
        long currentDay = currentDayTime / ((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).dayLength();
        class_5250 textComponent = null;
        for (int i = Math.min(100, this.getForecast().size() - 1); i >= 0; --i) {
            LunarEventInstance lunarEventInstance = this.getForecast().get(i);
            class_6880<LunarEvent> event = lunarEventInstance.getEvent(this.lunarEventRegistry);
            CustomTranslationTextComponent name = ((LunarEvent)event.comp_349()).getTextComponents().name();
            class_5251 color = name.getStyle().method_10973();
            if (textComponent == null) {
                textComponent = class_2561.method_43471((String)name.getKey()).method_27696(class_2583.field_24360.method_27703(color));
            } else {
                textComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27696(class_2583.field_24360.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43471((String)name.getKey()).method_27696(class_2583.field_24360.method_27703(color)));
            }
            textComponent.method_10852((class_2561)class_2561.method_43469((String)"enhancedcelestials.lunarforecast.days_left", (Object[])new Object[]{lunarEventInstance.getDaysUntil(currentDay)}).method_27696(class_2583.field_24360.method_27703(color)));
        }
        if (textComponent != null) {
            return class_2561.method_43469((String)"enhancedcelestials.lunarforecast.header", (Object[])new Object[]{textComponent.method_10852((class_2561)class_2561.method_43470((String)".").method_27696(class_2583.field_24360.method_10977(class_124.field_1068)))});
        }
        return class_2561.method_43469((String)"enhancedcelestials.lunarforecast.empty", (Object[])new Object[]{textComponent}).method_27692(class_124.field_1054);
    }

    private void removeIfActive(long currentDay) {
        if (!this.forecast.isEmpty() && this.forecast.get(0).active(currentDay)) {
            this.forecast.remove(0);
        }
    }

    public void tick(class_1937 level) {
        LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)this.dimensionSettingsHolder.comp_349();
        class_6880<LunarEvent> lastCurrentEvent = this.currentEvent;
        long dayTime = level.method_8532();
        long dayLength = lunarDimensionSettings.dayLength();
        long currentDay = dayTime / dayLength;
        if (!level.field_9236) {
            this.serverTick((class_3218)level, lastCurrentEvent, lunarDimensionSettings, currentDay);
        }
        this.blend = class_3532.method_15363((float)(this.blend + 0.01f), (float)0.0f, (float)1.0f);
    }

    private void serverTick(class_3218 level, class_6880<LunarEvent> lastCurrentEvent, LunarDimensionSettings lunarDimensionSettings, long currentDay) {
        List players = level.method_18456();
        if (LunarForecast.updateForecast(level, lunarDimensionSettings, this)) {
            IPlatformHelper.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.method_23886()));
        }
        LunarForecast.updatePastEventsAndRecentAndCurrentEvents(this, currentDay, lunarDimensionSettings.trackedPastEventsMaxCount());
        LunarEventInstance lunarEventInstance = this.forecast.get(0);
        this.currentEvent = lunarEventInstance.active(currentDay) && level.method_23886() ? lunarEventInstance.getEvent(this.lunarEventRegistry) : this.defaultEvent;
        if (level.method_8530()) {
            this.currentEvent = this.defaultEvent;
        }
        if (lastCurrentEvent != this.currentEvent) {
            this.onLunarEventChange(lastCurrentEvent, players, level.method_23886());
        }
        if (level.method_8510() % 6000L == 0L) {
            IPlatformHelper.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.method_23886()));
        }
    }

    private void onLunarEventChange(class_6880<LunarEvent> lastCurrentEvent, List<class_3222> players, boolean isNight) {
        this.blend = 0.0f;
        IPlatformHelper.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, isNight));
        this.notifyPlayers(lastCurrentEvent, players);
    }

    private void notifyPlayers(class_6880<LunarEvent> lastCurrentEvent, List<class_3222> players) {
        this.sendNotificationToPlayers(players, ((LunarEvent)lastCurrentEvent.comp_349()).endNotification());
        this.sendNotificationToPlayers(players, ((LunarEvent)this.currentEvent.comp_349()).startNotification());
    }

    private void sendNotificationToPlayers(List<class_3222> players, @Nullable LunarTextComponents.Notification notification) {
        LunarTextComponents.NotificationType notificationType;
        if (notification != null && (notificationType = notification.notificationType()) != LunarTextComponents.NotificationType.NONE) {
            boolean hotBar = notificationType == LunarTextComponents.NotificationType.HOT_BAR;
            for (class_3222 player : players) {
                player.method_7353(notification.customTranslationTextComponent().getComponent(), hotBar);
            }
        }
    }

    public void setLastCheckedGameTime(long lastCheckedGameTime) {
        this.lastCheckedGameTime = lastCheckedGameTime;
    }

    public void setCurrentEvent(class_5321<LunarEvent> key) {
        this.setCurrentEvent((class_6880<LunarEvent>)this.lunarEventRegistry.method_40290(key));
    }

    public void setCurrentEvent(class_6880<LunarEvent> currentEvent) {
        if (currentEvent != this.currentEvent) {
            this.mostRecentEvent = this.currentEvent;
            this.currentEvent = currentEvent;
            this.blend = 0.0f;
        }
    }

    public class_6880<LunarDimensionSettings> getDimensionSettingsHolder() {
        return this.dimensionSettingsHolder;
    }

    public List<LunarEventInstance> getForecast() {
        return this.forecast;
    }

    public long getLastCheckedGameTime() {
        return this.lastCheckedGameTime;
    }

    public List<LunarEventInstance> getPastEvents() {
        return this.pastEvents;
    }

    public class_6880<LunarEvent> getCurrentEvent(boolean isClearSkies) {
        if (((LunarDimensionSettings)this.dimensionSettingsHolder.comp_349()).requiresClearSkies() && !isClearSkies) {
            return this.defaultEvent;
        }
        return this.currentEvent;
    }

    public class_6880<LunarEvent> getCurrentEventRaw() {
        return this.currentEvent;
    }

    public class_6880<LunarEvent> getMostRecentEvent() {
        return this.mostRecentEvent;
    }

    public float getBlend() {
        return this.blend;
    }

    public static boolean updateForecast(class_3218 world, LunarDimensionSettings dimensionSettings, LunarForecast lunarForecast) {
        return LunarForecast.updateForecast(world, dimensionSettings, lunarForecast, day -> world.method_8412() + (long)world.method_27983().method_29177().hashCode() + day);
    }

    public static boolean updateForecast(class_3218 world, LunarDimensionSettings dimensionSettings, LunarForecast lunarForecast, Long2LongFunction seed) {
        long dayTime = world.method_8532();
        long lastCheckedTime = lunarForecast.getLastCheckedGameTime();
        long dayLength = dimensionSettings.dayLength();
        long yearLengthInDays = dimensionSettings.yearLengthInDays();
        long lastCheckedDay = lastCheckedTime / dayLength;
        long currentDay = dayTime / dayLength;
        if (lastCheckedDay < currentDay) {
            lunarForecast.getForecast().clear();
            lunarForecast.setLastCheckedGameTime(currentDay * dayLength);
            lastCheckedTime = lunarForecast.getLastCheckedGameTime();
            lastCheckedDay = lastCheckedTime / dayLength;
        }
        if (currentDay + yearLengthInDays <= lastCheckedDay) {
            return false;
        }
        ArrayList<LunarEventInstance> newLunarEvents = new ArrayList<LunarEventInstance>();
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        List<LunarEventInstance> forecast = lunarForecast.getForecast();
        long lastDay = !forecast.isEmpty() ? forecast.get(forecast.size() - 1).scheduledDay() : currentDay;
        long day = lastCheckedDay;
        for (LunarEventInstance lunarEventInstance : forecast) {
            eventByLastTime.put((Object)((LunarEvent)lunarEventInstance.getEvent(lunarForecast.lunarEventRegistry).comp_349()), lunarEventInstance.scheduledDay());
        }
        while (day <= currentDay + yearLengthInDays) {
            dayTime += dayLength;
            Random random = new Random(seed.applyAsLong(day));
            Collections.shuffle(lunarForecast.scrambledKeys, random);
            for (class_6880<LunarEvent> lunarEventHolder : lunarForecast.scrambledKeys) {
                LunarEvent value;
                LunarEvent.SpawnRequirements spawnRequirements;
                boolean canCreateEventInstance;
                Map<class_5321<class_1937>, LunarEvent.SpawnRequirements> eventChancesByDimension = ((LunarEvent)lunarEventHolder.comp_349()).getEventChancesByDimension();
                if (!eventChancesByDimension.containsKey(world.method_27983()) || !(canCreateEventInstance = LunarForecast.canCreateEventInstance(world, dimensionSettings, dayTime, currentDay, (Object2LongArrayMap<LunarEvent>)eventByLastTime, lastDay, day, random, spawnRequirements = eventChancesByDimension.get(world.method_27983()), value = (LunarEvent)lunarEventHolder.comp_349()))) continue;
                lastDay = day;
                newLunarEvents.add(new LunarEventInstance((class_5321<LunarEvent>)((class_5321)lunarEventHolder.method_40230().orElseThrow()), day));
                eventByLastTime.put((Object)value, day);
            }
            ++day;
        }
        forecast.addAll(newLunarEvents);
        lunarForecast.setLastCheckedGameTime(day * dayLength);
        return true;
    }

    private static boolean canCreateEventInstance(class_3218 world, LunarDimensionSettings dimensionSettings, long dayTime, long currentDay, Object2LongArrayMap<LunarEvent> eventByLastTime, long lastDay, long day, Random random, LunarEvent.SpawnRequirements spawnRequirements, LunarEvent value) {
        boolean pastMinNumberOfNightsBetweenThisTypeOfEvent = day - eventByLastTime.getOrDefault((Object)value, currentDay) > (long)spawnRequirements.minNumberOfNights();
        boolean pastMinNumberOfNightsBetweenAllEvents = day - lastDay > dimensionSettings.minDaysBetweenEvents();
        boolean isValidMoonPhase = spawnRequirements.validMoonPhases().contains(world.method_8597().method_28531(dayTime - 1L));
        boolean chance = spawnRequirements.chance() > random.nextDouble();
        return pastMinNumberOfNightsBetweenThisTypeOfEvent && pastMinNumberOfNightsBetweenAllEvents && chance && isValidMoonPhase;
    }

    private static void updatePastEventsAndRecentAndCurrentEvents(LunarForecast lunarForecast, long currentDay, long trackedPastEventsMaxCount) {
        LunarEventInstance mostRecentInstance;
        if (!lunarForecast.getForecast().isEmpty() && (mostRecentInstance = lunarForecast.getForecast().get(0)).passed(currentDay)) {
            lunarForecast.forecast.remove(0);
            List<LunarEventInstance> pastEvents = lunarForecast.pastEvents;
            pastEvents.add(0, mostRecentInstance);
            while ((long)pastEvents.size() > trackedPastEventsMaxCount) {
                pastEvents.remove(pastEvents.size() - 1);
            }
            lunarForecast.mostRecentEvent = mostRecentInstance.getEvent(lunarForecast.lunarEventRegistry);
        }
    }

    public record Data(List<LunarEventInstance> forecast, List<LunarEventInstance> pastEvents, long lastCheckedGameTime) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventInstance.CODEC.listOf().fieldOf("forecast").forGetter(Data::forecast), (App)LunarEventInstance.CODEC.listOf().fieldOf("past_events").forGetter(Data::pastEvents), (App)Codec.LONG.fieldOf("last_checked_game_time").forGetter(Data::lastCheckedGameTime)).apply((Applicative)builder, Data::new));
    }
}

