/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network;

import com.mojang.serialization.DynamicOps;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.network.S2CPacket;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2540;

public class LunarForecastChangedPacket
implements S2CPacket {
    private final LunarForecast.Data lunarForecast;
    private final boolean isNight;

    public LunarForecastChangedPacket(LunarForecast forecast, boolean isNight) {
        this(forecast.data(), isNight);
    }

    public LunarForecastChangedPacket(LunarForecast.Data lunarForecast, boolean isNight) {
        this.lunarForecast = lunarForecast;
        this.isNight = isNight;
    }

    public static LunarForecastChangedPacket readFromPacket(class_2540 buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast.Data)buf.method_29171((DynamicOps)class_2509.field_11560, LunarForecast.Data.CODEC), buf.readBoolean());
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void write(class_2540 buf) {
        try {
            buf.method_29172((DynamicOps)class_2509.field_11560, LunarForecast.Data.CODEC, (Object)this.lunarForecast);
            buf.writeBoolean(this.isNight);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void handle(class_1937 level) {
        EnhancedCelestialsContext enhancedCelestialsContext;
        if (level != null && (enhancedCelestialsContext = ((EnhancedCelestialsWorldData)level).getLunarContext()) != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            lunarForecast.getForecast().clear();
            lunarForecast.getForecast().addAll(this.lunarForecast.forecast());
            lunarForecast.getPastEvents().clear();
            lunarForecast.getPastEvents().addAll(this.lunarForecast.pastEvents());
            lunarForecast.setLastCheckedGameTime(this.lunarForecast.lastCheckedGameTime());
            if (!lunarForecast.getForecast().isEmpty()) {
                LunarEventInstance lunarEventInstance = lunarForecast.getForecast().get(0);
                LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)lunarForecast.getDimensionSettingsHolder().comp_349();
                long currentDay = level.method_8532() / lunarDimensionSettings.dayLength();
                if (lunarEventInstance.active(currentDay) && this.isNight) {
                    lunarForecast.setCurrentEvent(lunarEventInstance.getLunarEventKey());
                } else {
                    lunarForecast.setCurrentEvent(lunarDimensionSettings.defaultEvent());
                }
            }
        }
    }
}

