/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7066;

public class SetLunarEventCommand {
    private static final DynamicCommandExceptionType ERROR_LUNAR_EVENT_INVALID = new DynamicCommandExceptionType(obj -> class_2561.method_43469((String)"enhancedcelestials.commands.setlunarevent.invalid", (Object[])new Object[]{obj}));

    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {
        return class_2170.method_9247((String)"setLunarEvent").then(class_2170.method_9244((String)"lunarEvent", (ArgumentType)class_7066.method_41170(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY)).executes(cs -> SetLunarEventCommand.setLunarEvent((class_2168)cs.getSource(), (class_7066.class_7068<LunarEvent>)class_7066.method_41166((CommandContext)cs, (String)"lunarEvent", EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (DynamicCommandExceptionType)ERROR_LUNAR_EVENT_INVALID))));
    }

    public static int setLunarEvent(class_2168 source, class_7066.class_7068<LunarEvent> lunarEventResult) {
        class_3218 world = source.method_9225();
        EnhancedCelestialsContext enhancedCelestialsContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (enhancedCelestialsContext == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"enhancedcelestials.commands.disabled"));
            return 0;
        }
        LunarForecast forecast = enhancedCelestialsContext.getLunarForecast();
        long dayLength = ((LunarDimensionSettings)forecast.getDimensionSettingsHolder().comp_349()).dayLength();
        long currentDay = world.method_8532() / dayLength;
        Pair<class_2561, Boolean> component = forecast.setOrReplaceEventWithResponse(lunarEventResult, currentDay, source.method_9225().method_8409());
        if (((Boolean)component.getSecond()).booleanValue()) {
            if (!world.method_23886()) {
                world.method_29199(currentDay * dayLength + 13000L);
            }
            source.method_9226(() -> component.getFirst(), true);
            return 1;
        }
        source.method_9213((class_2561)component.getFirst());
        return 0;
    }
}

