/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.world.level.levelgen.structure.crater;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import corgitaco.enhancedcelestials.util.FastNoise;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructurePieceTypes;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.crater.CraterStructure;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;

public class CraterPiece
extends class_3443 {
    protected static FastNoise fastNoise = (FastNoise)class_156.method_654((Object)new FastNoise(20202), noise -> {
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.004f);
    });
    private final CraterStructure.PieceStructureInfo structureInfo;

    protected CraterPiece(CraterStructure.PieceStructureInfo structureInfo, int genDepth, class_3341 boundingBox) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), genDepth, boundingBox);
        this.structureInfo = structureInfo;
    }

    public CraterPiece(class_6625 context, class_2487 tag) {
        super(ECStructurePieceTypes.CRATER_PIECE.get(), tag);
        this.structureInfo = (CraterStructure.PieceStructureInfo)((Pair)CraterStructure.PieceStructureInfo.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("crater_info")).result().orElseThrow()).getFirst();
    }

    protected void method_14943(class_6625 context, class_2487 compoundTag) {
        compoundTag.method_10566("crater_info", (class_2520)CraterStructure.PieceStructureInfo.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.structureInfo).result().orElseThrow());
    }

    public void method_14931(class_5281 worldGenLevel, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
        double radius = this.structureInfo.baseRadiusX();
        double radiusZ = this.structureInfo.baseRadiusZ();
        double yRadius = 40.0;
        class_2338 origin = this.structureInfo.origin();
        int baseHeight = origin.method_10264();
        class_2338 subtract = origin.method_10069((int)(-radius), 0, (int)(-radiusZ));
        int startX = subtract.method_10263();
        int startZ = subtract.method_10260();
        class_2338 add = origin.method_10069((int)radius, 0, (int)radiusZ);
        int endX = add.method_10263();
        int endZ = add.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int minX = Math.max(startX - 10, chunkPos.method_8326());
        int maxX = Math.min(endX + 10, chunkPos.method_8327());
        int minZ = Math.max(startZ - 10, chunkPos.method_8328());
        int maxZ = Math.min(endZ + 10, chunkPos.method_8329());
        double xRadiusSquared = radius * radius;
        double yRadiusSquared = yRadius * yRadius;
        double zRadiusSquared = radiusZ * radiusZ;
        for (int worldX = minX; worldX <= maxX; ++worldX) {
            int localX = worldX - origin.method_10263();
            mutable.method_10103(worldX, 0, 0);
            for (int worldZ = minZ; worldZ <= maxZ; ++worldZ) {
                int localZ = worldZ - origin.method_10260();
                mutable.method_10103(worldX, 0, worldZ);
                for (double y = -yRadius; y <= yRadius; y += 1.0) {
                    mutable.method_10102((double)worldX, (double)baseHeight + y, (double)worldZ);
                    double equationResult = (double)(localX * localX) / xRadiusSquared + y * y / yRadiusSquared + (double)(localZ * localZ) / zRadiusSquared;
                    double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable.method_10263(), mutable.method_10260());
                    if (equationResult >= 1.0) continue;
                    worldGenLevel.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 3);
                }
            }
        }
    }
}

