/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client;

import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_3756;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_7752;
import net.minecraft.class_7761;
import net.minecraft.class_837;
import net.potionstudios.biomeswevegone.client.renderer.BWGBoatRenderer;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWarRenderer;
import net.potionstudios.biomeswevegone.world.entity.oddion.OddionRenderer;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWardenRenderer;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntities;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;

public class BiomesWeveGoneClient {
    private static final class_3756 NOISE = new class_3756((class_5819)new class_6677(1L));

    public static void onInitialize(class_310 minecraft) {
        BWGWoodSet.woodsets().forEach(set -> BiomesWeveGoneClient.registerWoodTypes(set.woodType()));
    }

    private static void registerWoodTypes(class_4719 woodType) {
        class_4722.field_21712.put(woodType, class_4722.method_24064((class_4719)woodType));
        class_4722.field_40515.put(woodType, class_4722.method_45782((class_4719)woodType));
    }

    public static void registerEntityRenderers(BiConsumer<class_1299<? extends class_1297>, class_5617> consumer) {
        consumer.accept(BWGEntities.MAN_O_WAR.get(), ManOWarRenderer::new);
        consumer.accept(BWGEntities.PUMPKIN_WARDEN.get(), PumpkinWardenRenderer::new);
        consumer.accept(BWGEntities.ODDION.get(), OddionRenderer::new);
        consumer.accept(BWGEntities.BWG_BOAT.get(), context -> new BWGBoatRenderer(context, false));
        consumer.accept(BWGEntities.BWG_CHEST_BOAT.get(), context -> new BWGBoatRenderer(context, true));
    }

    public static void registerBlockEntityRenderers(BiConsumer<class_2591<? extends class_2586>, class_5614> consumer) {
        consumer.accept(BWGBlockEntities.SIGNS.get(), class_837::new);
        consumer.accept(BWGBlockEntities.HANGING_SIGNS.get(), class_7761::new);
    }

    public static void registerLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
        for (BWGBoatEntity.Type type : BWGBoatEntity.Type.values()) {
            consumer.accept(BWGBoatRenderer.createBoatModelName(type), class_554::method_31985);
            consumer.accept(BWGBoatRenderer.createChestBoatModelName(type), class_7752::method_45708);
        }
    }

    public static int getBorealisIceColor(class_2338 pos) {
        float frequency = 0.01f;
        float factor = (float)((NOISE.method_33658((double)((float)pos.method_10263() * frequency), (double)((float)pos.method_10264() * frequency), (double)((float)pos.method_10260() * frequency)) + 1.0) * 0.5);
        float startHue = 320.0f;
        float endHue = 120.0f;
        float hue = startHue + (endHue - startHue) * factor;
        return Color.getHSBColor(hue / 360.0f, 0.6f, 1.0f).getRGB();
    }
}

