/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import com.mojang.datafixers.util.Pair;
import corgitaco.corgilib.serialization.codec.Wrapped;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.util.BWGUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGRegionUtils;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGWorldGenConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.selector.BWGBiomeSelectors;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.selector.TerraBlenderBiomeSelectors;
import org.apache.commons.lang3.mutable.MutableInt;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.TerrablenderOverworldBiomeBuilder;

public class BWGTerraBlenderRegion
extends Region {
    public static final BWGTerraBlenderRegion REGION_1 = new BWGTerraBlenderRegion(BWGWorldGenConfig.INSTANCE.get().regionWeight(), BWGBiomeSelectors.OCEANS_BWG, BWGBiomeSelectors.MIDDLE_BIOMES_BWG, BWGBiomeSelectors.MIDDLE_BIOMES_VARIANT_BWG, BWGBiomeSelectors.PLATEAU_BIOMES_BWG, BWGBiomeSelectors.PLATEAU_BIOMES_VARIANT_BWG, BWGBiomeSelectors.SHATTERED_BIOMES_BWG, BWGBiomeSelectors.BEACH_BIOMES_BWG, BWGBiomeSelectors.PEAK_BIOMES_BWG, BWGBiomeSelectors.PEAK_BIOMES_VARIANT_BWG, BWGBiomeSelectors.SLOPE_BIOMES_BWG, TerraBlenderBiomeSelectors.SLOPE_BIOMES_VARIANT_TERRABLENDER, (Map<class_5321<class_1959>, class_5321<class_1959>>)((Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_38748, BWGBiomes.WHITE_MANGROVE_MARSHES);
        map.put(class_1972.field_9471, BWGBiomes.CYPRESS_SWAMPLANDS);
    })), Map.of());
    public static final BWGTerraBlenderRegion REGION_2 = new BWGTerraBlenderRegion(BWGWorldGenConfig.INSTANCE.get().regionWeight(), BWGBiomeSelectors.OCEANS_2_BWG, BWGBiomeSelectors.MIDDLE_BIOMES_2_BWG, TerraBlenderBiomeSelectors.MIDDLE_BIOMES_VARIANT_TERRABLENDER, BWGBiomeSelectors.PLATEAU_BIOMES_2_BWG, TerraBlenderBiomeSelectors.PLATEAU_BIOMES_VARIANT_TERRABLENDER, TerraBlenderBiomeSelectors.SHATTERED_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.BEACH_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.PEAK_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.PEAK_BIOMES_VARIANT_TERRABLENDER, TerraBlenderBiomeSelectors.SLOPE_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.SLOPE_BIOMES_VARIANT_TERRABLENDER, (Map<class_5321<class_1959>, class_5321<class_1959>>)((Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_38748, BWGBiomes.WHITE_MANGROVE_MARSHES);
        map.put(class_1972.field_9471, BWGBiomes.BAYOU);
    })), Map.of());
    public static final BWGTerraBlenderRegion REGION_3 = new BWGTerraBlenderRegion(BWGWorldGenConfig.INSTANCE.get().regionWeight(), TerraBlenderBiomeSelectors.OCEANS_TERRABLENDER, BWGBiomeSelectors.MIDDLE_BIOMES_3_BWG, TerraBlenderBiomeSelectors.MIDDLE_BIOMES_VARIANT_TERRABLENDER, BWGBiomeSelectors.PLATEAU_BIOMES_3_BWG, TerraBlenderBiomeSelectors.PLATEAU_BIOMES_VARIANT_TERRABLENDER, TerraBlenderBiomeSelectors.SHATTERED_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.BEACH_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.PEAK_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.PEAK_BIOMES_VARIANT_TERRABLENDER, TerraBlenderBiomeSelectors.SLOPE_BIOMES_TERRABLENDER, TerraBlenderBiomeSelectors.SLOPE_BIOMES_VARIANT_TERRABLENDER, (Map<class_5321<class_1959>, class_5321<class_1959>>)((Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_1972.field_38748, BWGBiomes.BAYOU);
        map.put(class_1972.field_9471, BWGBiomes.BAYOU);
    })), Map.of());
    private static int count = 0;
    private final Set<class_5321<class_1959>> bwgKeys = new ObjectOpenHashSet();
    private final Map<class_5321<class_1959>, class_5321<class_1959>> swapper;
    private final Map<class_5321<class_1959>, class_5321<class_1959>> globalSwapper;
    private final TerrablenderOverworldBiomeBuilder terrablenderOverworldBiomeBuilder;

    public BWGTerraBlenderRegion(int overworldWeight, Wrapped<List<List<class_5321<class_1959>>>> oceans, Wrapped<List<List<class_5321<class_1959>>>> middleBiomes, Wrapped<List<List<class_5321<class_1959>>>> middleBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> plateauBiomes, Wrapped<List<List<class_5321<class_1959>>>> plateauBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> shatteredBiomes, Wrapped<List<List<class_5321<class_1959>>>> beachBiomes, Wrapped<List<List<class_5321<class_1959>>>> peakBiomes, Wrapped<List<List<class_5321<class_1959>>>> peakBiomesVariant, Wrapped<List<List<class_5321<class_1959>>>> slopeBiomes, Wrapped<List<List<class_5321<class_1959>>>> slopeBiomesVariant, Map<class_5321<class_1959>, class_5321<class_1959>> swapper, Map<class_5321<class_1959>, class_5321<class_1959>> globalSwapper) {
        this(overworldWeight, BWGUtil._2DResourceKeyArrayTo2DList((List)oceans.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)middleBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)middleBiomesVariant.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)plateauBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)plateauBiomesVariant.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)shatteredBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)beachBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)peakBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)peakBiomesVariant.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)slopeBiomes.value()), BWGUtil._2DResourceKeyArrayTo2DList((List)slopeBiomesVariant.value()), swapper, globalSwapper);
    }

    public BWGTerraBlenderRegion(int overworldWeight, class_5321<class_1959>[][] oceans, class_5321<class_1959>[][] middleBiomes, class_5321<class_1959>[][] middleBiomesVariant, class_5321<class_1959>[][] plateauBiomes, class_5321<class_1959>[][] plateauBiomesVariant, class_5321<class_1959>[][] shatteredBiomes, class_5321<class_1959>[][] beachBiomes, class_5321<class_1959>[][] peakBiomes, class_5321<class_1959>[][] peakBiomesVariant, class_5321<class_1959>[][] slopeBiomes, class_5321<class_1959>[][] slopeBiomesVariant, Map<class_5321<class_1959>, class_5321<class_1959>> swapper, Map<class_5321<class_1959>, class_5321<class_1959>> globalSwapper) {
        super(BiomesWeveGone.id("region_" + count++), RegionType.OVERWORLD, overworldWeight);
        this.swapper = swapper;
        this.globalSwapper = globalSwapper;
        Predicate<class_5321<class_1959>> noVoidBiomes = biomeResourceKey -> biomeResourceKey != class_1972.field_9473;
        oceans = BWGRegionUtils.filter("oceans", this.getName(), count, oceans, noVoidBiomes, true);
        middleBiomes = BWGRegionUtils.filter("middle_biomes", this.getName(), count, middleBiomes, noVoidBiomes, true);
        middleBiomesVariant = BWGRegionUtils.filter("middle_biomes_variant", this.getName(), count, middleBiomesVariant, noVoidBiomes, false);
        plateauBiomes = BWGRegionUtils.filter("plateau_biomes", this.getName(), count, plateauBiomes, noVoidBiomes, true);
        plateauBiomesVariant = BWGRegionUtils.filter("plateau_biomes_variant", this.getName(), count, plateauBiomesVariant, noVoidBiomes, false);
        shatteredBiomes = BWGRegionUtils.filter("shattered_biomes", this.getName(), count, shatteredBiomes, noVoidBiomes, false);
        beachBiomes = BWGRegionUtils.filter("beach_biomes", this.getName(), count, beachBiomes, noVoidBiomes, true);
        peakBiomes = BWGRegionUtils.filter("peak_biomes", this.getName(), count, peakBiomes, noVoidBiomes, true);
        peakBiomesVariant = BWGRegionUtils.filter("peak_biomes_variant", this.getName(), count, peakBiomesVariant, noVoidBiomes, false);
        slopeBiomes = BWGRegionUtils.filter("slope_biomes", this.getName(), count, slopeBiomes, noVoidBiomes, true);
        slopeBiomesVariant = BWGRegionUtils.filter("slope_biomes_variant", this.getName(), count, slopeBiomesVariant, noVoidBiomes, false);
        this.terrablenderOverworldBiomeBuilder = new TerrablenderOverworldBiomeBuilder(oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes, peakBiomesVariant, slopeBiomes, slopeBiomesVariant);
        BWGRegionUtils.dumpArrays(biomeResourceKey -> {
            if (biomeResourceKey != null) {
                this.bwgKeys.add((class_5321<class_1959>)biomeResourceKey);
                if (swapper.containsValue(biomeResourceKey)) {
                    throw new IllegalArgumentException("Swapper cannot contain elements found in the temperature arrays.");
                }
            }
        }, oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes);
    }

    public void addBiomes(class_2378<class_1959> registry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        boolean sanityCheck;
        MutableInt totalPairs = new MutableInt();
        MutableInt bygMapperAccepted = new MutableInt(0);
        this.terrablenderOverworldBiomeBuilder.method_38185(parameterPointResourceKeyPair -> {
            class_6544.class_4762 parameterPoint = (class_6544.class_4762)parameterPointResourceKeyPair.getFirst();
            class_5321 biomeKey = (class_5321)parameterPointResourceKeyPair.getSecond();
            if (!registry.method_35842(biomeKey)) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the world registry!", biomeKey.method_29177()));
            }
            if (BWGWorldGenConfig.INSTANCE.get().enabledBiomes().getOrDefault(biomeKey, true).booleanValue()) {
                totalPairs.increment();
                boolean mapped = false;
                boolean alreadyMappedOutsideSwapper = false;
                if (this.bwgKeys.contains(biomeKey)) {
                    mapper.accept(new Pair((Object)parameterPoint, this.globalSwapper.getOrDefault(biomeKey, (class_5321<class_1959>)biomeKey)));
                    bygMapperAccepted.increment();
                    alreadyMappedOutsideSwapper = true;
                    mapped = true;
                }
                if (this.swapper.containsKey(biomeKey)) {
                    if (alreadyMappedOutsideSwapper) {
                        throw new UnsupportedOperationException(String.format("Attempting to assign a biome resource key in both the swapper and biome selectors. We're crashing your game to let you know that \"%s\" was put in the biome selectors but will always be swapped by \"%s\" due to the swapper. In region \"%s\".", biomeKey.method_29177(), this.swapper.get(biomeKey).method_29177(), this.getName().toString()));
                    }
                    class_5321 replacement = this.swapper.get(biomeKey);
                    class_5321 biomeResourceKey = BWGWorldGenConfig.INSTANCE.get().enabledBiomes().getOrDefault(replacement, true) != false ? replacement : Region.DEFERRED_PLACEHOLDER;
                    mapper.accept(new Pair((Object)parameterPoint, this.globalSwapper.getOrDefault(biomeResourceKey, (class_5321<class_1959>)biomeResourceKey)));
                    bygMapperAccepted.increment();
                    mapped = true;
                }
                if (!mapped) {
                    mapper.accept(new Pair((Object)parameterPoint, this.globalSwapper.getOrDefault(biomeKey, (class_5321<class_1959>)biomeKey)));
                    bygMapperAccepted.increment();
                }
            } else {
                mapper.accept(new Pair((Object)parameterPoint, (Object)Region.DEFERRED_PLACEHOLDER));
            }
        });
        int totalPairsValue = totalPairs.intValue();
        int mapperAcceptValue = bygMapperAccepted.intValue();
        boolean bl = sanityCheck = totalPairsValue != mapperAcceptValue;
        if (sanityCheck) {
            throw new UnsupportedOperationException(String.format("Not all biome parameter points were accepted for BWG Terrablender biome region: %s. %s/%s were accepted.", this.getName().toString(), totalPairsValue, mapperAcceptValue));
        }
    }

    public static void registerTerrablenderRegions() {
        Regions.register((Region)REGION_1);
        Regions.register((Region)REGION_2);
        Regions.register((Region)REGION_3);
    }
}

