/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_fabric.config.ConfigHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2418;
import net.minecraft.class_2420;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_5800;
import net.minecraft.class_5954;
import net.minecraft.class_7116;

public class Util {
    public static boolean isTreeLog(class_2248 block) {
        try {
            return (CompareBlockFunctions.isTreeLog((class_2248)block) || Util.isGiantMushroomStemBlock(block) || Util.isTreeRoot(block)) && !block.method_9518().getString().toLowerCase().contains("stripped");
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public static boolean isTreeLeaf(class_2248 block) {
        return CompareBlockFunctions.isTreeLeaf((class_2248)block, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(block);
    }

    public static boolean isSapling(class_2248 block) {
        return CompareBlockFunctions.isSapling((class_2248)block) || block instanceof class_2420 && ConfigHandler.enableHugeMushrooms || block instanceof class_5800;
    }

    public static boolean isNetherTreeLeaf(class_2248 block) {
        return block.equals(class_2246.field_10541) || block.equals(class_2246.field_22115) || block.equals(class_2246.field_22122);
    }

    public static boolean isTreeRoot(class_2248 block) {
        return block instanceof class_7116;
    }

    public static boolean isGiantMushroomStemBlock(class_2248 block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        try {
            class_3620 materialcolour = block.method_26403();
            return block instanceof class_2381 && materialcolour.equals(class_3620.field_15979);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isGiantMushroomLeafBlock(class_2248 block) {
        if (!ConfigHandler.enableHugeMushrooms) {
            return false;
        }
        try {
            class_3620 materialcolour = block.method_26403();
            return block instanceof class_2381 && (materialcolour.equals(class_3620.field_16020) || materialcolour.equals(class_3620.field_16000));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isMangroveRootOrLog(class_2248 block) {
        return block instanceof class_7116 || block.equals(class_2246.field_37545);
    }

    public static boolean isAzaleaLeaf(class_2248 block) {
        return block.equals(class_2246.field_28673) || block.equals(class_2246.field_28674);
    }

    public static boolean isPlantableBlock(class_2248 block) {
        return block.method_9564().method_26164(class_3481.field_29822) || CompareBlockFunctions.isDirtBlock((class_2248)block) || block instanceof class_2418 || block instanceof class_5954;
    }

    public static boolean areEqualLogTypes(class_2248 one, class_2248 two) {
        if (!Util.isTreeLog(one) || !Util.isTreeLog(two)) {
            return false;
        }
        if (Util.isMangroveRootOrLog(one) && Util.isMangroveRootOrLog(two)) {
            return true;
        }
        String oneIdentifier = one.method_9518().getString().split(" ")[0];
        String twoIdentifier = two.method_9518().getString().split(" ")[0];
        return oneIdentifier.equals(twoIdentifier);
    }

    public static Pair<Boolean, List<class_2338>> isConnectedToLogs(class_1937 level, class_2338 startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((class_1937)level, (class_2338)startpos, Arrays.asList(class_3620.field_15996), (int)6);
        for (class_2338 connectedpos : recursiveList) {
            class_2248 connectedblock = level.method_8320(connectedpos).method_26204();
            if (!Util.isTreeLog(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

