/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.processing;

import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import com.natamus.treeharvester_common_forge.data.Variables;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import oshi.util.tuples.Triplet;

public class TreeProcessing {
    public static int isTreeAndReturnLogAmount(Level level, BlockPos pos) {
        Variables.highestleaf.put(pos, 0);
        int leafcount = 8;
        int logCount = 0;
        int prevleafcount = -1;
        int prevlogCount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogCount != logCount); ++y) {
            prevleafcount = leafcount;
            prevlogCount = logCount;
            for (BlockPos npos : BlockPos.m_121976_((int)(pos.m_123341_() - 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() - 2), (int)(pos.m_123341_() + 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() + 2))) {
                BlockState nblockState = level.m_8055_(npos);
                Block nblock = nblockState.m_60734_();
                if (CompareBlockFunctions.isTreeLeaf((Block)nblock, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(nblock)) {
                    if (ConfigHandler.ignorePlayerMadeTrees && nblockState.m_61145_((Property)LeavesBlock.f_54419_).orElse(false).booleanValue()) {
                        return -1;
                    }
                    --leafcount;
                    if (npos.m_123342_() <= highesty) continue;
                    highesty = npos.m_123342_();
                    continue;
                }
                if (!Util.isTreeLog(nblock)) continue;
                ++logCount;
            }
        }
        Variables.highestleaf.put(pos.m_7949_(), highesty);
        if (leafcount < 0) {
            return logCount;
        }
        return -1;
    }

    public static List<BlockPos> getAllLogsToBreak(Level level, BlockPos pos, int logCount, Block logType) {
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (ConfigHandler.replaceSaplingOnTreeHarvest) {
            Block blockbelow = level.m_8055_(pos.m_7495_()).m_60734_();
            if (Util.isPlantableBlock(blockbelow)) {
                Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)pos.m_123342_(), (int)(pos.m_123343_() + 1)).iterator();
                while (it.hasNext()) {
                    BlockPos npos = (BlockPos)it.next();
                    Block block = level.m_8055_(npos).m_60734_();
                    if (!block.equals(logType) && !Util.areEqualLogTypes(logType, block)) continue;
                    bottomlogs.add(npos.m_7949_());
                }
            }
            Variables.saplingPositions.add((Triplet<Date, BlockPos, CopyOnWriteArrayList<BlockPos>>)new Triplet((Object)new Date(), (Object)pos.m_7949_(), bottomlogs));
        }
        return TreeProcessing.getLogsToBreak(level, pos, new ArrayList<BlockPos>(), logCount, logType);
    }

    private static List<BlockPos> getLogsToBreak(Level level, BlockPos pos, List<BlockPos> logsToBreak, int logCount, Block logType) {
        if (logsToBreak.size() > 256) {
            return logsToBreak;
        }
        ArrayList<BlockPos> checkAround = new ArrayList<BlockPos>();
        boolean isMangrove = Util.isMangroveRootOrLog(logType);
        int downY = pos.m_123342_() - 1;
        ArrayList<BlockPos> aroundLogs = new ArrayList<BlockPos>();
        for (BlockPos aL : BlockPos.m_121976_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 1))) {
            aroundLogs.add(aL.m_7949_());
        }
        for (BlockPos aroundLogPos : aroundLogs) {
            BlockState logstate;
            Block logblock;
            if (logsToBreak.contains(aroundLogPos) || !(logblock = (logstate = level.m_8055_(aroundLogPos)).m_60734_()).equals(logType) && !Util.areEqualLogTypes(logType, logblock)) continue;
            if (!isMangrove || aroundLogPos.m_123342_() != downY) {
                checkAround.add(aroundLogPos);
            }
            logsToBreak.add(aroundLogPos);
        }
        if (checkAround.size() == 0) {
            return logsToBreak;
        }
        for (BlockPos capos : checkAround) {
            for (BlockPos logpos : TreeProcessing.getLogsToBreak(level, capos, logsToBreak, logCount, logType)) {
                if (logsToBreak.contains(logpos)) continue;
                logsToBreak.add(logpos.m_7949_());
            }
        }
        BlockPos up = pos.m_6630_(2);
        return TreeProcessing.getLogsToBreak(level, up.m_7949_(), logsToBreak, logCount, logType);
    }
}

