/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.data;

import com.arcaryx.cobblemonintegrations.data.PokemonDrop;
import com.arcaryx.cobblemonintegrations.data.PokemonItemEvo;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class ClientCache {
    private static final Map<Pair<class_2960, String>, List<PokemonDrop>> pokemonDrops = new HashMap<Pair<class_2960, String>, List<PokemonDrop>>();
    private static final List<PokemonItemEvo> pokemonItemEvos = new ArrayList<PokemonItemEvo>();

    public static void setPokemonDrops(List<PokemonDrop> drops) {
        pokemonDrops.clear();
        for (PokemonDrop drop : drops) {
            Pair pokemon = Pair.of((Object)drop.getSpecies(), (Object)drop.getForm());
            if (!pokemonDrops.containsKey(pokemon)) {
                pokemonDrops.put((Pair<class_2960, String>)pokemon, new ArrayList());
            }
            pokemonDrops.get(pokemon).add(drop);
        }
    }

    public static List<PokemonDrop> getPokemonDrops(Species species, FormData form) {
        Pair pokemon = Pair.of((Object)species.getResourceIdentifier(), (Object)form.getName());
        if (pokemonDrops.containsKey(pokemon)) {
            return pokemonDrops.get(pokemon);
        }
        return new ArrayList<PokemonDrop>();
    }

    public static boolean sameDrops(Species species1, FormData form1, Species species2, FormData form2) {
        Pair pokemon1 = Pair.of((Object)species1.getResourceIdentifier(), (Object)form1.getName());
        Pair pokemon2 = Pair.of((Object)species2.getResourceIdentifier(), (Object)form2.getName());
        List drops1 = pokemonDrops.getOrDefault(pokemon1, new ArrayList());
        List drops2 = pokemonDrops.getOrDefault(pokemon2, new ArrayList());
        if (drops1.size() != drops2.size()) {
            return false;
        }
        Collections.sort(drops1);
        Collections.sort(drops2);
        return drops1.equals(drops2);
    }

    public static void setPokemonItemEvos(List<PokemonItemEvo> evos) {
        pokemonItemEvos.clear();
        pokemonItemEvos.addAll(evos);
    }

    public static List<PokemonItemEvo> getPokemonItemEvos() {
        return pokemonItemEvos;
    }
}

