/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.fabric;

import com.arcaryx.cobblemonintegrations.config.IConfig;
import com.arcaryx.cobblemonintegrations.config.ShowType;
import com.arcaryx.cobblemonintegrations.fabric.PairAdapter;
import com.arcaryx.cobblemonintegrations.waila.TooltipType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.tuple.Pair;

public class FabricConfig
implements IConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(new TypeToken<Pair<TooltipType, ShowType>>(){}.getType(), (Object)new PairAdapter()).create();
    private static final Path CONFIG_PATH = Paths.get("config", "cobblemonintegrations.json");
    private boolean hidePokemonLabel = false;
    private List<Pair<TooltipType, ShowType>> pokemonTooltips = TooltipType.pokemonDefaults;
    private boolean allowWaystoneTeleport = true;
    private boolean requireTeleportMove = true;
    private int waystoneMinTeleportLevel = 0;
    private boolean applyInPVP = false;
    private boolean allowLunarEventVariants = true;

    public static FabricConfig load() {
        FabricConfig config = new FabricConfig();
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            config.saveConfig();
        } else {
            config.loadConfig();
        }
        return config;
    }

    private void loadConfig() {
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            FabricConfig config = (FabricConfig)GSON.fromJson((Reader)reader, FabricConfig.class);
            this.hidePokemonLabel = config.hidePokemonLabel;
            this.pokemonTooltips = config.pokemonTooltips;
            this.allowWaystoneTeleport = config.allowWaystoneTeleport;
            this.requireTeleportMove = config.requireTeleportMove;
            this.waystoneMinTeleportLevel = config.waystoneMinTeleportLevel;
            this.applyInPVP = config.applyInPVP;
            this.allowLunarEventVariants = config.allowLunarEventVariants;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean hidePokemonLabel() {
        return this.hidePokemonLabel;
    }

    @Override
    public List<Pair<TooltipType, ShowType>> getPokemonTooltips() {
        return Collections.unmodifiableList(this.pokemonTooltips);
    }

    @Override
    public boolean allowWaystoneTeleport() {
        return this.allowWaystoneTeleport;
    }

    @Override
    public int waystoneMinTeleportLevel() {
        return this.waystoneMinTeleportLevel;
    }

    @Override
    public boolean requireTeleportMove() {
        return this.requireTeleportMove;
    }

    @Override
    public boolean applyInPVP() {
        return this.applyInPVP;
    }

    @Override
    public boolean allowLunarEventVariants() {
        return this.allowLunarEventVariants;
    }
}

