/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.jei;

import com.arcaryx.cobblemonintegrations.CobblemonIntegrations;
import com.arcaryx.cobblemonintegrations.data.ClientCache;
import com.arcaryx.cobblemonintegrations.data.PokemonItemEvo;
import com.arcaryx.cobblemonintegrations.jei.drops.DropsJeiCategory;
import com.arcaryx.cobblemonintegrations.jei.drops.DropsWrapper;
import com.arcaryx.cobblemonintegrations.jei.evoitems.EvoItemsJeiCategory;
import com.arcaryx.cobblemonintegrations.jei.evoitems.EvoItemsWrapper;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.PokemonModelRepository;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class CobblemonJeiPlugin
implements IModPlugin {
    public static final class_2960 DROPS = new class_2960("cobblemonintegrations", "cobblemon_drops");
    public static final RecipeType<DropsWrapper> DROPS_TYPE = new RecipeType(DROPS, DropsWrapper.class);
    public static final class_2960 EVO_ITEMS = new class_2960("cobblemonintegrations", "cobblemon_evoitems");
    public static final RecipeType<EvoItemsWrapper> EVO_ITEMS_TYPE = new RecipeType(EVO_ITEMS, EvoItemsWrapper.class);
    private static IJeiHelpers jeiHelpers;

    @NotNull
    public class_2960 getPluginUid() {
        return new class_2960("cobblemonintegrations");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<DropsWrapper> drops = new ArrayList<DropsWrapper>();
        for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
            class_2960 baseTexture = PokemonModelRepository.INSTANCE.getTexture(species.getResourceIdentifier(), Set.copyOf(species.getStandardForm().getAspects()), 0.0f);
            List<FormData> forms = species.getForms().isEmpty() ? List.of(species.getStandardForm()) : species.getForms();
            for (FormData form : forms) {
                boolean hasNewDrops;
                class_2960 formTexture = PokemonModelRepository.INSTANCE.getTexture(species.getResourceIdentifier(), Set.copyOf(form.getAspects()), 0.0f);
                boolean isSubstitute = formTexture.method_12832().contains("substitute");
                boolean isBaseForm = form.getName().equals(species.getStandardForm().getName());
                boolean hasNewTexture = baseTexture != formTexture;
                boolean bl = hasNewDrops = !ClientCache.sameDrops(species, form, species, species.getStandardForm());
                if (isSubstitute || !isBaseForm && !hasNewTexture && !hasNewDrops) continue;
                drops.add(new DropsWrapper(species, form));
            }
        }
        registration.addRecipes(DROPS_TYPE, drops);
        ArrayList<EvoItemsWrapper> evoItems = new ArrayList<EvoItemsWrapper>();
        for (PokemonItemEvo itemEvo : ClientCache.getPokemonItemEvos()) {
            Species speciesBase = PokemonSpecies.INSTANCE.getByIdentifier(itemEvo.getSpecies());
            if (itemEvo.getItemEvo().getResult().getSpecies() == null) {
                CobblemonIntegrations.LOGGER.warn("Null evolution result from species (1): " + String.valueOf(itemEvo.getSpecies()));
                continue;
            }
            Species speciesEvo = PokemonSpecies.INSTANCE.getByName(itemEvo.getItemEvo().getResult().getSpecies());
            if (speciesBase == null || speciesEvo == null) {
                CobblemonIntegrations.LOGGER.warn("Null evolution result from species (2): " + String.valueOf(itemEvo.getSpecies()));
                continue;
            }
            evoItems.add(new EvoItemsWrapper(itemEvo));
        }
        registration.addRecipes(EVO_ITEMS_TYPE, evoItems);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new DropsJeiCategory(), new EvoItemsJeiCategory()});
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }
}

