/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.jei.evoitems;

import com.arcaryx.cobblemonintegrations.data.PokemonItemEvo;
import com.arcaryx.cobblemonintegrations.enhancedcelestials.EnhancedCelestialsHandler;
import com.arcaryx.cobblemonintegrations.enhancedcelestials.LunarEventRequirement;
import com.arcaryx.cobblemonintegrations.util.TextUtils;
import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeIdentifierCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeTagCondition;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.requirement.EvolutionRequirement;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.PoseableEntityState;
import com.cobblemon.mod.common.client.render.models.blockbench.pokemon.PokemonFloatingState;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AnyRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AreaRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AttackDefenceRatioRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BattleCriticalHitsRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BiomeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BlocksTraveledRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.DamageTakenRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.DefeatRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.FriendshipRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.HeldItemRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.LevelRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoonPhaseRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoveSetRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoveTypeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PartyMemberRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PokemonPropertiesRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.RecoilRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.TimeRangeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.UseMoveRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.WeatherRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.WorldRequirement;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EvoItemsWrapper
implements IRecipeCategoryExtension,
IRecipeSlotRichTooltipCallback {
    private final PokemonItemEvo itemEvo;
    private final List<class_1792> validItems;
    private PokemonFloatingState state;
    private long last;
    private Map<Class<? extends EvolutionRequirement>, BiConsumer<EvolutionRequirement, ITooltipBuilder>> reqHandlers = new HashMap<Class<? extends EvolutionRequirement>, BiConsumer<EvolutionRequirement, ITooltipBuilder>>(){
        {
            this.put(AnyRequirement.class, EvoItemsWrapper::anyRequirement);
            this.put(AreaRequirement.class, EvoItemsWrapper::areaRequirement);
            this.put(AttackDefenceRatioRequirement.class, EvoItemsWrapper::attackDefenceRatioRequirement);
            this.put(BattleCriticalHitsRequirement.class, EvoItemsWrapper::battleCriticalHitsRequirement);
            this.put(BiomeRequirement.class, EvoItemsWrapper::biomeRequirement);
            this.put(BlocksTraveledRequirement.class, EvoItemsWrapper::blocksTraveledRequirement);
            this.put(DamageTakenRequirement.class, EvoItemsWrapper::damageTakenRequirement);
            this.put(DefeatRequirement.class, EvoItemsWrapper::defeatRequirement);
            this.put(FriendshipRequirement.class, EvoItemsWrapper::friendshipRequirement);
            this.put(HeldItemRequirement.class, EvoItemsWrapper::heldItemRequirement);
            this.put(LevelRequirement.class, EvoItemsWrapper::levelRequirement);
            this.put(MoonPhaseRequirement.class, EvoItemsWrapper::moonPhaseRequirement);
            this.put(MoveSetRequirement.class, EvoItemsWrapper::moveSetRequirement);
            this.put(MoveTypeRequirement.class, EvoItemsWrapper::moveTypeRequirement);
            this.put(PartyMemberRequirement.class, EvoItemsWrapper::partyMemberRequirement);
            this.put(PokemonPropertiesRequirement.class, EvoItemsWrapper::pokemonPropertiesRequirement);
            this.put(RecoilRequirement.class, EvoItemsWrapper::recoilRequirement);
            this.put(TimeRangeRequirement.class, EvoItemsWrapper::timeRangeRequirement);
            this.put(UseMoveRequirement.class, EvoItemsWrapper::useMoveRequirement);
            this.put(WeatherRequirement.class, EvoItemsWrapper::weatherRequirement);
            this.put(WorldRequirement.class, EvoItemsWrapper::worldRequirement);
            this.put(LunarEventRequirement.class, EvoItemsWrapper::lunarEventRequirement);
        }
    };

    public EvoItemsWrapper(PokemonItemEvo itemEvo) {
        this.itemEvo = itemEvo;
        this.validItems = class_7923.field_41178.method_10220().filter(x -> itemEvo.getItemEvo().getRequiredContext().getItem().fits(x, (class_2378)class_7923.field_41178)).toList();
    }

    public List<class_1792> getValidItems() {
        return this.validItems;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, class_332 graphics, double mouseX, double mouseY) {
        if (this.state == null) {
            this.state = new PokemonFloatingState();
        }
        long elapsed = System.currentTimeMillis() - this.last;
        this.last = System.currentTimeMillis();
        float partialTicks = class_3532.method_15363((float)((float)elapsed / 100.0f), (float)0.0f, (float)1.0f);
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        Species speciesBase = PokemonSpecies.INSTANCE.getByIdentifier(this.itemEvo.getSpecies());
        FormData formBase = speciesBase.getForms().stream().filter(x -> x.getName().equals(this.itemEvo.getForm())).findFirst().orElse(speciesBase.getStandardForm());
        class_5250 component = speciesBase.getTranslatedName();
        if (speciesBase.getStandardForm() != formBase && !formBase.getName().equalsIgnoreCase("base")) {
            component.method_10852((class_2561)class_2561.method_43470((String)String.format(" (%s)", formBase.getName())));
        }
        graphics.method_27535(class_310.method_1551().field_1772, (class_2561)component, 2, 1, Objects.requireNonNull(class_124.field_1068.method_532()).intValue());
        pose.method_22909();
        RenderablePokemon pokemonBase = new RenderablePokemon(speciesBase, new HashSet(formBase.getAspects()));
        HashSet<String> evoAspects = new HashSet<String>(formBase.getAspects());
        Species evoSpecies = PokemonSpecies.INSTANCE.getByName(this.itemEvo.getItemEvo().getResult().getSpecies());
        for (CustomPokemonProperty prop : this.itemEvo.getItemEvo().getResult().getCustomProperties()) {
            if (!(prop instanceof FlagSpeciesFeature)) continue;
            FlagSpeciesFeature sf = (FlagSpeciesFeature)prop;
            if (sf.getEnabled()) {
                evoAspects.add(sf.getName());
                continue;
            }
            evoAspects.remove(sf.getName());
        }
        evoAspects.addAll(this.itemEvo.getResult());
        RenderablePokemon pokemonEvo = new RenderablePokemon(evoSpecies, evoAspects);
        Matrix4f m1 = pose.method_23760().method_23761();
        float l1 = m1.m30();
        float t1 = m1.m31();
        float rotationY = -30.0f;
        pose.method_22903();
        graphics.method_44379((int)l1 + 2, (int)t1 + 13, (int)l1 + 61, (int)t1 + 92);
        pose.method_46416(31.0f, 13.0f, 0.0f);
        pose.method_22905(1.0f, 1.0f, 1.0f);
        pose.method_22903();
        PokemonGuiUtilsKt.drawProfilePokemon((RenderablePokemon)pokemonBase, (class_4587)pose, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, rotationY, 0.0f)), (PoseableEntityState)this.state, (float)partialTicks, (float)40.0f);
        pose.method_22909();
        graphics.method_44380();
        pose.method_22909();
        pose.method_22903();
        graphics.method_44379((int)l1 + 91, (int)t1 + 13, (int)l1 + 150, (int)t1 + 92);
        pose.method_46416(120.0f, 13.0f, 0.0f);
        pose.method_22905(1.0f, 1.0f, 1.0f);
        pose.method_22903();
        PokemonGuiUtilsKt.drawProfilePokemon((RenderablePokemon)pokemonEvo, (class_4587)pose, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, rotationY, 0.0f)), (PoseableEntityState)this.state, (float)partialTicks, (float)40.0f);
        pose.method_22909();
        graphics.method_44380();
        pose.method_22909();
    }

    private static void anyRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        AnyRequirement requirement = (AnyRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"(Any)"));
    }

    private static void areaRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        AreaRequirement requirement = (AreaRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Within %s".formatted(requirement.getBox().toString())));
    }

    private static void attackDefenceRatioRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        AttackDefenceRatioRequirement requirement = (AttackDefenceRatioRequirement)evoRequirement;
        switch (requirement.getRatio()) {
            case ATTACK_HIGHER: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Attack > Defence"));
                break;
            }
            case DEFENCE_HIGHER: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Attack < Defence"));
                break;
            }
            case EQUAL: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Attack = Defence"));
            }
        }
    }

    private static void battleCriticalHitsRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        BattleCriticalHitsRequirement requirement = (BattleCriticalHitsRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d Critical Hits".formatted(requirement.getAmount())));
    }

    private static void biomeRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        BiomeRequirement requirement = (BiomeRequirement)evoRequirement;
        if (requirement.getBiomeCondition() != null) {
            RegistryLikeCondition registryLikeCondition = requirement.getBiomeCondition();
            if (registryLikeCondition instanceof RegistryLikeIdentifierCondition) {
                RegistryLikeIdentifierCondition biomeId = (RegistryLikeIdentifierCondition)registryLikeCondition;
                tooltip.add((class_5348)class_2561.method_43470((String)"In biome %s".formatted(biomeId.getIdentifier())));
            } else {
                registryLikeCondition = requirement.getBiomeCondition();
                if (registryLikeCondition instanceof RegistryLikeTagCondition) {
                    RegistryLikeTagCondition biomeTag = (RegistryLikeTagCondition)registryLikeCondition;
                    tooltip.add((class_5348)class_2561.method_43470((String)"In biome #%s".formatted(biomeTag.getTag().comp_327())));
                }
            }
        } else if (requirement.getBiomeAnticondition() != null) {
            RegistryLikeCondition registryLikeCondition = requirement.getBiomeAnticondition();
            if (registryLikeCondition instanceof RegistryLikeIdentifierCondition) {
                RegistryLikeIdentifierCondition biomeId = (RegistryLikeIdentifierCondition)registryLikeCondition;
                tooltip.add((class_5348)class_2561.method_43470((String)"Not In biome %s".formatted(biomeId.getIdentifier())));
            } else {
                registryLikeCondition = requirement.getBiomeAnticondition();
                if (registryLikeCondition instanceof RegistryLikeTagCondition) {
                    RegistryLikeTagCondition biomeTag = (RegistryLikeTagCondition)registryLikeCondition;
                    tooltip.add((class_5348)class_2561.method_43470((String)"Not in biome #%s".formatted(biomeTag.getTag().comp_327())));
                }
            }
        }
    }

    private static void blocksTraveledRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        BlocksTraveledRequirement requirement = (BlocksTraveledRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d Blocks Traveled".formatted(requirement.getAmount())));
    }

    private static void damageTakenRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        DamageTakenRequirement requirement = (DamageTakenRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d Damage Taken".formatted(requirement.getAmount())));
    }

    private static void defeatRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        DefeatRequirement requirement = (DefeatRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d %s".formatted(requirement.getAmount(), TextUtils.basicPluralize("Defeat", requirement.getAmount()))));
    }

    private static void friendshipRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        FriendshipRequirement requirement = (FriendshipRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d Friendship".formatted(requirement.getAmount())));
    }

    private static void heldItemRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        HeldItemRequirement requirement = (HeldItemRequirement)evoRequirement;
        RegistryLikeCondition item = requirement.getItemCondition().getItem();
        if (item instanceof RegistryLikeIdentifierCondition) {
            RegistryLikeIdentifierCondition itemId = (RegistryLikeIdentifierCondition)item;
            tooltip.add((class_5348)class_2561.method_43470((String)"Holding %s".formatted(itemId.getIdentifier())));
        } else if (item instanceof RegistryLikeTagCondition) {
            RegistryLikeTagCondition itemTag = (RegistryLikeTagCondition)item;
            tooltip.add((class_5348)class_2561.method_43470((String)"Holding #%s".formatted(itemTag.getTag().comp_327())));
        }
    }

    private static void levelRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        LevelRequirement requirement = (LevelRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%sLevel%s".formatted(requirement.getMinLevel() == 1 ? "" : "%d \u2264 ".formatted(requirement.getMaxLevel()), requirement.getMaxLevel() == Integer.MAX_VALUE ? "" : " \u2264 %d".formatted(requirement.getMaxLevel()))));
    }

    private static void moonPhaseRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        MoonPhaseRequirement requirement = (MoonPhaseRequirement)evoRequirement;
        switch (requirement.getMoonPhase()) {
            case FULL_MOON: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Full Moon"));
                break;
            }
            case WANING_GIBBOUS: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Waning Gibbous"));
                break;
            }
            case THIRD_QUARTER: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Third Quarter"));
                break;
            }
            case WANING_CRESCENT: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Waning Crescent"));
                break;
            }
            case NEW_MOON: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: New Moon"));
                break;
            }
            case WAXING_CRESCENT: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Waxing Crescent"));
                break;
            }
            case FIRST_QUARTER: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: First Quarter"));
                break;
            }
            case WAXING_GIBBOUS: {
                tooltip.add((class_5348)class_2561.method_43470((String)"Moon Phase: Waxing Gibbous"));
            }
        }
    }

    private static void moveSetRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        MoveSetRequirement requirement = (MoveSetRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Move: ").method_10852((class_2561)requirement.getMove().getDisplayName()));
    }

    private static void moveTypeRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        MoveTypeRequirement requirement = (MoveTypeRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Move Type: ").method_10852((class_2561)requirement.getType().getDisplayName()));
    }

    private static void partyMemberRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        PartyMemberRequirement requirement = (PartyMemberRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Party Member: ").method_27693(requirement.getTarget().asString(", ")));
    }

    private static void pokemonPropertiesRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        PokemonPropertiesRequirement requirement = (PokemonPropertiesRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Properties: ").method_27693(requirement.getTarget().asString(", ")));
    }

    private static void recoilRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        RecoilRequirement requirement = (RecoilRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"%d Recoil Damage".formatted(requirement.getAmount())));
    }

    private static void timeRangeRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        TimeRangeRequirement requirement = (TimeRangeRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Specific Time Range"));
    }

    private static void useMoveRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        UseMoveRequirement requirement = (UseMoveRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Use ").method_10852((class_2561)requirement.getMove().getDisplayName()).method_27693(" %d %s".formatted(requirement.getAmount(), TextUtils.basicPluralize("time", requirement.getAmount()))));
    }

    private static void weatherRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        WeatherRequirement requirement = (WeatherRequirement)evoRequirement;
        if (Boolean.TRUE.equals(requirement.isRaining())) {
            tooltip.add((class_5348)class_2561.method_43470((String)"Raining"));
        } else if (Boolean.FALSE.equals(requirement.isRaining())) {
            tooltip.add((class_5348)class_2561.method_43470((String)"Not Raining"));
        }
        if (Boolean.TRUE.equals(requirement.isThundering())) {
            tooltip.add((class_5348)class_2561.method_43470((String)"Thundering"));
        } else if (Boolean.FALSE.equals(requirement.isThundering())) {
            tooltip.add((class_5348)class_2561.method_43470((String)"Not Thundering"));
        }
    }

    private static void worldRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        WorldRequirement requirement = (WorldRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Dimension: %s".formatted(requirement.getIdentifier())));
    }

    private static void lunarEventRequirement(EvolutionRequirement evoRequirement, ITooltipBuilder tooltip) {
        LunarEventRequirement requirement = (LunarEventRequirement)evoRequirement;
        tooltip.add((class_5348)class_2561.method_43470((String)"Lunar Event: ").method_10852(EnhancedCelestialsHandler.GetLunarEventName(requirement.lunarEvent, (class_1937)class_310.method_1551().field_1687)));
    }

    public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltipBuilder) {
        if (this.itemEvo.getItemEvo().getRequirements().isEmpty()) {
            tooltipBuilder.add((class_5348)class_2561.method_43470((String)"No additional requirements."));
            return;
        }
        tooltipBuilder.add((class_5348)class_2561.method_43470((String)(TextUtils.basicPluralize("Requirement", this.itemEvo.getItemEvo().getRequirements().size()) + ":")));
        for (EvolutionRequirement requirement : this.itemEvo.getItemEvo().getRequirements()) {
            BiConsumer<EvolutionRequirement, ITooltipBuilder> handler = this.reqHandlers.get(requirement.getClass());
            if (handler != null) {
                handler.accept(requirement, tooltipBuilder);
                continue;
            }
            tooltipBuilder.add((class_5348)class_2561.method_43470((String)"Unknown: %s".formatted(requirement.getClass().getSimpleName())));
        }
    }
}

