/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.net.messages;

import com.arcaryx.cobblemonintegrations.data.ClientCache;
import com.arcaryx.cobblemonintegrations.data.PokemonDrop;
import com.arcaryx.cobblemonintegrations.net.messages.AbstractMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SyncDropsMessage
extends AbstractMessage {
    public List<PokemonDrop> drops;

    public SyncDropsMessage(List<PokemonDrop> drops) {
        this.drops = drops;
    }

    public SyncDropsMessage(class_2540 buf) {
        super(buf);
        int size = buf.readInt();
        this.drops = new ArrayList<PokemonDrop>();
        for (int i = 0; i < size; ++i) {
            class_2960 species = buf.method_10810();
            String form = buf.method_19772();
            class_2960 item = buf.method_10810();
            float chance = buf.readFloat();
            int min = buf.readInt();
            int max = buf.readInt();
            this.drops.add(new PokemonDrop(species, form, item, chance, min, max));
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.drops.size());
        for (PokemonDrop drop : this.drops) {
            buf.method_10812(drop.getSpecies());
            buf.method_10814(drop.getForm());
            buf.method_10812(drop.getItem());
            buf.writeFloat(drop.getChance());
            buf.writeInt(drop.getRange().getFirst());
            buf.writeInt(drop.getRange().getLast());
        }
    }

    @Override
    public void handle(class_1657 player) {
        ClientCache.setPokemonDrops(this.drops);
    }
}

