/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.net.messages;

import com.arcaryx.cobblemonintegrations.data.ClientCache;
import com.arcaryx.cobblemonintegrations.data.PokemonItemEvo;
import com.arcaryx.cobblemonintegrations.net.messages.AbstractMessage;
import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeIdentifierCondition;
import com.cobblemon.mod.common.api.conditional.RegistryLikeTagCondition;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.evolution.variants.ItemInteractionEvolution;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SyncEvoItemsMessage
extends AbstractMessage {
    public List<PokemonItemEvo> itemEvos;

    public SyncEvoItemsMessage(List<PokemonItemEvo> itemEvos) {
        this.itemEvos = itemEvos;
    }

    public SyncEvoItemsMessage(class_2540 buf) {
        super(buf);
        int size = buf.readInt();
        this.itemEvos = new ArrayList<PokemonItemEvo>();
        for (int i = 0; i < size; ++i) {
            class_2960 species = buf.method_10810();
            String form = buf.method_19772();
            String itemEvo = buf.method_19772();
            int aspectsCount = buf.readInt();
            ArrayList<String> aspects = new ArrayList<String>();
            for (int j = 0; j < aspectsCount; ++j) {
                aspects.add(buf.method_19772());
            }
            this.itemEvos.add(new PokemonItemEvo(species, form, itemEvo, aspects));
        }
    }

    @Override
    public void encode(class_2540 buf) {
        Gson gson = PokemonSpecies.INSTANCE.getGson().newBuilder().registerTypeHierarchyAdapter(RegistryLikeCondition.class, new SerializerFix()).create();
        buf.writeInt(this.itemEvos.size());
        for (PokemonItemEvo itemEvo : this.itemEvos) {
            buf.method_10812(itemEvo.getSpecies());
            buf.method_10814(itemEvo.getForm());
            buf.method_10814(gson.toJson((Object)itemEvo.getItemEvo(), ItemInteractionEvolution.class));
            buf.writeInt(itemEvo.getResult().size());
            for (String aspect : itemEvo.getResult()) {
                buf.method_10814(aspect);
            }
        }
    }

    @Override
    public void handle(class_1657 player) {
        ClientCache.setPokemonItemEvos(this.itemEvos);
    }

    public static class SerializerFix<B>
    implements JsonSerializer<RegistryLikeCondition<B>> {
        public JsonElement serialize(RegistryLikeCondition<B> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof RegistryLikeIdentifierCondition) {
                RegistryLikeIdentifierCondition src1 = (RegistryLikeIdentifierCondition)src;
                return new JsonPrimitive(src1.getIdentifier().toString());
            }
            return new JsonPrimitive("#" + String.valueOf(((RegistryLikeTagCondition)src).getTag().comp_327()));
        }
    }
}

