/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.util;

import com.arcaryx.cobblemonintegrations.CobblemonIntegrations;
import com.arcaryx.cobblemonintegrations.data.PokemonDrop;
import com.arcaryx.cobblemonintegrations.data.PokemonItemEvo;
import com.arcaryx.cobblemonintegrations.enhancedcelestials.LunarEventRequirement;
import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import com.cobblemon.mod.common.pokemon.evolution.variants.ItemInteractionEvolution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ranges.IntRange;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class PokemonUtils {
    public static class_2487 saveStatMapToCompoundTag(Map<Stat, Integer> statMap) {
        HashMap<class_2960, Integer> resourceLocationMap = new HashMap<class_2960, Integer>();
        for (Map.Entry<Stat, Integer> entry : statMap.entrySet()) {
            resourceLocationMap.put(entry.getKey().getIdentifier(), entry.getValue());
        }
        class_2487 compoundTag = new class_2487();
        for (Map.Entry entry : resourceLocationMap.entrySet()) {
            compoundTag.method_10569(((class_2960)entry.getKey()).toString(), ((Integer)entry.getValue()).intValue());
        }
        return compoundTag;
    }

    public static Map<Stat, Integer> loadStatMapFromCompoundTag(class_2487 compoundTag) {
        HashMap<class_2960, Integer> resourceLocationMap = new HashMap<class_2960, Integer>();
        for (String key : compoundTag.method_10541()) {
            class_2960 resourceLocation = new class_2960(key);
            int value = compoundTag.method_10550(key);
            resourceLocationMap.put(resourceLocation, value);
        }
        HashMap<Stat, Integer> statMap = new HashMap<Stat, Integer>();
        Arrays.stream(Stats.values()).forEach(stat -> {
            class_2960 identifier = stat.getIdentifier();
            if (resourceLocationMap.containsKey(identifier)) {
                statMap.put((Stat)stat, (Integer)resourceLocationMap.get(identifier));
            }
        });
        return statMap;
    }

    public static boolean hasHiddenAbility(Pokemon pokemon) {
        AbilityPool abilities = pokemon.getForm().getAbilities();
        for (PotentialAbility ability : abilities) {
            HiddenAbility hiddenAbility;
            if (!(ability instanceof HiddenAbility) || (hiddenAbility = (HiddenAbility)ability).getTemplate() != pokemon.getAbility().getTemplate()) continue;
            return true;
        }
        return false;
    }

    public static Gender getGenderFromShowdownName(String showdownName) {
        for (Gender gender : Gender.values()) {
            if (!gender.getShowdownName().equals(showdownName)) continue;
            return gender;
        }
        throw new IllegalArgumentException("Invalid showdownName: " + showdownName);
    }

    public static List<PokemonItemEvo> computeItemEvos() {
        ArrayList<PokemonItemEvo> itemEvos = new ArrayList<PokemonItemEvo>();
        for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
            if (!species.getImplemented()) continue;
            List<FormData> forms = species.getForms().isEmpty() ? List.of(species.getStandardForm()) : species.getForms();
            for (FormData form : forms) {
                for (Evolution evolution : form.getEvolutions()) {
                    ItemInteractionEvolution itemEvolution;
                    Set reqs;
                    if (!(evolution instanceof ItemInteractionEvolution) || (reqs = (itemEvolution = (ItemInteractionEvolution)evolution).getRequirements()).stream().anyMatch(x -> x instanceof LunarEventRequirement && (!CobblemonIntegrations.CONFIG.isModLoaded("enhancedcelestials") || !CobblemonIntegrations.CONFIG.allowLunarEventVariants()))) continue;
                    PokemonProperties result = itemEvolution.getResult();
                    result.updateAspects();
                    ItemInteractionEvolution stripped = new ItemInteractionEvolution(itemEvolution.getId(), itemEvolution.getResult(), itemEvolution.getRequiredContext(), itemEvolution.getOptional(), itemEvolution.getConsumeHeldItem(), reqs, itemEvolution.getLearnableMoves());
                    itemEvos.add(new PokemonItemEvo(species.getResourceIdentifier(), form.getName(), stripped, result.getAspects().stream().toList()));
                }
            }
        }
        return itemEvos;
    }

    private static void addDrops(List<PokemonDrop> lootDrops, Species species, FormData form) {
        List formDrops = form.getDrops().getEntries();
        for (DropEntry drop : formDrops) {
            if (!(drop instanceof ItemDropEntry)) continue;
            ItemDropEntry itemDrop = (ItemDropEntry)drop;
            IntRange range = itemDrop.getQuantityRange();
            if (range == null) {
                range = new IntRange(itemDrop.getQuantity(), itemDrop.getQuantity());
            }
            float chance = itemDrop.getPercentage() / 100.0f;
            lootDrops.add(new PokemonDrop(species.getResourceIdentifier(), form.getName(), itemDrop.getItem(), chance, range.getFirst(), range.getLast()));
        }
    }

    public static List<PokemonDrop> computeLootDrops() {
        ArrayList<PokemonDrop> lootDrops = new ArrayList<PokemonDrop>();
        Collection pokemonSpecies = PokemonSpecies.INSTANCE.getSpecies();
        for (Species species : pokemonSpecies) {
            List forms = species.getForms();
            if (forms.isEmpty()) {
                FormData form = species.getStandardForm();
                PokemonUtils.addDrops(lootDrops, species, form);
                continue;
            }
            for (FormData form : species.getForms()) {
                PokemonUtils.addDrops(lootDrops, species, form);
            }
        }
        return lootDrops;
    }
}

