/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.waila.jade;

import com.arcaryx.cobblemonintegrations.CobblemonIntegrations;
import com.arcaryx.cobblemonintegrations.config.ShowType;
import com.arcaryx.cobblemonintegrations.util.ClientUtils;
import com.arcaryx.cobblemonintegrations.util.PokemonUtils;
import com.arcaryx.cobblemonintegrations.util.TextUtils;
import com.arcaryx.cobblemonintegrations.waila.TooltipType;
import com.arcaryx.cobblemonintegrations.waila.jade.CobblemonJadePlugin;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.settings.ServerSettings;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.PokemonStats;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Pair;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.HealthElement;

public enum PokemonProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    public static final String TAG_GENDER = "ci_gender";
    public static final String TAG_TRAINER_UUID = "ci_trainer_uuid";
    public static final String TAG_TRAINER_NAME = "ci_trainer_name";
    public static final String TAG_NATURE_NAME = "ci_nature_name";
    public static final String TAG_MINTED_NATURE_NAME = "ci_minted_nature_name";
    public static final String TAG_FRIENDSHIP = "ci_friendship";
    public static final String TAG_ABILITY_NAME = "ci_ability_name";
    public static final String TAG_ABILITY_HIDDEN = "ci_ability_hidden";
    public static final String TAG_EV_YIELD = "ci_yield";
    public static final String TAG_IVS = "ci_ivs";
    public static final String TAG_EVS = "ci_evs";
    public static final String TAG_EGG_GROUPS = "ci_egg_groups";
    public static final String TAG_EGG_GROUP_COUNT = "ci_egg_group_count";

    public void appendServerData(class_2487 data, EntityAccessor entityAccessor) {
        class_1297 class_12972 = entityAccessor.getEntity();
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
        Pokemon pokemon = pokemonEntity.getPokemon();
        List<Pair<TooltipType, ShowType>> tooltips = CobblemonIntegrations.CONFIG.getPokemonTooltips();
        if (this.configContains(tooltips, TooltipType.TITLE_GENDER) || this.configContains(tooltips, TooltipType.GENDER)) {
            data.method_10582(TAG_GENDER, pokemon.getGender().getShowdownName());
        }
        if (this.configContains(tooltips, TooltipType.TRAINER) && pokemon.getOwnerUUID() != null) {
            data.method_25927(TAG_TRAINER_UUID, pokemon.getOwnerUUID());
            data.method_10582(TAG_TRAINER_NAME, CobblemonIntegrations.JADE_UTIL.getPlayerUsernameServer(pokemon.getOwnerUUID()));
        }
        if (this.configContains(tooltips, TooltipType.FRIENDSHIP) && !pokemon.isWild()) {
            data.method_10569(TAG_FRIENDSHIP, pokemon.getFriendship());
        }
        if (this.configContains(tooltips, TooltipType.REWARD_EVS)) {
            data.method_10566(TAG_EV_YIELD, (class_2520)PokemonUtils.saveStatMapToCompoundTag(pokemon.getForm().getEvYield()));
        }
        if (this.configContains(tooltips, TooltipType.NATURE)) {
            data.method_10582(TAG_NATURE_NAME, pokemon.getNature().getDisplayName());
            if (pokemon.getMintedNature() != null) {
                data.method_10582(TAG_MINTED_NATURE_NAME, pokemon.getMintedNature().getDisplayName());
            }
        }
        if (this.configContains(tooltips, TooltipType.ABILITY)) {
            data.method_10582(TAG_ABILITY_NAME, pokemon.getAbility().getDisplayName());
            data.method_10556(TAG_ABILITY_HIDDEN, PokemonUtils.hasHiddenAbility(pokemon));
        }
        if (this.configContains(tooltips, TooltipType.IVS)) {
            data.method_10566(TAG_IVS, (class_2520)pokemon.getIvs().saveToNBT(new class_2487()));
        }
        if (this.configContains(tooltips, TooltipType.EVS)) {
            data.method_10566(TAG_EVS, (class_2520)pokemon.getEvs().saveToNBT(new class_2487()));
        }
        if (this.configContains(tooltips, TooltipType.EGG_GROUPS)) {
            Set eggGroups = pokemon.getForm().getEggGroups();
            data.method_10569(TAG_EGG_GROUP_COUNT, eggGroups.size());
            data.method_10582(TAG_EGG_GROUPS, String.join((CharSequence)", ", eggGroups.stream().map(EggGroup::getShowdownID$common).toList()));
        }
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        class_1297 class_12972 = accessor.getEntity();
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
        Pokemon pokemon = pokemonEntity.getPokemon();
        pokemon.setAspects(pokemonEntity.getAspects());
        pokemon.updateForm();
        tooltip.clear();
        List<Pair<TooltipType, ShowType>> tooltips = CobblemonIntegrations.CONFIG.getPokemonTooltips();
        for (Pair<TooltipType, ShowType> type : tooltips) {
            if (type.getRight() == ShowType.SHOW) {
                this.addTooltip((TooltipType)((Object)type.getLeft()), tooltip, accessor, pokemonEntity, pokemon, tooltips);
                continue;
            }
            if (type.getRight() == ShowType.SNEAK && accessor.getPlayer().method_18276()) {
                this.addTooltip((TooltipType)((Object)type.getLeft()), tooltip, accessor, pokemonEntity, pokemon, tooltips);
                continue;
            }
            if (type.getRight() != ShowType.NO_SNEAK || accessor.getPlayer().method_18276()) continue;
            this.addTooltip((TooltipType)((Object)type.getLeft()), tooltip, accessor, pokemonEntity, pokemon, tooltips);
        }
    }

    public class_2960 getUid() {
        return CobblemonJadePlugin.POKEMON_ENTITY;
    }

    private boolean configContains(List<Pair<TooltipType, ShowType>> tooltips, TooltipType type) {
        return tooltips.stream().anyMatch(x -> x.getLeft() == type && x.getRight() != ShowType.HIDE);
    }

    private void addTooltip(TooltipType tooltipType, ITooltip tooltip, EntityAccessor accessor, PokemonEntity pokemonEntity, Pokemon pokemon, List<Pair<TooltipType, ShowType>> tooltips) {
        class_2487 data = accessor.getServerData();
        switch (tooltipType) {
            case TITLE: {
                class_5250 component = pokemonEntity.method_5477().method_27661();
                if (ServerSettings.INSTANCE.getDisplayEntityLevelLabel() && pokemonEntity.labelLevel() > 0) {
                    class_5250 levelLabel = LocalizationUtilsKt.lang((String)"label.lv", (Object[])new Object[]{pokemonEntity.labelLevel()});
                    component.method_27693(" ").method_10852((class_2561)levelLabel);
                }
                tooltip.add((class_2561)component.method_27692(class_124.field_1068));
                break;
            }
            case TITLE_GENDER: {
                Gender gender = data.method_10545(TAG_GENDER) ? PokemonUtils.getGenderFromShowdownName(data.method_10558(TAG_GENDER)) : Gender.GENDERLESS;
                class_5250 component = pokemonEntity.method_5477().method_27661();
                if (gender != Gender.GENDERLESS) {
                    String prefix = gender == Gender.MALE ? String.valueOf(class_124.field_1078) + "\u2642 " : String.valueOf(class_124.field_1076) + "\u2640 ";
                    component = class_2561.method_43470((String)prefix).method_10852((class_2561)component);
                }
                if (ServerSettings.INSTANCE.getDisplayEntityLevelLabel() && pokemonEntity.labelLevel() > 0) {
                    class_5250 levelLabel = LocalizationUtilsKt.lang((String)"label.lv", (Object[])new Object[]{pokemonEntity.labelLevel()});
                    component.method_27693(" ").method_10852((class_2561)levelLabel);
                }
                tooltip.add((class_2561)component.method_27692(class_124.field_1068));
                break;
            }
            case SPECIES: {
                class_5250 component = class_2561.method_43470((String)"Species: ").method_10852((class_2561)pokemon.getDisplayName());
                if (pokemon.getSpecies().getStandardForm() != pokemon.getForm()) {
                    component.method_10852((class_2561)class_2561.method_43470((String)String.format(" (%s)", pokemon.getForm().getName())));
                }
                tooltip.add((class_2561)component);
                break;
            }
            case LEVEL: {
                class_5250 component = class_2561.method_43470((String)("Level: " + pokemon.getLevel()));
                tooltip.add((class_2561)component);
                break;
            }
            case GENDER: {
                Gender gender;
                Gender gender2 = gender = data.method_10545(TAG_GENDER) ? PokemonUtils.getGenderFromShowdownName(data.method_10558(TAG_GENDER)) : Gender.GENDERLESS;
                if (gender == Gender.GENDERLESS) break;
                String suffix = gender == Gender.MALE ? String.valueOf(class_124.field_1078) + "\u2642 " : String.valueOf(class_124.field_1076) + "\u2640 ";
                tooltip.add((class_2561)class_2561.method_43470((String)"Gender: ").method_27693(suffix));
                break;
            }
            case HEALTH: {
                tooltip.add((IElement)new HealthElement(pokemonEntity.method_6063(), pokemonEntity.method_6032()));
                break;
            }
            case TRAINER: {
                if (!data.method_10545(TAG_TRAINER_NAME)) break;
                String username = data.method_10558(TAG_TRAINER_NAME);
                if (username.isEmpty()) {
                    username = CobblemonIntegrations.JADE_UTIL.getPlayerUsernameClient(data.method_25926(TAG_TRAINER_UUID));
                }
                tooltip.add((class_2561)class_2561.method_43470((String)"Trainer: ").method_27693(username == null ? "???" : username));
                break;
            }
            case NICKNAME: {
                if (pokemon.getNickname() == null || pokemon.getNickname().getString().isEmpty()) break;
                tooltip.add((class_2561)class_2561.method_43470((String)"Nickname: ").method_10852((class_2561)pokemon.getNickname()));
                break;
            }
            case FRIENDSHIP: {
                if (!data.method_10545(TAG_FRIENDSHIP)) break;
                double percentage = (float)data.method_10550(TAG_FRIENDSHIP) / 255.0f * 100.0f;
                int flooredPercentage = (int)Math.floor(percentage);
                tooltip.add((class_2561)class_2561.method_43470((String)String.format("Friendship: %d (%d%%)", data.method_10550(TAG_FRIENDSHIP), flooredPercentage)));
                break;
            }
            case TYPES: {
                List types = StreamSupport.stream(pokemon.getForm().getTypes().spliterator(), false).toList();
                class_5250 typesComponent = class_2561.method_43470((String)(TextUtils.basicPluralize("Type", types.size()) + ": "));
                for (ElementalType type : types) {
                    if (typesComponent.method_10855().size() > 0) {
                        typesComponent.method_10852((class_2561)class_2561.method_43470((String)", "));
                    }
                    typesComponent.method_10852((class_2561)type.getDisplayName().method_27696(class_2583.field_24360.method_36139(type.getHue())));
                }
                tooltip.add((class_2561)typesComponent);
                break;
            }
            case REWARD_EVS: {
                if (!data.method_10545(TAG_EV_YIELD)) break;
                class_2561 yield = TextUtils.formatEvYield(PokemonUtils.loadStatMapFromCompoundTag(data.method_10562(TAG_EV_YIELD)));
                tooltip.add((class_2561)class_2561.method_43470((String)"EV Yield: ").method_10852(yield));
                break;
            }
            case NATURE: {
                if (!data.method_10545(TAG_NATURE_NAME)) break;
                if (!data.method_10545(TAG_MINTED_NATURE_NAME)) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"Nature: ").method_10852((class_2561)class_2561.method_43471((String)data.method_10558(TAG_NATURE_NAME))));
                    break;
                }
                tooltip.add((class_2561)class_2561.method_43470((String)"Nature: ").method_10852((class_2561)class_2561.method_43471((String)data.method_10558(TAG_MINTED_NATURE_NAME))).method_10852((class_2561)class_2561.method_43470((String)" (Minted)")));
                break;
            }
            case ABILITY: {
                if (!data.method_10545(TAG_ABILITY_HIDDEN)) break;
                class_5250 abilityComponent = class_2561.method_43470((String)"Ability: ").method_10852((class_2561)class_2561.method_43471((String)data.method_10558(TAG_ABILITY_NAME)));
                if (data.method_10545(TAG_ABILITY_HIDDEN) && data.method_10577(TAG_ABILITY_HIDDEN)) {
                    abilityComponent.method_10852((class_2561)class_2561.method_43470((String)" (Hidden)"));
                }
                tooltip.add((class_2561)abilityComponent);
                break;
            }
            case IVS: {
                if (!data.method_10545(TAG_IVS)) break;
                PokemonStats ivs = pokemon.getIvs().loadFromNBT(data.method_10562(TAG_IVS));
                tooltip.add((class_2561)class_2561.method_43470((String)("IVs: " + TextUtils.formatStats(ivs, 186.0))));
                break;
            }
            case EVS: {
                if (!data.method_10545(TAG_EVS)) break;
                PokemonStats evs = pokemon.getEvs().loadFromNBT(data.method_10562(TAG_EVS));
                tooltip.add((class_2561)class_2561.method_43470((String)("EVs: " + TextUtils.formatStats(evs, 510.0))));
                break;
            }
            case DEX_ENTRY: {
                if (pokemon.getForm().getPokedex().size() <= 0) break;
                String dex = pokemon.getForm().getPokedex().stream().findFirst().orElse("");
                List<String> dexLines = TextUtils.wrapString("Dex Entry: " + class_1074.method_4662((String)dex, (Object[])new Object[0]), 32);
                for (String line : dexLines) {
                    tooltip.add((class_2561)class_2561.method_43470((String)line));
                }
                break;
            }
            case SNEAK_HINT: {
                tooltip.add((class_2561)class_2561.method_43470((String)"<sneak for additional info>").method_27692(class_124.field_1063));
                break;
            }
            case BATTLE_HINT: {
                if (pokemonEntity.method_6171((class_1309)accessor.getPlayer())) break;
                class_5250 component = ClientUtils.CreateBattleHint();
                tooltip.add((class_2561)component.method_27692(class_124.field_1063));
                break;
            }
            case EGG_GROUPS: {
                int eggGroupCount = data.method_10550(TAG_EGG_GROUP_COUNT);
                String eggGroups = data.method_10558(TAG_EGG_GROUPS);
                String eggGroupText = TextUtils.basicPluralize("Egg Group", eggGroupCount) + ": " + eggGroups;
                List<String> eggGroupLines = TextUtils.wrapString(eggGroupText, 32);
                for (String line : eggGroupLines) {
                    tooltip.add((class_2561)class_2561.method_43470((String)line));
                }
                break;
            }
        }
    }
}

