/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.gegy.roles.SimpleRole;
import dev.gegy.roles.api.PlayerRolesApi;
import dev.gegy.roles.api.Role;
import dev.gegy.roles.config.PlayerRolesConfig;
import dev.gegy.roles.override.command.CommandOverride;
import dev.gegy.roles.store.PlayerRoleManager;
import dev.gegy.roles.store.PlayerRoleSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class RoleCommand {
    public static final DynamicCommandExceptionType ROLE_NOT_FOUND = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"Role with name '%s' was not found!", (Object[])new Object[]{arg}));
    public static final SimpleCommandExceptionType ROLE_POWER_TOO_LOW = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You do not have sufficient power to manage this role"));
    public static final SimpleCommandExceptionType TOO_MANY_SELECTED = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Too many players selected!"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"role").requires(s -> s.method_9259(4))).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"role", (ArgumentType)StringArgumentType.word()).suggests(RoleCommand.roleSuggestions()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Collection targets = class_2191.method_9330((CommandContext)ctx, (String)"targets");
            String roleName = StringArgumentType.getString((CommandContext)ctx, (String)"role");
            return RoleCommand.updateRoles(source, targets, roleName, PlayerRoleSet::add, "'%s' assigned to %s players");
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"role", (ArgumentType)StringArgumentType.word()).suggests(RoleCommand.roleSuggestions()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Collection targets = class_2191.method_9330((CommandContext)ctx, (String)"targets");
            String roleName = StringArgumentType.getString((CommandContext)ctx, (String)"role");
            return RoleCommand.updateRoles(source, targets, roleName, PlayerRoleSet::remove, "'%s' removed from %s players");
        }))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Collection gameProfiles = class_2191.method_9330((CommandContext)ctx, (String)"target");
            if (gameProfiles.size() != 1) {
                throw TOO_MANY_SELECTED.create();
            }
            return RoleCommand.listRoles(source, (GameProfile)gameProfiles.iterator().next());
        })))).then(class_2170.method_9247((String)"reload").executes(ctx -> RoleCommand.reloadRoles((class_2168)ctx.getSource()))));
    }

    private static int updateRoles(class_2168 source, Collection<GameProfile> players, String roleName, BiPredicate<PlayerRoleSet, SimpleRole> apply, String success) throws CommandSyntaxException {
        SimpleRole role = RoleCommand.getRole(roleName);
        RoleCommand.requireHasPower(source, role);
        PlayerRoleManager roleManager = PlayerRoleManager.get();
        MinecraftServer server = source.method_9211();
        int count = 0;
        for (GameProfile player : players) {
            boolean applied = roleManager.updateRoles(server, player.getId(), roles -> apply.test((PlayerRoleSet)roles, role));
            if (!applied) continue;
            ++count;
        }
        int finalCount = count;
        source.method_9226(() -> class_2561.method_43469((String)success, (Object[])new Object[]{roleName, finalCount}), true);
        return 1;
    }

    private static int listRoles(class_2168 source, GameProfile player) {
        PlayerRoleManager roleManager = PlayerRoleManager.get();
        MinecraftServer server = source.method_9211();
        List<Role> roles = roleManager.peekRoles(server, player.getId()).stream().toList();
        source.method_9226(() -> {
            class_2561 rolesComponent = class_2564.method_10884((Collection)roles, role -> class_2561.method_43470((String)role.getId()).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
            return class_2561.method_43469((String)"Found %s roles on player: %s", (Object[])new Object[]{roles.size(), rolesComponent});
        }, false);
        return 1;
    }

    private static int reloadRoles(class_2168 source) {
        MinecraftServer server = source.method_9211();
        server.execute(() -> {
            List<String> errors = PlayerRolesConfig.setup();
            PlayerRoleManager roleManager = PlayerRoleManager.get();
            roleManager.onRoleReload(server, PlayerRolesConfig.get());
            if (errors.isEmpty()) {
                source.method_9226(() -> class_2561.method_43470((String)"Role configuration successfully reloaded"), false);
            } else {
                class_5250 errorFeedback = class_2561.method_43470((String)"Failed to reload roles configuration!");
                for (String error : errors) {
                    errorFeedback = errorFeedback.method_27693("\n - " + error);
                }
                source.method_9213((class_2561)errorFeedback);
            }
        });
        return 1;
    }

    private static void requireHasPower(class_2168 source, SimpleRole role) throws CommandSyntaxException {
        if (RoleCommand.hasAdminPower(source)) {
            return;
        }
        Role highestRole = RoleCommand.getHighestRole(source);
        if (highestRole == null || role.compareTo(highestRole) <= 0) {
            throw ROLE_POWER_TOO_LOW.create();
        }
    }

    private static SimpleRole getRole(String roleName) throws CommandSyntaxException {
        SimpleRole role = PlayerRolesConfig.get().get(roleName);
        if (role == null) {
            throw ROLE_NOT_FOUND.create((Object)roleName);
        }
        return role;
    }

    private static SuggestionProvider<class_2168> roleSuggestions() {
        return (ctx, builder) -> {
            class_2168 source = (class_2168)ctx.getSource();
            boolean admin = RoleCommand.hasAdminPower(source);
            Role highestRole = RoleCommand.getHighestRole(source);
            Comparator comparator = Comparator.nullsLast(Comparator.naturalOrder());
            return class_2172.method_9264(PlayerRolesConfig.get().stream().filter(role -> admin || comparator.compare(role, highestRole) > 0).map(Role::getId), (SuggestionsBuilder)builder);
        };
    }

    @Nullable
    private static Role getHighestRole(class_2168 source) {
        return PlayerRolesApi.lookup().bySource(source).stream().min(Comparator.naturalOrder()).orElse(null);
    }

    private static boolean hasAdminPower(class_2168 source) {
        return source.method_9228() == null || CommandOverride.doesBypassPermissions(source);
    }
}

