/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.config;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import dev.gegy.roles.config.ConfigErrorConsumer;
import dev.gegy.roles.config.RoleConfig;
import dev.gegy.roles.override.RoleOverrideMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoleConfigMap
implements Iterable<Pair<String, RoleConfig>> {
    private final Map<String, RoleConfig> roles;
    private final List<String> roleOrder;

    RoleConfigMap(Map<String, RoleConfig> roles, List<String> roleOrder) {
        this.roles = roles;
        this.roleOrder = roleOrder;
    }

    public static <T> RoleConfigMap parse(Dynamic<T> root, ConfigErrorConsumer error) {
        List roleEntries = root.asMapOpt().result().orElse(Stream.empty()).collect(Collectors.toList());
        Builder roleBuilder = new Builder();
        for (Pair entry : roleEntries) {
            String name = ((Dynamic)entry.getFirst()).asString("everyone").toLowerCase(Locale.ROOT);
            Dynamic roleRoot = (Dynamic)entry.getSecond();
            DataResult roleConfigResult = RoleConfig.CODEC.parse(roleRoot);
            if (roleConfigResult.error().isPresent()) {
                error.report("Failed to parse role config for '" + name + "'", (DataResult.PartialResult)roleConfigResult.error().get());
                continue;
            }
            RoleConfig role = (RoleConfig)roleConfigResult.result().get();
            roleBuilder.add(name, role);
        }
        return roleBuilder.build(error);
    }

    @Nullable
    public RoleConfig get(String name) {
        return this.roles.get(name);
    }

    @Override
    @NotNull
    public Iterator<Pair<String, RoleConfig>> iterator() {
        return Iterators.transform(this.roleOrder.iterator(), name -> Pair.of((Object)name, (Object)this.roles.get(name)));
    }

    static final class Builder {
        private final Map<String, RoleConfig> roles = new Object2ObjectOpenHashMap();
        private final List<String> roleOrder = new ArrayList<String>();

        Builder() {
        }

        public Builder add(String name, RoleConfig role) {
            this.roles.put(name, role);
            this.roleOrder.add(name);
            return this;
        }

        public RoleConfigMap build(ConfigErrorConsumer error) {
            Map<String, RoleConfig> roles = this.roles;
            List<String> order = this.sortRoles();
            roles = this.resolveIncludes(roles, order, error);
            return new RoleConfigMap(roles, order);
        }

        private Map<String, RoleConfig> resolveIncludes(Map<String, RoleConfig> roles, List<String> order, ConfigErrorConsumer error) {
            Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap(roles.size());
            for (String name : order) {
                RoleConfig role = roles.get(name);
                RoleOverrideMap resolvedOverrides = new RoleOverrideMap();
                resolvedOverrides.addAll(role.overrides);
                for (String include : role.includes) {
                    RoleConfig includeRole = (RoleConfig)result.get(include);
                    if (includeRole != null) {
                        resolvedOverrides.addAll(includeRole.overrides);
                        continue;
                    }
                    if (roles.containsKey(include)) {
                        error.report("'" + name + "' tried to include '" + include + "' but it is of a higher level");
                        continue;
                    }
                    error.report("'" + name + "' tried to include '" + include + "' but it does not exist");
                }
                result.put(name, new RoleConfig(role.level, resolvedOverrides, new String[0], role.apply));
            }
            return result;
        }

        private List<String> sortRoles() {
            ArrayList<String> roleOrder = new ArrayList<String>(this.roleOrder);
            Collections.reverse(roleOrder);
            roleOrder.sort(Comparator.comparingInt(name -> {
                RoleConfig role = this.roles.get(name);
                return role.level;
            }));
            return roleOrder;
        }
    }
}

