/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import dev.gegy.roles.api.override.RoleOverrideReader;
import dev.gegy.roles.api.override.RoleOverrideType;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.codecs.MoreCodecs;

public final class RoleOverrideMap
implements RoleOverrideReader {
    public static final Codec<RoleOverrideMap> CODEC = MoreCodecs.dispatchByMapKey((Codec)RoleOverrideType.REGISTRY, t -> MoreCodecs.listOrUnit((Codec)t.getCodec())).xmap(RoleOverrideMap::new, m -> m.overrides);
    private final Map<RoleOverrideType<?>, List<Object>> overrides;

    public RoleOverrideMap() {
        this.overrides = new Reference2ObjectOpenHashMap();
    }

    private RoleOverrideMap(Map<RoleOverrideType<?>, List<Object>> overrides) {
        this.overrides = new Reference2ObjectOpenHashMap(overrides);
    }

    public void notifyChange(class_3222 player) {
        for (RoleOverrideType<?> override : this.overrides.keySet()) {
            override.notifyChange(player);
        }
    }

    @NotNull
    public <T> List<T> get(RoleOverrideType<T> type) {
        return this.overrides.getOrDefault(type, (List<Object>)ImmutableList.of());
    }

    @Nullable
    public <T> List<T> getOrNull(RoleOverrideType<T> type) {
        return this.overrides.get(type);
    }

    public Set<RoleOverrideType<?>> typeSet() {
        return this.overrides.keySet();
    }

    public void clear() {
        this.overrides.clear();
    }

    public void addAll(RoleOverrideReader overrides) {
        for (RoleOverrideType type : overrides.typeSet()) {
            this.addAllUnchecked(type, overrides.get(type));
        }
    }

    private <T> void addAllUnchecked(RoleOverrideType<T> type, Collection<?> overrides) {
        this.getOrCreateOverrides(type).addAll(overrides);
    }

    public <T> void addAll(RoleOverrideType<T> type, Collection<T> overrides) {
        this.getOrCreateOverrides(type).addAll(overrides);
    }

    public <T> void add(RoleOverrideType<T> type, T override) {
        this.getOrCreateOverrides(type).add(override);
    }

    private <T> List<T> getOrCreateOverrides(RoleOverrideType<T> type) {
        return this.overrides.computeIfAbsent(type, t -> new ArrayList());
    }
}

