/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.store;

import dev.gegy.roles.config.PlayerRolesConfig;
import dev.gegy.roles.store.PlayerRoleSet;
import dev.gegy.roles.store.db.PlayerRoleDatabase;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2499;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class PlayerRoleManager {
    private static PlayerRoleManager instance;
    private final PlayerRoleDatabase database;
    private final Map<UUID, PlayerRoleSet> onlinePlayerRoles = new Object2ObjectOpenHashMap();

    private PlayerRoleManager(PlayerRoleDatabase database) {
        this.database = database;
    }

    public static void setup() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            instance = PlayerRoleManager.open(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            PlayerRoleManager instance = instance;
            if (instance != null) {
                instance = null;
                instance.close(server);
            }
        });
    }

    private static PlayerRoleManager open(MinecraftServer server) {
        try {
            Path path = server.method_27050(class_5218.field_24182).resolve("player_roles");
            PlayerRoleDatabase database = PlayerRoleDatabase.open(path);
            return new PlayerRoleManager(database);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to open player roles database");
        }
    }

    public static PlayerRoleManager get() {
        return Objects.requireNonNull(instance, "player role manager not initialized");
    }

    public void onPlayerJoin(class_3222 player) {
        PlayerRolesConfig config = PlayerRolesConfig.get();
        PlayerRoleSet roles = new PlayerRoleSet(config.everyone(), player);
        this.database.tryLoadInto(player.method_5667(), roles);
        this.onlinePlayerRoles.put(player.method_5667(), roles);
    }

    public void onPlayerLeave(class_3222 player) {
        PlayerRoleSet roles = this.onlinePlayerRoles.remove(player.method_5667());
        if (roles != null && roles.isDirty()) {
            this.database.trySave(player.method_5667(), roles);
            roles.setDirty(false);
        }
    }

    public void onRoleReload(MinecraftServer server, PlayerRolesConfig config) {
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerRoleSet newRoles = new PlayerRoleSet(config.everyone(), player);
            PlayerRoleSet oldRoles = this.onlinePlayerRoles.put(player.method_5667(), newRoles);
            if (oldRoles == null) continue;
            newRoles.reloadFrom(config, oldRoles);
            newRoles.rebuildOverridesAndNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(MinecraftServer server) {
        try {
            for (class_3222 player : server.method_3760().method_14571()) {
                this.onPlayerLeave(player);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.database);
        }
    }

    public void addLegacyRoles(class_3222 player, class_2499 nbt) {
        PlayerRoleSet roles = this.onlinePlayerRoles.get(player.method_5667());
        if (roles != null) {
            roles.deserialize(PlayerRolesConfig.get(), nbt);
            roles.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R updateRoles(MinecraftServer server, UUID uuid, Function<PlayerRoleSet, R> update) {
        PlayerRoleSet roles = this.onlinePlayerRoles.get(uuid);
        if (roles != null) {
            return update.apply(roles);
        }
        roles = this.loadOfflinePlayerRoles(uuid);
        try {
            R r = update.apply(roles);
            return r;
        }
        finally {
            if (roles.isDirty()) {
                this.database.trySave(uuid, roles);
            }
        }
    }

    public PlayerRoleSet peekRoles(MinecraftServer server, UUID uuid) {
        PlayerRoleSet roles = this.onlinePlayerRoles.get(uuid);
        return roles != null ? roles : this.loadOfflinePlayerRoles(uuid);
    }

    private PlayerRoleSet loadOfflinePlayerRoles(UUID uuid) {
        PlayerRolesConfig config = PlayerRolesConfig.get();
        PlayerRoleSet roles = new PlayerRoleSet(config.everyone(), null);
        this.database.tryLoadInto(uuid, roles);
        return roles;
    }

    @Nullable
    public PlayerRoleSet getOnlinePlayerRoles(class_1297 entity) {
        if (entity instanceof class_1657) {
            return this.onlinePlayerRoles.get(entity.method_5667());
        }
        return null;
    }
}

