/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie;

import com.google.common.base.CaseFormat;
import de.siphalor.mousewheelie.client.MWClient;
import de.siphalor.mousewheelie.client.inventory.sort.SortMode;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.util.CreativeSearchOrder;
import de.siphalor.mousewheelie.client.util.ItemStackUtils;
import de.siphalor.tweed4.annotated.AConfigBackground;
import de.siphalor.tweed4.annotated.AConfigConstraint;
import de.siphalor.tweed4.annotated.AConfigEntry;
import de.siphalor.tweed4.annotated.AConfigFixer;
import de.siphalor.tweed4.annotated.AConfigListener;
import de.siphalor.tweed4.annotated.ATweedConfig;
import de.siphalor.tweed4.config.ConfigEnvironment;
import de.siphalor.tweed4.config.ConfigScope;
import de.siphalor.tweed4.config.constraints.RangeConstraint;
import de.siphalor.tweed4.data.DataList;
import de.siphalor.tweed4.data.DataObject;
import de.siphalor.tweed4.data.DataValue;

@ATweedConfig(environment=ConfigEnvironment.CLIENT, scope=ConfigScope.SMALLEST, tailors={"tweed4:lang_json_descriptions", "tweed4:coat"}, casing=CaseFormat.LOWER_HYPHEN)
@AConfigBackground(value="textures/block/green_concrete_powder.png")
public class MWConfig {
    @AConfigEntry(comment="General settings")
    public static General general = new General();
    public static Scrolling scrolling = new Scrolling();
    public static Sort sort = new Sort();
    public static Refill refill = new Refill();
    public static ToolPicking toolPicking = new ToolPicking();

    @AConfigFixer
    public <V extends DataValue<V, L, O>, L extends DataList<V, L, O>, O extends DataObject<V, L, O>> void fixConfig(O dataObject, O rootObject) {
        if (dataObject.has("general") && dataObject.get("general").isObject()) {
            DataObject general = dataObject.get("general").asObject();
            this.moveConfigEntry(dataObject, general, "enable-item-scrolling", "scrolling");
            this.moveConfigEntry(dataObject, general, "scroll-factor", "scrolling");
            this.moveConfigEntry(dataObject, general, "directional-scrolling", "scrolling");
            if (dataObject.has("scrolling") && dataObject.get("scrolling").isObject()) {
                DataObject scrolling = dataObject.get("scrolling").asObject();
                if (scrolling.has("scroll-creative-menu") && scrolling.get("scroll-creative-menu").isBoolean()) {
                    scrolling.set("scroll-creative-menu-items", !scrolling.get("scroll-creative-menu").asBoolean());
                    scrolling.remove("scroll-creative-menu");
                }
                if (scrolling.has("scroll-factor") && scrolling.get("scroll-factor").isNumber()) {
                    scrolling.set("invert", scrolling.get("scroll-factor").asFloat() < 0.0f);
                    scrolling.remove("scroll-factor");
                }
            }
            this.moveConfigEntry(dataObject, general, "hold-tool-pick", "tool-picking", "hold-tool");
            this.moveConfigEntry(dataObject, general, "hold-block-tool-pick", "tool-picking", "hold-block");
            this.moveConfigEntry(dataObject, general, "enable-alt-dropping", "general", "enable-drop-modifier");
            general.remove("hotbar-scope");
        }
    }

    @AConfigFixer(value="sort")
    public <V extends DataValue<V, L, O>, L extends DataList<V, L, O>, O extends DataObject<V, L, O>> void fixSortModes(O sort, O mainConfig) {
        if (!sort.has("optimize-creative-search-sort")) {
            if (sort.getString((Object)"primary-sort", "").equalsIgnoreCase("raw_id")) {
                sort.set("primary-sort", "creative");
            }
            if (sort.getString((Object)"shift-sort", "").equalsIgnoreCase("raw_id")) {
                sort.set("shift-sort", "creative");
            }
            if (sort.getString((Object)"control-sort", "").equalsIgnoreCase("raw_id")) {
                sort.set("control-sort", "creative");
            }
        }
    }

    private <V extends DataValue<V, L, O>, L extends DataList<V, L, O>, O extends DataObject<V, L, O>> void moveConfigEntry(O root, O origin, String name, String destCat) {
        this.moveConfigEntry(root, origin, name, destCat, name);
    }

    private <V extends DataValue<V, L, O>, L extends DataList<V, L, O>, O extends DataObject<V, L, O>> void moveConfigEntry(O root, O origin, String name, String destCat, String newName) {
        if (origin.has(name)) {
            DataObject dest = root.has(destCat) && root.get(destCat).isObject() ? root.get(destCat).asObject() : root.addObject(destCat);
            dest.set(newName, origin.get(name));
            origin.remove(name);
        }
    }

    @AConfigBackground(value="textures/block/acacia_log.png")
    public static class General {
        @AConfigEntry(constraints={@AConfigConstraint(value=RangeConstraint.class, param="1..")})
        public int interactionRate = 10;
        @AConfigEntry(constraints={@AConfigConstraint(value=RangeConstraint.class, param="1..")})
        public int integratedInteractionRate = 1;
        @AConfigEntry(environment=ConfigEnvironment.UNIVERSAL)
        public boolean enableQuickArmorSwapping = true;
        public boolean enableDropModifier = true;
        public boolean enableQuickCraft = true;
        @AConfigEntry(comment="Whether item types should check nbt data.\nThis is for example used by scrolling and drop-clicking.\nNONE disables this, ALL checks for exactly the same nbt and SOME allows for differences in damage and enchantments.")
        public ItemStackUtils.NbtMatchMode itemKindsNbtMatchMode = ItemStackUtils.NbtMatchMode.SOME;
        public HotbarScoping hotbarScoping = HotbarScoping.SOFT;
        public boolean betterFastDragging = false;
        @AConfigEntry(comment="Enables dragging bundles while holding right-click to pick up or put out multiple stacks in a single swipe.")
        public boolean enableBundleDragging = true;

        @AConfigListener(value="interaction-rate")
        public void onReloadInteractionRate() {
            if (!MWClient.isOnLocalServer()) {
                InteractionManager.setTickRate(this.interactionRate);
            }
        }

        @AConfigListener(value="integrated-interaction-rate")
        public void onReloadIntegratedInteractionRate() {
            if (MWClient.isOnLocalServer()) {
                InteractionManager.setTickRate(this.integratedInteractionRate);
            }
        }

        public static enum HotbarScoping {
            HARD,
            SOFT,
            NONE;

        }
    }

    @AConfigBackground(value="textures/block/dark_prismarine.png")
    public static class Scrolling {
        public boolean enable = true;
        public boolean invert = false;
        public boolean directionalScrolling = true;
        public boolean scrollCreativeMenuItems = true;
        public boolean scrollCreativeMenuTabs = true;
    }

    @AConfigBackground(value="textures/block/barrel_top.png")
    public static class Sort {
        public SortMode primarySort = SortMode.CREATIVE;
        public SortMode shiftSort = SortMode.QUANTITY;
        public SortMode controlSort = SortMode.ALPHABET;
        public boolean serverAcceleratedSorting = true;
        @AConfigEntry(scope=ConfigScope.SMALLEST)
        public boolean optimizeCreativeSearchSort = true;

        @AConfigListener(value="optimize-creative-search-sort")
        public void onReloadOptimizeCreativeSearchSort() {
            CreativeSearchOrder.refreshItemSearchPositionLookup();
        }
    }

    @AConfigBackground(value="textures/block/horn_coral_block.png")
    public static class Refill {
        public boolean enable = true;
        public boolean playSound = true;
        public boolean offHand = true;
        public boolean restoreSelectedSlot = false;
        public boolean itemChanges = true;
        public boolean eat = true;
        public boolean drop = true;
        public boolean use = true;
        public boolean other = true;
        public Rules rules = new Rules();

        @AConfigBackground(value="textures/block/yellow_terracotta.png")
        public static class Rules {
            public boolean anyBlock = false;
            public boolean itemgroup = false;
            public boolean itemHierarchy = false;
            public boolean blockHierarchy = false;
            public boolean food = false;
            public boolean equalItems = true;
            public boolean equalStacks = true;
        }
    }

    @AConfigBackground(value="textures/block/coarse_dirt.png")
    public static class ToolPicking {
        public boolean holdTool = true;
        public boolean holdBlock = false;
        public boolean pickFromInventory = true;
    }
}

