/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory.sort;

import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.client.inventory.sort.SortContext;
import de.siphalor.mousewheelie.client.util.CreativeSearchOrder;
import de.siphalor.mousewheelie.client.util.ItemStackUtils;
import de.siphalor.mousewheelie.client.util.StackMatcher;
import de.siphalor.tweed4.tailor.DropdownMaterial;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public abstract class SortMode
implements DropdownMaterial<SortMode> {
    private static final Map<String, SortMode> SORT_MODES = new HashMap<String, SortMode>();
    private final String name;
    public static final SortMode NONE = SortMode.register("none", new SortMode("none"){});
    public static final SortMode ALPHABET = SortMode.register("alphabet", new SortMode("alphabet"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            String[] strings = new String[sortIds.length];
            for (int i = 0; i < sortIds.length; ++i) {
                class_1799 stack = stacks[i];
                strings[i] = stack.method_7960() ? "" : stack.method_7964().getString();
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                if (strings[a].equals("")) {
                    if (strings[b].equals("")) {
                        return 0;
                    }
                    return 1;
                }
                if (strings[b].equals("")) {
                    return -1;
                }
                int comp = strings[a].compareToIgnoreCase(strings[b]);
                if (comp == 0) {
                    return ItemStackUtils.compareEqualItems(stacks[a], stacks[b]);
                }
                return comp;
            });
            return sortIds;
        }
    });
    public static final SortMode CREATIVE = SortMode.register("creative", new SortMode("creative"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            int[] sortValues = new int[sortIds.length];
            if (MWConfig.sort.optimizeCreativeSearchSort) {
                Lock lock = CreativeSearchOrder.getReadLock();
                lock.lock();
                for (int i = 0; i < stacks.length; ++i) {
                    sortValues[i] = CreativeSearchOrder.getStackSearchPosition(stacks[i]);
                }
                lock.unlock();
            } else {
                Collection displayStacks = class_7706.method_47344().method_47313();
                ArrayList displayStackList = displayStacks instanceof List ? (ArrayList)displayStacks : new ArrayList(displayStacks);
                Object2IntOpenHashMap lookup = new Object2IntOpenHashMap(stacks.length);
                for (int i = 0; i < stacks.length; ++i) {
                    class_1799 stack = stacks[i];
                    sortValues[i] = lookup.computeIfAbsent((Object)StackMatcher.of(stack), arg_0 -> 3.lambda$sort$1(displayStackList, (Object2IntMap)lookup, stack, arg_0));
                }
            }
            SortMode.sortByValues(sortIds, stacks, sortValues);
            return sortIds;
        }

        private static /* synthetic */ int lambda$sort$1(List displayStackList, Object2IntMap lookup, class_1799 stack, Object matcher) {
            int index = displayStackList.indexOf(matcher);
            if (index == -1) {
                return lookup.computeIfAbsent((Object)StackMatcher.ignoreNbt(stack), matcher2 -> {
                    int plainIndex = displayStackList.indexOf(matcher2);
                    if (plainIndex == -1) {
                        return Integer.MAX_VALUE;
                    }
                    return plainIndex;
                });
            }
            return index;
        }
    });
    public static final SortMode QUANTITY = SortMode.register("quantity", new SortMode("quantity"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            HashMap<class_1792, Integer> itemToAmountMap = new HashMap<class_1792, Integer>();
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                if (!itemToAmountMap.containsKey(stack.method_7909())) {
                    itemToAmountMap.put(stack.method_7909(), stack.method_7947());
                    continue;
                }
                itemToAmountMap.put(stack.method_7909(), (Integer)itemToAmountMap.get(stack.method_7909()) + stack.method_7947());
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                class_1799 stack = stacks[a];
                class_1799 stack2 = stacks[b];
                if (stack.method_7960()) {
                    return stack2.method_7960() ? 0 : 1;
                }
                if (stack2.method_7960()) {
                    return -1;
                }
                Integer amountA = (Integer)itemToAmountMap.get(stack.method_7909());
                Integer amountB = (Integer)itemToAmountMap.get(stack2.method_7909());
                int cmp = Integer.compare(amountB, amountA);
                if (cmp != 0) {
                    return cmp;
                }
                return ItemStackUtils.compareEqualItems(stack, stack2);
            });
            return sortIds;
        }
    });
    public static final SortMode RAW_ID = SortMode.register("raw_id", new SortMode("raw_id"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            int[] rawIds = Arrays.stream(stacks).mapToInt(stack -> stack.method_7960() ? Integer.MAX_VALUE : class_7923.field_41178.method_10206((Object)stack.method_7909())).toArray();
            SortMode.sortByValues(sortIds, stacks, rawIds);
            return sortIds;
        }
    });

    public static <T extends SortMode> T register(String name, T sortMode) {
        SORT_MODES.put(name, sortMode);
        return sortMode;
    }

    public static void unregister(String name) {
        SORT_MODES.remove(name);
    }

    protected SortMode(String name) {
        this.name = name;
    }

    public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
        return sortIds;
    }

    public DropdownMaterial<SortMode> valueOf(String s) {
        return SORT_MODES.get(s);
    }

    public Collection<SortMode> values() {
        return SORT_MODES.values();
    }

    public String name() {
        return this.name;
    }

    public String getTranslationKey() {
        return "mousewheelie.sortmode." + this.name.toLowerCase(Locale.ENGLISH);
    }

    private static void sortByValues(int[] sortIds, class_1799[] stacks, int[] values) {
        IntArrays.quickSort((int[])sortIds, (a, b) -> {
            int cmp = Integer.compare(values[a], values[b]);
            if (cmp != 0) {
                return cmp;
            }
            return ItemStackUtils.compareEqualItems(stacks[a], stacks[b]);
        });
    }
}

