/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import com.luciad.imageio.webp.WebP;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.compat.FirstPersonModelCompat;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.SyncConfigPacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureItemRenderer;

public class CameraptureClient {
    public static final float MIN_ZOOM = 1.0f;
    public static final float MAX_ZOOM = 6.0f;
    public static final PictureItemRenderer PICTURE_ITEM_RENDERER = new PictureItemRenderer();
    public static boolean replayModInstalled = false;

    public static void init() {
        ImageIO.scanForPlugins();
        if (!WebP.loadNativeLibrary()) {
            Camerapture.LOGGER.error("failed to load ImageIO-WebP, pictures might not work!");
        }
        ClientPictureStore.getInstance().clear();
        PictureTaker.getInstance().configureFromConfig();
        if (Camerapture.PLATFORM.isModLoaded("firstperson")) {
            FirstPersonModelCompat.register();
        }
        if (Camerapture.PLATFORM.isModLoaded("replay-mod")) {
            Camerapture.LOGGER.info("Replay Mod is detected, Camerapture will cache pictures, regardless of config.");
            replayModInstalled = true;
        }
    }

    public static void registerPacketHandlers() {
        Camerapture.NETWORK.onReceiveFromServer(RequestUploadPacket.class, packet -> Camerapture.EXECUTOR.execute(() -> PictureTaker.getInstance().uploadStoredPicture(packet.uuid())));
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        Camerapture.NETWORK.onReceiveFromServer(DownloadPartialPicturePacket.class, packet -> {
            ByteCollector collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                collectors.remove(uuid);
                Camerapture.EXECUTOR.execute(() -> ClientPictureStore.getInstance().processReceivedBytes((UUID)uuid, (byte[])bytes));
            }));
            if (!collector.push(packet.bytes(), packet.bytesLeft())) {
                Camerapture.LOGGER.error("received malformed byte section from server");
                ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            }
        });
        Camerapture.NETWORK.onReceiveFromServer(PictureErrorPacket.class, packet -> {
            ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            collectors.remove(packet.uuid());
        });
        Camerapture.NETWORK.onReceiveFromServer(SyncConfigPacket.class, packet -> PictureTaker.getInstance().configure(packet.maxImageBytes(), packet.maxImageResolution()));
    }
}

