/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.fabric;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.net.NetCodec;
import me.chrr.camerapture.net.NetworkAdapter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkAdapter
implements NetworkAdapter {
    private final Map<Class<?>, ServerPacketType<?>> serverPackets = new HashMap();
    private final Map<Class<?>, ClientPacketType<?>> clientPackets = new HashMap();

    public <P> void registerServerBound(Class<P> clazz, NetCodec<P> netCodec) {
        ClientPacketType type = new ClientPacketType(netCodec, new ArrayList());
        this.clientPackets.put(clazz, type);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)netCodec.id(), (server, player, networkHandler, buf, sender) -> {
            Object packet = FabricNetworkAdapter.decodePacket(buf, type.netCodec());
            if (packet != null) {
                type.handlers().forEach(handler -> handler.accept(packet, player));
            }
        });
    }

    public <P> void registerClientBound(Class<P> clazz, NetCodec<P> netCodec) {
        ServerPacketType type = new ServerPacketType(netCodec, new ArrayList());
        this.serverPackets.put(clazz, type);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)type.netCodec().id(), (client, networkHandler, buf, sender) -> {
                Object packet = FabricNetworkAdapter.decodePacket(buf, type.netCodec());
                if (packet != null) {
                    type.handlers().forEach(handler -> handler.accept(packet));
                }
            });
        }
    }

    @Override
    public <P> void sendToClient(class_3222 player, P packet) {
        ServerPacketType<?> type = this.getServerPacketType(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        FabricNetworkAdapter.encodePacket(packet, buf, type.netCodec());
        ServerPlayNetworking.send((class_3222)player, (class_2960)type.netCodec().id(), (class_2540)buf);
    }

    @Override
    public <P> void onReceiveFromClient(Class<P> clazz, BiConsumer<P, class_3222> handler) {
        this.getClientPacketType(clazz).handlers().add(handler);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public <P> void sendToServer(P packet) {
        ClientPacketType<?> type = this.getClientPacketType(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        FabricNetworkAdapter.encodePacket(packet, buf, type.netCodec());
        ClientPlayNetworking.send((class_2960)type.netCodec().id(), (class_2540)buf);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public <P> void onReceiveFromServer(Class<P> clazz, Consumer<P> handler) {
        this.getServerPacketType(clazz).handlers().add(handler);
    }

    private static <P> void encodePacket(P packet, class_2540 buf, NetCodec<P> netCodec) {
        MapCodec dataCodec = netCodec.codec().fieldOf("data");
        DataResult result = dataCodec.encoder().encodeStart((DynamicOps)class_2509.field_11560, packet);
        buf.method_10794((class_2487)result.get().left().orElseThrow());
    }

    @Nullable
    private static <P> P decodePacket(class_2540 buf, NetCodec<P> netCodec) {
        MapCodec dataCodec = netCodec.codec().fieldOf("data");
        DataResult result = dataCodec.decoder().decode((DynamicOps)class_2509.field_11560, (Object)buf.method_10798());
        if (result.error().isPresent()) {
            Camerapture.LOGGER.error("failed to decode packet: {}", (Object)((DataResult.PartialResult)result.error().get()).message());
            return null;
        }
        return (P)((Pair)result.result().orElseThrow()).getFirst();
    }

    private <P> ServerPacketType<P> getServerPacketType(Class<P> clazz) {
        ServerPacketType<?> type = this.serverPackets.get(clazz);
        return type;
    }

    private <P> ClientPacketType<P> getClientPacketType(Class<P> clazz) {
        ClientPacketType<?> type = this.clientPackets.get(clazz);
        return type;
    }

    private record ClientPacketType<P>(NetCodec<P> netCodec, List<BiConsumer<P, class_3222>> handlers) {
    }

    private record ServerPacketType<P>(NetCodec<P> netCodec, List<Consumer<P>> handlers) {
    }
}

